/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.launch.BuildDockerImageUtils;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class BuildDockerImageLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private final String TAB_NAME = "BuildDockerImageLaunchConfigurationMainTab.name";
    private final String CONNECTION_LABEL = "BuildDockerImageLaunchConfigurationMainTab.connection.group.label";
    private final String CONNECTION_TOOLTIP = "BuildDockerImageLaunchConfigurationMainTab.connection.group.tooltip";
    private final String CONNECTION_MISSING = "BuildDockerImageLaunchConfigurationMainTab.connection.missing";
    private final String BUILD_CONTEXT_PATH_LABEL = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.group.label";
    private final String BUILD_CONTEXT_PATH_MISSING = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.missing";
    private final String BUILD_CONTEXT_PATH_MISSING_DOCKERFILE = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.missingDockerfile";
    private final String BROWSE_WORKSPACE = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browseworkspace.button.label";
    private final String BROWSE_WORKSPACE_DIALOG_TITLE = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browseworkspace.dialog.title";
    private final String BROWSE_FILESYSTEM = "BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browsefilesystem.button.label";
    private final String DOCKERFILE_NAME_LABEL = "BuildDockerImageLaunchConfigurationMainTab.dockerfileName.label";
    private final String REPO_NAME_LABEL = "BuildDockerImageLaunchConfigurationMainTab.repoName.label";
    private final String REPO_NAME_MISSING = "BuildDockerImageLaunchConfigurationMainTab.repoName.missing";
    private final String OPTIONS_LABEL = "BuildDockerImageLaunchConfigurationMainTab.options.group.label";
    private final String OPTION_QUIET_LABEL = "BuildDockerImageLaunchConfigurationMainTab.options.quiet.button.label";
    private final String OPTION_NOCACHE_LABEL = "BuildDockerImageLaunchConfigurationMainTab.options.noCache.button.label";
    private final String OPTION_RM_LABEL = "BuildDockerImageLaunchConfigurationMainTab.options.rm.button.label";
    private final String OPTION_FORCERM_LABEL = "BuildDockerImageLaunchConfigurationMainTab.options.forceRM.button.label";
    private ComboViewer connectionSelectionComboViewer;
    private Text buildContextPathText;
    private boolean buildContextPathWorkspaceRelative;
    private Text repoNameText;
    private Text dockerfileNameText;
    private Button noCacheButton;
    private Button quietBuildButton;
    private Button removeIntermediateContainersButton;
    private Button alwaysRemoveIntermediateContainersButton;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(6, 6).applyTo(container);
        this.setControl((Control)container);
        Group connectionGroup = new Group(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)connectionGroup);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo((Composite)connectionGroup);
        connectionGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.connection.group.label"));
        connectionGroup.setToolTipText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.connection.group.tooltip"));
        Combo connectionSelectionCombo = new Combo((Composite)connectionGroup, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)connectionSelectionCombo);
        this.connectionSelectionComboViewer = new ComboViewer(connectionSelectionCombo);
        this.connectionSelectionComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.connectionSelectionComboViewer.setInput((Object)DockerConnectionManager.getInstance().getConnectionNames());
        connectionSelectionCombo.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
        this.createBuildContextPathGroup(container);
        this.createRepoNameGroup(container);
        this.createDockerfileNameGroup(container);
        this.createBuildOptionsGroup(container);
    }

    private void createBuildContextPathGroup(Composite container) {
        Group buildContextPathLocationGroup = new Group(container, 2048);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)buildContextPathLocationGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(3).applyTo((Composite)buildContextPathLocationGroup);
        buildContextPathLocationGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.group.label"));
        this.buildContextPathText = new Text((Composite)buildContextPathLocationGroup, 2048);
        this.buildContextPathText.addModifyListener((ModifyListener)new LaunchConfigurationChangeListener());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.buildContextPathText);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)new Label((Composite)buildContextPathLocationGroup, 0));
        Button browseWorkspaceButton = new Button((Composite)buildContextPathLocationGroup, 0);
        browseWorkspaceButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browseworkspace.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseWorkspaceButton);
        browseWorkspaceButton.addSelectionListener(this.onBrowseWorkspace(this.buildContextPathText, IContainer.class));
        Button browseFileSystemButton = new Button((Composite)buildContextPathLocationGroup, 0);
        browseFileSystemButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browsefilesystem.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)browseFileSystemButton);
        browseFileSystemButton.addSelectionListener(this.onBrowseFileSystemForDirectory(this.buildContextPathText));
    }

    private void createRepoNameGroup(Composite container) {
        Group repoNameGroup = new Group(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)repoNameGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(1).applyTo((Composite)repoNameGroup);
        repoNameGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.repoName.label"));
        this.repoNameText = new Text((Composite)repoNameGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.repoNameText);
        this.repoNameText.addModifyListener((ModifyListener)new LaunchConfigurationChangeListener());
    }

    private void createDockerfileNameGroup(Composite container) {
        Group dockerfileNameGroup = new Group(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)dockerfileNameGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(1).applyTo((Composite)dockerfileNameGroup);
        dockerfileNameGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.dockerfileName.label"));
        this.dockerfileNameText = new Text((Composite)dockerfileNameGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.dockerfileNameText);
        this.dockerfileNameText.addModifyListener((ModifyListener)new LaunchConfigurationChangeListener());
    }

    private void createBuildOptionsGroup(Composite container) {
        Group optionsGroup = new Group(container, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)optionsGroup);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo((Composite)optionsGroup);
        optionsGroup.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.options.group.label"));
        this.quietBuildButton = new Button((Composite)optionsGroup, 32);
        this.quietBuildButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.options.quiet.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.quietBuildButton);
        this.quietBuildButton.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
        this.noCacheButton = new Button((Composite)optionsGroup, 32);
        this.noCacheButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.options.noCache.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.noCacheButton);
        this.noCacheButton.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
        this.removeIntermediateContainersButton = new Button((Composite)optionsGroup, 32);
        this.removeIntermediateContainersButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.options.rm.button.label"));
        this.removeIntermediateContainersButton.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.removeIntermediateContainersButton);
        this.alwaysRemoveIntermediateContainersButton = new Button((Composite)optionsGroup, 32);
        this.alwaysRemoveIntermediateContainersButton.setText(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.options.forceRM.button.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).applyTo((Control)this.alwaysRemoveIntermediateContainersButton);
        this.alwaysRemoveIntermediateContainersButton.addSelectionListener(this.onAlwaysRemoveIntermediateContainers());
        this.alwaysRemoveIntermediateContainersButton.addSelectionListener((SelectionListener)new LaunchConfigurationChangeListener());
    }

    private SelectionListener onAlwaysRemoveIntermediateContainers() {
        return SelectionListener.widgetSelectedAdapter(e -> this.toggleRemoveIntermediateContainersButtonState());
    }

    private SelectionListener onBrowseWorkspace(Text pathText, Class<?> expectedType) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setTitle(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.browseworkspace.dialog.title"));
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            dialog.setAllowMultiple(false);
            dialog.setValidator(selection -> {
                if (selection.length == 1 && expectedType.isAssignableFrom(selection[0].getClass())) {
                    return new Status(0, "org.eclipse.linuxtools.docker.ui", null);
                }
                return new Status(4, "org.eclipse.linuxtools.docker.ui", null);
            });
            if (dialog.open() == 0) {
                IResource selection2 = (IResource)dialog.getFirstResult();
                pathText.setText(selection2.getFullPath().toOSString());
                this.buildContextPathWorkspaceRelative = true;
            }
        });
    }

    private SelectionListener onBrowseFileSystemForDirectory(Text pathText) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.getShell());
            String selection = dialog.open();
            if (selection != null) {
                pathText.setText(selection);
                this.buildContextPathWorkspaceRelative = false;
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.connectionSelectionComboViewer.setSelection((ISelection)new StructuredSelection((Object)configuration.getAttribute("dockerConnection", "")));
            this.buildContextPathText.setText(configuration.getAttribute("sourcePathLocation", ""));
            this.buildContextPathWorkspaceRelative = configuration.getAttribute("sourcePathWorkspaceRelativeLocation", false);
            this.dockerfileNameText.setText(configuration.getAttribute("dockerfileName", "Dockerfile"));
            this.repoNameText.setText(configuration.getAttribute("repoName", ""));
            this.quietBuildButton.setSelection(configuration.getAttribute("quietBuild", false));
            this.noCacheButton.setSelection(configuration.getAttribute("noCache", false));
            this.removeIntermediateContainersButton.setSelection(configuration.getAttribute("rm", false));
            this.alwaysRemoveIntermediateContainersButton.setSelection(configuration.getAttribute("forcerm", false));
            this.toggleRemoveIntermediateContainersButtonState();
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block9: {
            IPath sourcePath;
            String dockerfileName;
            block8: {
                String sourcePathLocation;
                block7: {
                    String dockerConnection = launchConfig.getAttribute("dockerConnection", "");
                    sourcePathLocation = launchConfig.getAttribute("sourcePathLocation", "");
                    dockerfileName = launchConfig.getAttribute("dockerfileName", "Dockerfile");
                    boolean sourcePathWorkspaceRelativeLocation = launchConfig.getAttribute("sourcePathWorkspaceRelativeLocation", false);
                    sourcePath = BuildDockerImageUtils.getPath(sourcePathLocation, sourcePathWorkspaceRelativeLocation);
                    if (!dockerConnection.isEmpty() && dockerConnection != null && DockerConnectionManager.getInstance().findConnection(dockerConnection) != null) break block7;
                    this.setErrorMessage(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.connection.missing"));
                    return false;
                }
                if (!sourcePathLocation.isEmpty() && sourcePath != null) break block8;
                this.setErrorMessage(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.missing"));
                return false;
            }
            if (sourcePath.append(dockerfileName).toFile().exists()) break block9;
            this.setErrorMessage(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.buildContextPath.missingDockerfile"));
            return false;
        }
        try {
            this.setErrorMessage(null);
            String repoName = launchConfig.getAttribute("repoName", "");
            if (repoName.isEmpty()) {
                this.setWarningMessage(LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.repoName.missing"));
            } else {
                this.setWarningMessage(null);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return super.isValid(launchConfig);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IStructuredSelection connectionSelection = (IStructuredSelection)this.connectionSelectionComboViewer.getSelection();
        if (connectionSelection.getFirstElement() != null) {
            configuration.setAttribute("dockerConnection", connectionSelection.getFirstElement().toString());
        }
        configuration.setAttribute("sourcePathLocation", this.buildContextPathText.getText());
        configuration.setAttribute("sourcePathWorkspaceRelativeLocation", this.buildContextPathWorkspaceRelative);
        if (!this.repoNameText.getText().isEmpty()) {
            configuration.setAttribute("repoName", this.repoNameText.getText());
        }
        if (!this.dockerfileNameText.getText().isEmpty()) {
            configuration.setAttribute("dockerfileName", this.dockerfileNameText.getText());
        }
        configuration.setAttribute("quietBuild", this.quietBuildButton.getSelection());
        configuration.setAttribute("noCache", this.noCacheButton.getSelection());
        configuration.setAttribute("rm", this.removeIntermediateContainersButton.getSelection());
        configuration.setAttribute("forcerm", this.alwaysRemoveIntermediateContainersButton.getSelection());
    }

    public String getName() {
        return LaunchMessages.getString("BuildDockerImageLaunchConfigurationMainTab.name");
    }

    private void toggleRemoveIntermediateContainersButtonState() {
        if (this.alwaysRemoveIntermediateContainersButton.getSelection()) {
            this.removeIntermediateContainersButton.setEnabled(false);
        } else {
            this.removeIntermediateContainersButton.setEnabled(true);
        }
    }

    private class LaunchConfigurationChangeListener
    extends SelectionAdapter
    implements ModifyListener {
        private LaunchConfigurationChangeListener() {
        }

        public void modifyText(ModifyEvent e) {
            BuildDockerImageLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            BuildDockerImageLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

