/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.consoles;

import java.io.IOException;
import java.util.stream.Stream;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.consoles.ConsoleMessages;
import org.eclipse.linuxtools.internal.docker.ui.consoles.StyledTextBuilder;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class DockerComposeConsole
extends IOConsole {
    public static final String CONSOLE_TYPE = "org.eclipse.linuxtools.internal.docker.ui.consoles.DockerComposeConsole";
    private final IDockerConnection connection;
    private final String workingDir;
    private IProcess dockerComposeProcess;

    public DockerComposeConsole(IDockerConnection connection, String workingDir) {
        super(ConsoleMessages.getFormattedString("DockerComposeConsole.title", workingDir), null);
        this.workingDir = workingDir;
        this.connection = connection;
        this.setType(CONSOLE_TYPE);
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public IProcess getDockerComposeProcess() {
        return this.dockerComposeProcess;
    }

    public void setDockerComposeProcess(IProcess dockerComposeProcess) {
        this.dockerComposeProcess = dockerComposeProcess;
        this.activate();
        this.clearConsole();
        this.writeContentInConsole(dockerComposeProcess.getStreamsProxy().getOutputStreamMonitor().getContents());
        dockerComposeProcess.getStreamsProxy().getOutputStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                DockerComposeConsole.this.writeContentInConsole(text);
            }
        });
        dockerComposeProcess.getStreamsProxy().getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                DockerComposeConsole.this.writeContentInConsole(text);
            }
        });
    }

    private void writeContentInConsole(String text) {
        Display.getDefault().asyncExec(() -> {
            StyledString styledString = StyledTextBuilder.parse(text);
            StyleRange[] styleRanges = styledString.getStyleRanges();
            Stream.of(styleRanges).forEach(range -> {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (IOConsoleOutputStream consoleStream = this.newOutputStream();){
                        consoleStream.setColor(range.foreground);
                        consoleStream.write(styledString.getString().substring(range.start, range.start + range.length).getBytes());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    Activator.log(e);
                }
            });
        });
    }
}

