/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.Helper;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;

public class SystemTapTextParser
extends SystemTapParser {
    protected String contents;

    @Override
    public IStatus nonRealTimeParsing() {
        this.contents = Helper.readFile(this.sourcePath);
        return Status.OK_STATUS;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public IStatus realTimeParsing() {
        BufferedReader buff = this.internalData;
        StringBuilder text = new StringBuilder();
        try {
            String line;
            while ((line = buff.readLine()) != null) {
                if (this.monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                text.append(String.valueOf(line) + "\n");
            }
            this.setData(text.toString());
            this.view.update();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }
}

