/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.validation.Validation;
import org.eclipse.libra.warproducts.core.validation.ValidationError;
import org.eclipse.libra.warproducts.core.validation.Validator;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.validation.IValidationListener;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.ProductValidationOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;

public class WARProductValidateAction
extends Action {
    IWARProduct product;
    List listeners;

    public WARProductValidateAction(IWARProduct product) {
        super(Messages.ValidateActionTitle, 1);
        this.setImageDescriptor(PDEPluginImages.DESC_VALIDATE_TOOL);
        this.product = product;
    }

    public void addValidationListener(IValidationListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void run() {
        HashMap map = new HashMap();
        IProductPlugin[] plugins = this.product.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getId();
            this.addBundleIfExisting(map, id);
            ++i;
        }
        this.validate(map);
    }

    private void addBundleIfExisting(HashMap map, String id) {
        IPluginModelBase model;
        if (id != null && !map.containsKey(id) && this.bundleExist(id, model = PluginRegistry.findModel((String)id))) {
            map.put(id, model);
        }
    }

    private boolean bundleExist(String id, IPluginModelBase model) {
        boolean matchesCurrentEnvironment;
        boolean result = false;
        if (model != null && (matchesCurrentEnvironment = TargetPlatformHelper.matchesCurrentEnvironment((IPluginModelBase)model))) {
            result = true;
        }
        return result;
    }

    private void validate(HashMap map) {
        try {
            IPluginModelBase[] array;
            IPluginModelBase[] baseModel = new IPluginModelBase[map.size()];
            IPluginModelBase[] models = array = map.values().toArray(baseModel);
            ProductValidationOperation operation = new ProductValidationOperation(models);
            operation.run((IProgressMonitor)new NullProgressMonitor());
            this.verifyResult((LaunchValidationOperation)operation);
        }
        catch (CoreException e) {
            PDEPlugin.logException((Throwable)e);
        }
    }

    private void verifyResult(LaunchValidationOperation operation) {
        Map errors = operation.getInput();
        this.varifyPDEErrors(errors);
        this.validateWarContent(errors);
        this.notifyListeners(errors);
    }

    private void notifyListeners(Map errors) {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                IValidationListener listener = (IValidationListener)this.listeners.get(i);
                listener.validationFinished(errors);
                ++i;
            }
        }
    }

    private void varifyPDEErrors(Map map) {
        Object[] keys = new Object[map.size()];
        map.keySet().toArray(keys);
        int i = 0;
        while (i < keys.length) {
            Object currentKey = keys[i];
            ResolverError[] errors = (ResolverError[])map.get(currentKey);
            ResolverError[] validErrors = this.validateErrors(errors);
            map.remove(currentKey);
            if (validErrors.length > 0) {
                map.put(currentKey, validErrors);
            }
            ++i;
        }
    }

    private ResolverError[] validateErrors(ResolverError[] errors) {
        ArrayList<ResolverError> validErrors = new ArrayList<ResolverError>();
        int i = 0;
        while (i < errors.length) {
            String unresolvedBundleId;
            ResolverError error = errors[i];
            VersionConstraint constraint = error.getUnsatisfiedConstraint();
            if (constraint != null && (unresolvedBundleId = constraint.getName()) != null && !this.isBanned(unresolvedBundleId) && !unresolvedBundleId.equals("org.eclipse.equinox.servletbridge")) {
                validErrors.add(error);
            }
            ++i;
        }
        ResolverError[] result = new ResolverError[validErrors.size()];
        validErrors.toArray(result);
        return result;
    }

    private boolean isBanned(String unresolvedBundleId) {
        boolean result = false;
        String[] bannedBundles = Validator.BANNED_BUNDLES;
        int i = 0;
        while (i < bannedBundles.length && !result) {
            if (unresolvedBundleId.indexOf(bannedBundles[i]) != -1) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void validateWarContent(Map map) {
        Validator validator = new Validator(this.product);
        Validation validation = validator.validate();
        if (!validation.isValid()) {
            this.handleWARValiadtionErrors(map, validation.getErrors());
        }
    }

    private void handleWARValiadtionErrors(Map map, ValidationError[] errors) {
        String key = Messages.ValidateAction;
        map.put(key, errors);
    }
}

