/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.processes;

import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.impl.ProcessesFactoryImpl;

public class CreateActivityEdgeCommand
extends AbstractCommand {
    private EditingDomain editingDomain;
    private ActivityNode conSource;
    private ActivityNode conTarget;
    private CompoundCommand createActivityEdgeCommand;
    private int maximumOutEdges = Integer.MAX_VALUE;
    private int maximumInEdges = Integer.MAX_VALUE;

    public CreateActivityEdgeCommand(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }

    public void setMaximumInEdges(int maximumInEdges) {
        this.maximumInEdges = maximumInEdges;
    }

    public void setMaximumOutEdges(int maximumOutEdges) {
        this.maximumOutEdges = maximumOutEdges;
    }

    public void setSource(ActivityNode source) {
        this.conSource = source;
    }

    public void setTarget(ActivityNode target) {
        this.conTarget = target;
    }

    public boolean checkMaxInOutConnections() {
        if (this.conTarget != null && this.conTarget.getIn().size() >= this.maximumInEdges) {
            return false;
        }
        return this.conSource == null || this.conSource.getOut().size() < this.maximumOutEdges;
    }

    public boolean checkConnection() {
        if (this.conSource == null || this.conTarget == null) {
            return false;
        }
        if (this.conSource == this.conTarget) {
            return false;
        }
        return this.checkMaxInOutConnections();
    }

    public boolean canExecute() {
        if (this.editingDomain == null) {
            return false;
        }
        return this.checkConnection();
    }

    public void execute() {
        ActivityEdge actEdge = ProcessesFactoryImpl.eINSTANCE.createActivityEdge();
        this.createActivityEdgeCommand = new CompoundCommand();
        this.createActivityEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)actEdge, (Object)ProcessesPackage.Literals.ACTIVITY_EDGE__SOURCE, (Object)this.conSource));
        this.createActivityEdgeCommand.append(SetCommand.create((EditingDomain)this.editingDomain, (Object)actEdge, (Object)ProcessesPackage.Literals.ACTIVITY_EDGE__TARGET, (Object)this.conTarget));
        this.createActivityEdgeCommand.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.conSource.eContainer(), (Object)ProcessesPackage.Literals.SCOPE__EDGES, Collections.singleton(actEdge)));
        if (this.createActivityEdgeCommand.canExecute()) {
            this.createActivityEdgeCommand.execute();
        }
    }

    public void undo() {
        this.createActivityEdgeCommand.undo();
    }

    public void redo() {
        this.createActivityEdgeCommand.redo();
    }

    public void dispose() {
        super.dispose();
        if (this.createActivityEdgeCommand != null) {
            this.createActivityEdgeCommand.dispose();
        }
    }
}

