/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ISliderComponent;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.swt.widgets.Slider;

public class SliderAdapter
extends ControlAdapter
implements ISliderComponent {
    private Slider m_slider;

    public SliderAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_slider = (Slider)objectToAdapt;
    }

    public String getPosition(final String units) {
        return (String)this.getEventThreadQueuer().invokeAndWait("getPosition", (IRunnable)new IRunnable<String>(){

            public String run() {
                int absValue = SliderAdapter.this.m_slider.getSelection();
                double value = units.equalsIgnoreCase(ValueSets.Measure.percent.rcValue()) ? (double)(100 * absValue / (SliderAdapter.this.m_slider.getMaximum() - SliderAdapter.this.m_slider.getMinimum())) : (double)absValue;
                return String.valueOf(value);
            }
        });
    }

    public void setPosition(final String position, String operator, final String units) {
        this.getEventThreadQueuer().invokeAndWait("setPosition", (IRunnable)new IRunnable<Void>(){

            public Void run() {
                int value = 0;
                try {
                    value = Integer.valueOf(position);
                }
                catch (NumberFormatException numberFormatException) {
                    SliderAdapter.this.throwInvalidInputMessage();
                }
                SliderAdapter.this.setValueProgrammatically(units, value);
                return null;
            }
        });
    }

    private void setValueProgrammatically(String units, int value) {
        int valueToSet;
        if (!this.m_slider.isEnabled()) {
            throw new StepExecutionException("The slider is not enabled", EventFactory.createActionError((String)"The slider is not enabled"));
        }
        if (units.equalsIgnoreCase(ValueSets.Measure.percent.rcValue())) {
            if (value < 0 || 100 < value) {
                this.throwInvalidInputMessage();
            }
            valueToSet = (int)((double)this.m_slider.getMinimum() + (double)value * ((double)(this.m_slider.getMaximum() - this.m_slider.getMinimum()) * 0.01));
        } else {
            valueToSet = value;
        }
        this.m_slider.setSelection(valueToSet);
    }

    private void throwInvalidInputMessage() {
        throw new StepExecutionException("Invalid input for slider", EventFactory.createActionError((String)"TestErrorEvent.InvalidInput"));
    }
}

