/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.eclipse.jubula.client.ui.rcp.search.query.Operation;

public class TextFinder {
    private static PatternCompiler patternCompiler = new Perl5Compiler();
    private static PatternMatcher patternMatcher = new Perl5Matcher();
    private String m_searchString;
    private Operation m_operation;
    private Pattern m_pattern;

    public TextFinder(String searchString, Operation operation) {
        this.m_searchString = searchString;
        this.m_operation = operation;
        try {
            this.prepareSearch();
        }
        catch (MalformedPatternException malformedPatternException) {
            try {
                this.m_pattern = patternCompiler.compile("");
            }
            catch (MalformedPatternException malformedPatternException2) {}
        }
    }

    private void prepareSearch() throws MalformedPatternException {
        switch (this.m_operation) {
            case IGNORE_CASE: {
                this.m_searchString = this.m_searchString.toLowerCase();
                break;
            }
            case REGEX_MATCH_CASE: {
                this.m_pattern = patternCompiler.compile(this.m_searchString);
                break;
            }
            case REGEX_IGNORE_CASE: {
                this.m_pattern = patternCompiler.compile(this.m_searchString, 1);
            }
        }
    }

    public boolean matchSearchString(String text) {
        switch (this.m_operation) {
            case MATCH_CASE: {
                return text.indexOf(this.m_searchString) >= 0;
            }
            case IGNORE_CASE: {
                return text.toLowerCase().indexOf(this.m_searchString) >= 0;
            }
            case REGEX_MATCH_CASE: 
            case REGEX_IGNORE_CASE: {
                return patternMatcher.matches(text, this.m_pattern);
            }
        }
        return false;
    }
}

