/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.internal;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.eclipse.jubula.autagent.Embedded;
import org.eclipse.jubula.autagent.common.AutStarter;
import org.eclipse.jubula.autagent.common.desktop.DesktopIntegration;
import org.eclipse.jubula.autagent.common.gui.ObjectMappingFrame;
import org.eclipse.jubula.client.AUT;
import org.eclipse.jubula.client.AUTAgent;
import org.eclipse.jubula.client.internal.impl.AUTImpl;
import org.eclipse.jubula.toolkit.ToolkitInfo;
import org.eclipse.jubula.toolkit.javafx.JavafxComponents;
import org.eclipse.jubula.toolkit.rcp.RcpComponents;
import org.eclipse.jubula.toolkit.swing.SwingComponents;
import org.eclipse.jubula.toolkit.swt.SwtComponents;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;

public class EmbeddedDesktopIntegration
extends DesktopIntegration {
    private static AUT aut;

    public EmbeddedDesktopIntegration() {
        super(AutStarter.getInstance().getAgent());
    }

    public ActionListener createStartListener(final AutIdentifier id) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isDisconnected;
                AUTAgent agent = Embedded.INSTANCE.agent();
                boolean bl = isDisconnected = !agent.isConnected();
                if (isDisconnected) {
                    agent.connect();
                }
                String toolkitid = AutStarter.getInstance().getAgent().getToolkitForAutID(id);
                ToolkitInfo info = null;
                if (toolkitid.equals("org.eclipse.jubula.JavaFXToolkitPlugin")) {
                    info = JavafxComponents.getToolkitInformation();
                }
                if (toolkitid.equals("com.bredexsw.guidancer.SwingToolkitPlugin")) {
                    info = SwingComponents.getToolkitInformation();
                }
                if (toolkitid.equals("com.bredexsw.guidancer.SwtToolkitPlugin")) {
                    info = SwtComponents.getToolkitInformation();
                }
                if (toolkitid.equals("com.bredexsw.guidancer.RcpToolkitPlugin")) {
                    info = RcpComponents.getToolkitInformation();
                }
                if (info != null) {
                    aut = agent.getAUT((AUTIdentifier)id, info);
                }
                if (aut != null) {
                    aut.connect();
                    ((AUTImpl)aut).startOMM();
                    EmbeddedDesktopIntegration.setObjectMappingAUT((AutIdentifier)id);
                    ObjectMappingFrame.INSTANCE.showObjectMappingPanel();
                }
                if (isDisconnected) {
                    agent.disconnect();
                }
            }
        };
    }

    public ActionListener createStopListener(AutIdentifier id) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isDisconnected;
                AUTAgent agent = Embedded.INSTANCE.agent();
                boolean bl = isDisconnected = !agent.isConnected();
                if (isDisconnected) {
                    agent.connect();
                }
                ((AUTImpl)aut).stopOMM();
                aut.disconnect();
                aut = null;
                if (isDisconnected) {
                    agent.disconnect();
                }
            }
        };
    }
}

