/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;

public class TernaryChoiceOperator {
    private final DiagnosticFactory _diagnosticFactory;

    public TernaryChoiceOperator(DiagnosticFactory diagnosticFactory) {
        this._diagnosticFactory = diagnosticFactory;
    }

    public ValueType perform(ValueType choiceArg, ValueType whenTrueArg, ValueType whenFalseArg) {
        boolean isChoiceBoolean = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)choiceArg.getSignature()));
        if (isChoiceBoolean) {
            String boxedWhenFalseArg;
            String boxedWhenTrueArg;
            if (choiceArg instanceof LiteralType) {
                try {
                    Boolean result = ((LiteralType)choiceArg).coerceToBoolean();
                    if (result != null) {
                        return result != false ? whenTrueArg : whenFalseArg;
                    }
                }
                catch (TypeCoercionException typeCoercionException) {
                    return null;
                }
            }
            if ((boxedWhenTrueArg = TypeTransformer.transformBoxPrimitives((String)whenTrueArg.getSignature())).equals(boxedWhenFalseArg = TypeTransformer.transformBoxPrimitives((String)whenFalseArg.getSignature()))) {
                return new ValueType(whenTrueArg, 2);
            }
            return null;
        }
        return null;
    }

    public Diagnostic validate(ValueType choiceArg) {
        if ("Ljava.lang.Object;".equals(choiceArg.getSignature())) {
            return Diagnostic.OK_INSTANCE;
        }
        boolean isChoiceBoolean = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)choiceArg.getSignature()));
        if (isChoiceBoolean) {
            if (choiceArg instanceof LiteralType) {
                try {
                    Boolean result = ((LiteralType)choiceArg).coerceToBoolean();
                    if (result != null) {
                        String whichSelected = result != false ? "first" : "second";
                        return this._diagnosticFactory.create_TERNARY_OP_CHOICE_IS_ALWAYS_SAME(result, whichSelected);
                    }
                }
                catch (TypeCoercionException typeCoercionException) {
                    return this._diagnosticFactory.create_TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN();
                }
            }
            return Diagnostic.OK_INSTANCE;
        }
        return this._diagnosticFactory.create_TERNARY_OP_CANNOT_COERCE_CHOICE_TO_BOOLEAN();
    }
}

