/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.resource;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.internal.resource.AbstractLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IClasspathLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.JavaCoreMediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathEntryLifecycleListener
extends AbstractLifecycleListener<IClasspathLifecycleListener.ClasspathLifecycleEvent, IClasspathLifecycleListener, IProject>
implements IElementChangedListener {
    private final JavaCoreMediator _mediator;

    public ClasspathEntryLifecycleListener(JavaCoreMediator mediator) {
        if (mediator == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this._mediator = mediator;
    }

    public ClasspathEntryLifecycleListener(IProject entry, JavaCoreMediator mediator) {
        this(mediator);
        if (entry == null) {
            throw new NullPointerException("Cannot add null object");
        }
        this.addLifecycleObject(entry);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (event.getType() == 1) {
            this.handlePostChangeEvent(event);
        }
    }

    private void handlePostChangeEvent(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        new DeltaAcceptor().accept(new DeltaAcceptor.DeltaVisitor(){

            public void visit(IJavaElementDelta visitDelta) {
                IJavaElement element = visitDelta.getElement();
                IJavaProject javaProject = element.getJavaProject();
                if (javaProject == null || !ClasspathEntryLifecycleListener.this.getLifecycleObjects().contains(javaProject.getProject())) {
                    return;
                }
                if (element.getElementType() == 3) {
                    this.handlePackageFragmentRoot(visitDelta);
                } else if (element.getElementType() == 2 && visitDelta.getResourceDeltas() != null) {
                    this.handleProject(visitDelta);
                }
            }

            private void handleProject(final IJavaElementDelta visitDelta) {
                IResourceDelta[] iResourceDeltaArray = visitDelta.getResourceDeltas();
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta resDelta = iResourceDeltaArray[n2];
                    try {
                        resDelta.accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta resDelta2) throws CoreException {
                                if (resDelta2.getKind() == 2 && resDelta2.getResource().getType() == 1 && "jar".equals(resDelta2.getResource().getFileExtension())) {
                                    ClasspathEntryLifecycleListener.this.fireLifecycleEvent(new IClasspathLifecycleListener.ClasspathLifecycleEvent(ClasspathEntryLifecycleListener.this, visitDelta.getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.REMOVED_DELTA, resDelta2.getResource()));
                                }
                                return true;
                            }
                        });
                    }
                    catch (CoreException e) {
                        JSFCommonPlugin.log(e);
                    }
                    ++n2;
                }
            }

            private void handlePackageFragmentRoot(IJavaElementDelta visitDelta) {
                int flags = visitDelta.getFlags();
                switch (visitDelta.getKind()) {
                    case 1: {
                        ClasspathEntryLifecycleListener.this.fireLifecycleEvent(new IClasspathLifecycleListener.ClasspathLifecycleEvent(ClasspathEntryLifecycleListener.this, visitDelta.getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.ADDED));
                        break;
                    }
                    case 2: {
                        ClasspathEntryLifecycleListener.this.fireLifecycleEvent(new IClasspathLifecycleListener.ClasspathLifecycleEvent(ClasspathEntryLifecycleListener.this, visitDelta.getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.REMOVED));
                        break;
                    }
                    case 4: {
                        if ((flags & 0x40) != 0) {
                            ClasspathEntryLifecycleListener.this.fireLifecycleEvent(new IClasspathLifecycleListener.ClasspathLifecycleEvent(ClasspathEntryLifecycleListener.this, visitDelta.getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.ADDED));
                            break;
                        }
                        if ((flags & 0x80) == 0) break;
                        ClasspathEntryLifecycleListener.this.fireLifecycleEvent(new IClasspathLifecycleListener.ClasspathLifecycleEvent(ClasspathEntryLifecycleListener.this, visitDelta.getElement(), IClasspathLifecycleListener.ClasspathLifecycleEvent.Type.REMOVED));
                    }
                }
            }
        }, delta);
    }

    @Override
    protected void addSystemChangeListener() {
        this._mediator.addElementChangedListener(this);
    }

    @Override
    protected void removeSystemChangeListener() {
        this._mediator.removeElementChangeListener(this);
    }

    private static class DeltaAcceptor {
        private DeltaAcceptor() {
        }

        public void accept(DeltaVisitor visitor, IJavaElementDelta delta) {
            visitor.visit(delta);
            IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
            int n = iJavaElementDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElementDelta childDelta = iJavaElementDeltaArray[n2];
                this.accept(visitor, childDelta);
                ++n2;
            }
        }

        public static interface DeltaVisitor {
            public void visit(IJavaElementDelta var1);
        }
    }
}

