/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.facet.libraryprovider;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.project.facet.core.libprov.user.KeyClassesValidator;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.facet.Messages;

public abstract class UserLibraryVersionValidator
extends KeyClassesValidator {
    private static final String MANIFEST_SPECIFICATION_VERSION = "Specification-Version";
    private static final String MANIFEST_IMPLEMENTATION_VERSION = "Implementation-Version";
    private final String classNameIdentifyingImplementationJar;

    public UserLibraryVersionValidator(String classNameIdentifyingImplementationJar) {
        this.classNameIdentifyingImplementationJar = classNameIdentifyingImplementationJar;
    }

    public IStatus validate(UserLibraryProviderInstallOperationConfig config) {
        IStatus status = super.validate(config);
        if (status.getSeverity() != 0) {
            return status;
        }
        String facetVersion = this.getFacetVersion(config);
        String libraryVersion = this.getLibraryVersion(config);
        return this.validateVersionStrings(facetVersion, libraryVersion);
    }

    protected IStatus validateVersionStrings(String facetVersion, String libraryVersion) {
        if (facetVersion == null) {
            throw new IllegalArgumentException("Cannot read facet version");
        }
        if (libraryVersion == null) {
            return new Status(2, "org.eclipse.jst.jsf.common", Messages.UserLibraryVersionValidator_cannotReadLibraryVersion);
        }
        if (libraryVersion.compareToIgnoreCase(facetVersion) >= 0) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.eclipse.jst.jsf.common", Messages.UserLibraryVersionValidator_possiblyIncompatibleLibrary);
    }

    private String getFacetVersion(UserLibraryProviderInstallOperationConfig config) {
        return config.getProjectFacetVersion().getVersionString();
    }

    private String getLibraryVersion(UserLibraryProviderInstallOperationConfig config) {
        String libraryVersion = null;
        try {
            for (IClasspathEntry cpe : config.resolve()) {
                File libraryFile;
                if (!this.isLibrary(cpe) || !(libraryFile = cpe.getPath().toFile()).exists() || !this.isCorrectLibraryJar(cpe, this.classNameIdentifyingImplementationJar)) continue;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(libraryFile);
                    libraryVersion = this.getLibraryVersion(jarFile);
                }
                finally {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
            }
        }
        catch (IOException e) {
            JSFCommonPlugin.log(e, e.getLocalizedMessage());
        }
        return libraryVersion;
    }

    private boolean isLibrary(IClasspathEntry cpe) {
        return cpe.getEntryKind() == 1;
    }

    private boolean isCorrectLibraryJar(IClasspathEntry cpe, String classNameIdentifyingJar) throws IOException {
        File libraryFile = cpe.getPath().toFile();
        if (!libraryFile.exists()) {
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(libraryFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.equals(classNameIdentifyingJar)) continue;
                return true;
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        return false;
    }

    protected String getLibraryVersion(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return null;
        }
        Attributes attributes = manifest.getMainAttributes();
        String specificationVersion = attributes.getValue(MANIFEST_SPECIFICATION_VERSION);
        if (specificationVersion != null) {
            return specificationVersion;
        }
        String implementationVersion = manifest.getMainAttributes().getValue(MANIFEST_IMPLEMENTATION_VERSION);
        return implementationVersion;
    }
}

