/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class EnvEntryType
extends AbstractEnumerator {
    public static final int JAVA_LANG_BOOLEAN = 0;
    public static final int JAVA_LANG_BYTE = 1;
    public static final int JAVA_LANG_CHARACTER = 2;
    public static final int JAVA_LANG_STRING = 3;
    public static final int JAVA_LANG_SHORT = 4;
    public static final int JAVA_LANG_INTEGER = 5;
    public static final int JAVA_LANG_LONG = 6;
    public static final int JAVA_LANG_FLOAT = 7;
    public static final int JAVA_LANG_DOUBLE = 8;
    public static final EnvEntryType JAVA_LANG_BOOLEAN_LITERAL = new EnvEntryType(0, "javaLangBoolean", "java.lang.Boolean");
    public static final EnvEntryType JAVA_LANG_BYTE_LITERAL = new EnvEntryType(1, "javaLangByte", "java.lang.Byte");
    public static final EnvEntryType JAVA_LANG_CHARACTER_LITERAL = new EnvEntryType(2, "javaLangCharacter", "java.lang.Character");
    public static final EnvEntryType JAVA_LANG_STRING_LITERAL = new EnvEntryType(3, "javaLangString", "java.lang.String");
    public static final EnvEntryType JAVA_LANG_SHORT_LITERAL = new EnvEntryType(4, "javaLangShort", "java.lang.Short");
    public static final EnvEntryType JAVA_LANG_INTEGER_LITERAL = new EnvEntryType(5, "javaLangInteger", "java.lang.Integer");
    public static final EnvEntryType JAVA_LANG_LONG_LITERAL = new EnvEntryType(6, "javaLangLong", "java.lang.Long");
    public static final EnvEntryType JAVA_LANG_FLOAT_LITERAL = new EnvEntryType(7, "javaLangFloat", "java.lang.Float");
    public static final EnvEntryType JAVA_LANG_DOUBLE_LITERAL = new EnvEntryType(8, "javaLangDouble", "java.lang.Double");
    private static final EnvEntryType[] VALUES_ARRAY = new EnvEntryType[]{JAVA_LANG_BOOLEAN_LITERAL, JAVA_LANG_BYTE_LITERAL, JAVA_LANG_CHARACTER_LITERAL, JAVA_LANG_STRING_LITERAL, JAVA_LANG_SHORT_LITERAL, JAVA_LANG_INTEGER_LITERAL, JAVA_LANG_LONG_LITERAL, JAVA_LANG_FLOAT_LITERAL, JAVA_LANG_DOUBLE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static EnvEntryType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnvEntryType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnvEntryType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EnvEntryType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EnvEntryType get(int value) {
        switch (value) {
            case 0: {
                return JAVA_LANG_BOOLEAN_LITERAL;
            }
            case 1: {
                return JAVA_LANG_BYTE_LITERAL;
            }
            case 2: {
                return JAVA_LANG_CHARACTER_LITERAL;
            }
            case 3: {
                return JAVA_LANG_STRING_LITERAL;
            }
            case 4: {
                return JAVA_LANG_SHORT_LITERAL;
            }
            case 5: {
                return JAVA_LANG_INTEGER_LITERAL;
            }
            case 6: {
                return JAVA_LANG_LONG_LITERAL;
            }
            case 7: {
                return JAVA_LANG_FLOAT_LITERAL;
            }
            case 8: {
                return JAVA_LANG_DOUBLE_LITERAL;
            }
        }
        return null;
    }

    private EnvEntryType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

