/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.osgi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.osgi.BundleReference;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OsgiBundlesContainer {
    public static final String CONTAINER_ID = "eclipse.fproj.jdt.libprov.osgi";
    public static final IPath CONTAINER_PATH = new Path("eclipse.fproj.jdt.libprov.osgi");
    private static final String PREFS_OSGI_BUNDLES_CONTAINER = "osgi-bundles-container";
    private static final String PREFS_BUNDLES = "bundles";
    private static final String PREFS_LABEL = "label";

    public static boolean isOnClasspath(IProject project, IProjectFacet facet) throws CoreException {
        if (JavaFacet.isJavaProject(project)) {
            return OsgiBundlesContainer.isOnClasspath(JavaCore.create((IProject)project), facet);
        }
        return false;
    }

    public static boolean isOnClasspath(IJavaProject project, IProjectFacet facet) throws CoreException {
        IClasspathEntry[] cp;
        IClasspathEntry[] iClasspathEntryArray = cp = project.getRawClasspath();
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (OsgiBundlesContainer.isOsgiBundlesContainer(cpe)) {
                String fid = cpe.getPath().segment(1);
                return facet.getId().equals(fid);
            }
            ++n2;
        }
        return false;
    }

    public static void addToClasspath(IProject project, IProjectFacet facet) throws CoreException {
        OsgiBundlesContainer.addToClasspath(project, facet, null);
    }

    public static void addToClasspath(IProject project, IProjectFacet facet, IClasspathAttribute[] attributes) throws CoreException {
        if (JavaFacet.isJavaProject(project)) {
            OsgiBundlesContainer.addToClasspath(JavaCore.create((IProject)project), facet, attributes);
        }
    }

    public static void addToClasspath(IJavaProject project, IProjectFacet facet) throws CoreException {
        OsgiBundlesContainer.addToClasspath(project, facet, null);
    }

    public static void addToClasspath(IJavaProject project, IProjectFacet facet, IClasspathAttribute[] attributes) throws CoreException {
        if (!OsgiBundlesContainer.isOnClasspath(project, facet)) {
            IClasspathEntry[] oldcp = project.getRawClasspath();
            IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length + 1];
            System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
            IPath path = CONTAINER_PATH.append(facet.getId());
            IClasspathAttribute[] attrs = attributes != null ? attributes : new IClasspathAttribute[]{};
            newcp[newcp.length - 1] = JavaCore.newContainerEntry((IPath)path, null, (IClasspathAttribute[])attrs, (boolean)false);
            project.setRawClasspath(newcp, null);
        }
    }

    public static void removeFromClasspath(IProject project, IProjectFacet facet) throws CoreException {
        if (JavaFacet.isJavaProject(project)) {
            OsgiBundlesContainer.removeFromClasspath(JavaCore.create((IProject)project), facet);
        }
    }

    public static void removeFromClasspath(IJavaProject project, IProjectFacet facet) throws CoreException {
        IClasspathEntry[] oldcp = project.getRawClasspath();
        int i = 0;
        while (i < oldcp.length) {
            IClasspathEntry cpe = oldcp[i];
            if (OsgiBundlesContainer.isOsgiBundlesContainer(cpe)) {
                String fid = cpe.getPath().segment(1);
                if (facet.getId().equals(fid)) {
                    IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length - 1];
                    System.arraycopy(oldcp, 0, newcp, 0, i);
                    System.arraycopy(oldcp, i + 1, newcp, i, oldcp.length - i - 1);
                    project.setRawClasspath(newcp, null);
                    return;
                }
            }
            ++i;
        }
    }

    public static boolean isOsgiBundlesContainer(IClasspathEntry cpe) {
        IPath path = cpe.getPath();
        return path.segmentCount() >= 2 && path.segment(0).equals(CONTAINER_ID);
    }

    public static List<BundleReference> getBundleReferences(IProject project, IProjectFacet facet) {
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        if (fproj == null) {
            return Collections.emptyList();
        }
        return OsgiBundlesContainer.getBundleReferences(fproj, facet);
    }

    public static List<BundleReference> getBundleReferences(IFacetedProject project, IProjectFacet facet) {
        ArrayList<BundleReference> bundleReferences = new ArrayList<BundleReference>();
        try {
            String unparsedMetadata;
            Preferences prefs = project.getPreferences(facet);
            if (prefs.nodeExists(PREFS_OSGI_BUNDLES_CONTAINER) && (unparsedMetadata = (prefs = prefs.node(PREFS_OSGI_BUNDLES_CONTAINER)).get(PREFS_BUNDLES, null)) != null) {
                String[] stringArray = unparsedMetadata.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String unparsedBundleReference = stringArray[n2];
                    bundleReferences.add(OsgiBundlesContainer.parseBundleReference(unparsedBundleReference));
                    ++n2;
                }
            }
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        return bundleReferences;
    }

    public static void setBundleReferences(IProject project, IProjectFacet facet, List<BundleReference> bundleReferences) {
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        if (fproj != null) {
            OsgiBundlesContainer.setBundleReferences(fproj, facet, bundleReferences);
        }
    }

    public static void setBundleReferences(IFacetedProject project, IProjectFacet facet, List<BundleReference> bundleReferences) {
        try {
            Preferences prefs = project.getPreferences(facet);
            if (bundleReferences == null || bundleReferences.isEmpty()) {
                prefs.removeNode();
            } else {
                StringBuilder buf = new StringBuilder();
                for (BundleReference bundleReference : bundleReferences) {
                    if (buf.length() > 0) {
                        buf.append(';');
                    }
                    buf.append(OsgiBundlesContainer.convert(bundleReference));
                }
                prefs = prefs.node(PREFS_OSGI_BUNDLES_CONTAINER);
                prefs.put(PREFS_BUNDLES, buf.toString());
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
    }

    public static BundleReference parseBundleReference(String bundleReferenceString) {
        VersionRange versionRange;
        String bundleId;
        int colon = bundleReferenceString.indexOf(58);
        if (colon == -1) {
            bundleId = bundleReferenceString;
            versionRange = null;
        } else {
            bundleId = bundleReferenceString.substring(0, colon);
            try {
                versionRange = new VersionRange(bundleReferenceString.substring(colon + 1));
            }
            catch (IllegalArgumentException e) {
                FacetedProjectFrameworkJavaPlugin.log(e);
                versionRange = null;
            }
        }
        return new BundleReference(bundleId, versionRange);
    }

    public static String getContainerLabel(IProject project, IProjectFacet facet) {
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        if (fproj == null) {
            return null;
        }
        return OsgiBundlesContainer.getContainerLabel(fproj, facet);
    }

    public static String getContainerLabel(IFacetedProject project, IProjectFacet facet) {
        String label = null;
        try {
            Preferences prefs = project.getPreferences(facet);
            if (prefs.nodeExists(PREFS_OSGI_BUNDLES_CONTAINER)) {
                prefs = prefs.node(PREFS_OSGI_BUNDLES_CONTAINER);
                label = prefs.get(PREFS_LABEL, null);
            }
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        return label;
    }

    public static void setContainerLabel(IProject project, IProjectFacet facet, String label) {
        IFacetedProject fproj = null;
        try {
            fproj = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
        if (fproj != null) {
            OsgiBundlesContainer.setContainerLabel(fproj, facet, label);
        }
    }

    public static void setContainerLabel(IFacetedProject project, IProjectFacet facet, String label) {
        try {
            Preferences prefs = project.getPreferences(facet);
            prefs = prefs.node(PREFS_OSGI_BUNDLES_CONTAINER);
            if (label == null) {
                prefs.remove(PREFS_LABEL);
            } else {
                prefs.put(PREFS_LABEL, label);
            }
            prefs.flush();
        }
        catch (BackingStoreException e) {
            FacetedProjectFrameworkJavaPlugin.log((Exception)((Object)e));
        }
    }

    private static String convert(BundleReference bundleReference) {
        StringBuilder buf = new StringBuilder();
        buf.append(bundleReference.getBundleId());
        if (bundleReference.getVersionRange() != null) {
            buf.append(':');
            buf.append(bundleReference.getVersionRange().toString());
        }
        return buf.toString();
    }

    private OsgiBundlesContainer() {
    }
}

