/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.LockFile;
import org.eclipse.jgit.internal.storage.file.PackLock;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.BatchingProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.FetchHeadRecord;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.transport.Transport;

class FetchProcess {
    private final Transport transport;
    private final Collection<RefSpec> toFetch;
    private final HashMap<ObjectId, Ref> askFor = new HashMap();
    private final HashSet<ObjectId> have = new HashSet();
    private final ArrayList<TrackingRefUpdate> localUpdates = new ArrayList();
    private final ArrayList<FetchHeadRecord> fetchHeadUpdates = new ArrayList();
    private final ArrayList<PackLock> packLocks = new ArrayList();
    private FetchConnection conn;
    private Map<String, Ref> localRefs;

    FetchProcess(Transport t, Collection<RefSpec> f) {
        this.transport = t;
        this.toFetch = f;
    }

    void execute(ProgressMonitor monitor, FetchResult result) throws NotSupportedException, TransportException {
        this.askFor.clear();
        this.localUpdates.clear();
        this.fetchHeadUpdates.clear();
        this.packLocks.clear();
        this.localRefs = null;
        try {
            this.executeImp(monitor, result);
        }
        finally {
            try {
                for (PackLock lock : this.packLocks) {
                    lock.unlock();
                }
            }
            catch (IOException e) {
                throw new TransportException(e.getMessage(), e);
            }
        }
    }

    private void executeImp(ProgressMonitor monitor, FetchResult result) throws NotSupportedException, TransportException {
        Object additionalTags;
        this.conn = this.transport.openFetch();
        try {
            boolean includedTags;
            result.setAdvertisedRefs(this.transport.getURI(), this.conn.getRefsMap());
            result.peerUserAgent = this.conn.getPeerUserAgent();
            HashSet<Ref> matched = new HashSet<Ref>();
            for (RefSpec spec : this.toFetch) {
                if (spec.getSource() == null) {
                    throw new TransportException(MessageFormat.format(JGitText.get().sourceRefNotSpecifiedForRefspec, spec));
                }
                if (spec.isWildcard()) {
                    this.expandWildcard(spec, matched);
                    continue;
                }
                this.expandSingle(spec, matched);
            }
            additionalTags = Collections.emptyList();
            TagOpt tagopt = this.transport.getTagOpt();
            if (tagopt == TagOpt.AUTO_FOLLOW) {
                additionalTags = this.expandAutoFollowTags();
            } else if (tagopt == TagOpt.FETCH_TAGS) {
                this.expandFetchTags();
            }
            if (!this.askFor.isEmpty() && !this.askForIsComplete()) {
                this.fetchObjects(monitor);
                includedTags = this.conn.didFetchIncludeTags();
                this.closeConnection(result);
            } else {
                includedTags = false;
            }
            if (tagopt == TagOpt.AUTO_FOLLOW && !additionalTags.isEmpty()) {
                this.have.addAll(this.askFor.keySet());
                this.askFor.clear();
                Iterator<Object> iterator = additionalTags.iterator();
                while (iterator.hasNext()) {
                    Ref r = (Ref)iterator.next();
                    ObjectId id = r.getPeeledObjectId();
                    if (id == null) {
                        id = r.getObjectId();
                    }
                    if (!this.localHasObject(id)) continue;
                    this.wantTag(r);
                }
                if (!(this.askFor.isEmpty() || includedTags && this.askForIsComplete())) {
                    this.reopenConnection();
                    if (!this.askFor.isEmpty()) {
                        this.fetchObjects(monitor);
                    }
                }
            }
        }
        finally {
            this.closeConnection(result);
        }
        BatchRefUpdate batch = this.transport.local.getRefDatabase().newBatchUpdate().setAllowNonFastForwards(true).setRefLogMessage("fetch", true);
        try {
            additionalTags = null;
            Iterator<RefSpec> iterator = null;
            try (RevWalk walk = new RevWalk(this.transport.local);){
                walk.setRetainBody(false);
                if (monitor instanceof BatchingProgressMonitor) {
                    ((BatchingProgressMonitor)monitor).setDelayStart(250L, TimeUnit.MILLISECONDS);
                }
                if (this.transport.isRemoveDeletedRefs()) {
                    this.deleteStaleTrackingRefs(result, batch);
                }
                this.addUpdateBatchCommands(result, batch);
                for (ReceiveCommand cmd : batch.getCommands()) {
                    cmd.updateType(walk);
                    if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD || !(cmd instanceof TrackingRefUpdate.Command) || ((TrackingRefUpdate.Command)cmd).canForceUpdate()) continue;
                    cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                }
                if (this.transport.isDryRun()) {
                    for (ReceiveCommand cmd : batch.getCommands()) {
                        if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                        cmd.setResult(ReceiveCommand.Result.OK);
                    }
                } else {
                    batch.execute(walk, monitor);
                }
            }
            catch (Throwable throwable) {
                if (additionalTags == null) {
                    additionalTags = throwable;
                } else if (additionalTags != throwable) {
                    ((Throwable)additionalTags).addSuppressed(throwable);
                }
                throw additionalTags;
            }
        }
        catch (TransportException e) {
            throw e;
        }
        catch (IOException err) {
            throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingTrackingRef, FetchProcess.getFirstFailedRefName(batch), err.getMessage()), err);
        }
        if (!this.fetchHeadUpdates.isEmpty()) {
            try {
                this.updateFETCH_HEAD(result);
            }
            catch (IOException err) {
                throw new TransportException(MessageFormat.format(JGitText.get().failureUpdatingFETCH_HEAD, err.getMessage()), err);
            }
        }
    }

    private void addUpdateBatchCommands(FetchResult result, BatchRefUpdate batch) throws TransportException {
        HashMap<String, ObjectId> refs = new HashMap<String, ObjectId>();
        for (TrackingRefUpdate u : this.localUpdates) {
            ObjectId existing = (ObjectId)refs.get(u.getLocalName());
            if (existing == null) {
                refs.put(u.getLocalName(), u.getNewObjectId());
                result.add(u);
                batch.addCommand(u.asReceiveCommand());
                continue;
            }
            if (existing.equals(u.getNewObjectId())) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRef, u.getLocalName()));
        }
    }

    private void fetchObjects(ProgressMonitor monitor) throws TransportException {
        try {
            this.conn.setPackLockMessage("jgit fetch " + this.transport.uri);
            this.conn.fetch(monitor, this.askFor.values(), this.have);
        }
        finally {
            this.packLocks.addAll(this.conn.getPackLocks());
        }
        if (this.transport.isCheckFetchedObjects() && !this.conn.didFetchTestConnectivity() && !this.askForIsComplete()) {
            throw new TransportException(this.transport.getURI(), JGitText.get().peerDidNotSupplyACompleteObjectGraph);
        }
    }

    private void closeConnection(FetchResult result) {
        if (this.conn != null) {
            this.conn.close();
            result.addMessages(this.conn.getMessages());
            this.conn = null;
        }
    }

    private void reopenConnection() throws NotSupportedException, TransportException {
        if (this.conn != null) {
            return;
        }
        this.conn = this.transport.openFetch();
        HashMap<ObjectId, Ref> avail = new HashMap<ObjectId, Ref>();
        for (Ref r : this.conn.getRefs()) {
            avail.put(r.getObjectId(), r);
        }
        ArrayList<Ref> wants = new ArrayList<Ref>(this.askFor.values());
        this.askFor.clear();
        for (Ref want : wants) {
            Ref newRef = (Ref)avail.get(want.getObjectId());
            if (newRef != null) {
                this.askFor.put(newRef.getObjectId(), newRef);
                continue;
            }
            this.removeFetchHeadRecord(want.getObjectId());
            this.removeTrackingRefUpdate(want.getObjectId());
        }
    }

    private void removeTrackingRefUpdate(ObjectId want) {
        Iterator<TrackingRefUpdate> i = this.localUpdates.iterator();
        while (i.hasNext()) {
            TrackingRefUpdate u = i.next();
            if (!u.getNewObjectId().equals(want)) continue;
            i.remove();
        }
    }

    private void removeFetchHeadRecord(ObjectId want) {
        Iterator<FetchHeadRecord> i = this.fetchHeadUpdates.iterator();
        while (i.hasNext()) {
            FetchHeadRecord fh = i.next();
            if (!fh.newValue.equals(want)) continue;
            i.remove();
        }
    }

    private void updateFETCH_HEAD(FetchResult result) throws IOException {
        block14: {
            File meta = this.transport.local.getDirectory();
            if (meta == null) {
                return;
            }
            LockFile lock = new LockFile(new File(meta, "FETCH_HEAD"));
            try {
                if (!lock.lock()) break block14;
                Throwable throwable = null;
                Object var5_6 = null;
                try (OutputStreamWriter w = new OutputStreamWriter(lock.getOutputStream(), StandardCharsets.UTF_8);){
                    for (FetchHeadRecord h : this.fetchHeadUpdates) {
                        h.write(w);
                        result.add(h);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                lock.commit();
            }
            finally {
                lock.unlock();
            }
        }
    }

    private boolean askForIsComplete() throws TransportException {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (ObjectWalk ow = new ObjectWalk(this.transport.local);){
                for (ObjectId want : this.askFor.keySet()) {
                    ow.markStart(ow.parseAny(want));
                }
                for (Ref ref : this.localRefs().values()) {
                    ow.markUninteresting(ow.parseAny(ref.getObjectId()));
                }
                ow.checkConnectivity();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return true;
        }
        catch (MissingObjectException e) {
            return false;
        }
        catch (IOException e) {
            throw new TransportException(JGitText.get().unableToCheckConnectivity, e);
        }
    }

    private void expandWildcard(RefSpec spec, Set<Ref> matched) throws TransportException {
        for (Ref src : this.conn.getRefs()) {
            if (!spec.matchSource(src) || !matched.add(src)) continue;
            this.want(src, spec.expandFromSource(src));
        }
    }

    private void expandSingle(RefSpec spec, Set<Ref> matched) throws TransportException {
        String want = spec.getSource();
        if (ObjectId.isId(want)) {
            this.want(ObjectId.fromString(want));
            return;
        }
        Ref src = this.conn.getRef(want);
        if (src == null) {
            throw new TransportException(MessageFormat.format(JGitText.get().remoteDoesNotHaveSpec, want));
        }
        if (matched.add(src)) {
            this.want(src, spec);
        }
    }

    private boolean localHasObject(ObjectId id) throws TransportException {
        try {
            return this.transport.local.getObjectDatabase().has(id);
        }
        catch (IOException err) {
            throw new TransportException(MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, err.getMessage()), err);
        }
    }

    private Collection<Ref> expandAutoFollowTags() throws TransportException {
        ArrayList<Ref> additionalTags = new ArrayList<Ref>();
        Map<String, Ref> haveRefs = this.localRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            if (!FetchProcess.isTag(r) || (local = haveRefs.get(r.getName())) != null) continue;
            ObjectId obj = r.getPeeledObjectId();
            if (obj == null) {
                obj = r.getObjectId();
            }
            if (this.askFor.containsKey(obj) || this.localHasObject(obj)) {
                this.wantTag(r);
                continue;
            }
            additionalTags.add(r);
        }
        return additionalTags;
    }

    private void expandFetchTags() throws TransportException {
        Map<String, Ref> haveRefs = this.localRefs();
        for (Ref r : this.conn.getRefs()) {
            Ref local;
            ObjectId id;
            if (!FetchProcess.isTag(r) || (id = r.getObjectId()) == null || (local = haveRefs.get(r.getName())) != null && id.equals(local.getObjectId())) continue;
            this.wantTag(r);
        }
    }

    private void wantTag(Ref r) throws TransportException {
        this.want(r, new RefSpec().setSource(r.getName()).setDestination(r.getName()).setForceUpdate(true));
    }

    private void want(Ref src, RefSpec spec) throws TransportException {
        ObjectId newId = src.getObjectId();
        if (newId == null) {
            throw new NullPointerException(MessageFormat.format(JGitText.get().transportProvidedRefWithNoObjectId, src.getName()));
        }
        if (spec.getDestination() != null) {
            TrackingRefUpdate tru = this.createUpdate(spec, newId);
            if (newId.equals(tru.getOldObjectId())) {
                return;
            }
            this.localUpdates.add(tru);
        }
        this.askFor.put(newId, src);
        FetchHeadRecord fhr = new FetchHeadRecord();
        fhr.newValue = newId;
        fhr.notForMerge = spec.getDestination() != null;
        fhr.sourceName = src.getName();
        fhr.sourceURI = this.transport.getURI();
        this.fetchHeadUpdates.add(fhr);
    }

    private void want(ObjectId id) {
        this.askFor.put(id, new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, id.name(), id));
    }

    private TrackingRefUpdate createUpdate(RefSpec spec, ObjectId newId) throws TransportException {
        Ref ref = this.localRefs().get(spec.getDestination());
        ObjectId oldId = ref != null && ref.getObjectId() != null ? ref.getObjectId() : ObjectId.zeroId();
        return new TrackingRefUpdate(spec.isForceUpdate(), spec.getSource(), spec.getDestination(), oldId, newId);
    }

    private Map<String, Ref> localRefs() throws TransportException {
        if (this.localRefs == null) {
            try {
                this.localRefs = this.transport.local.getRefDatabase().getRefs("");
            }
            catch (IOException err) {
                throw new TransportException(JGitText.get().cannotListRefs, err);
            }
        }
        return this.localRefs;
    }

    private void deleteStaleTrackingRefs(FetchResult result, BatchRefUpdate batch) throws IOException {
        HashSet<Ref> processed = new HashSet<Ref>();
        for (Ref ref : this.localRefs().values()) {
            if (ref.isSymbolic()) continue;
            String refname = ref.getName();
            for (RefSpec spec : this.toFetch) {
                RefSpec s;
                if (!spec.matchDestination(refname) || result.getAdvertisedRef((s = spec.expandFromDestination(refname)).getSource()) != null || !processed.add(ref)) continue;
                this.deleteTrackingRef(result, batch, s, ref);
            }
        }
    }

    private void deleteTrackingRef(FetchResult result, BatchRefUpdate batch, RefSpec spec, Ref localRef) {
        if (localRef.getObjectId() == null) {
            return;
        }
        TrackingRefUpdate update = new TrackingRefUpdate(true, spec.getSource(), localRef.getName(), localRef.getObjectId(), ObjectId.zeroId());
        result.add(update);
        batch.addCommand(update.asReceiveCommand());
    }

    private static boolean isTag(Ref r) {
        return FetchProcess.isTag(r.getName());
    }

    private static boolean isTag(String name) {
        return name.startsWith("refs/tags/");
    }

    private static String getFirstFailedRefName(BatchRefUpdate batch) {
        for (ReceiveCommand cmd : batch.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            return cmd.getRefName();
        }
        return "";
    }
}

