/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import java.util.Stack;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.StackTransformStatementsVisitor;

public class RecordLocalTypesVisitor
extends StackTransformStatementsVisitor
implements IOTConstants {
    private Stack<ClassScope> _classScopeStack = new Stack();

    @Override
    public boolean visit(TypeDeclaration type, ClassScope scope) {
        return !type.isTeam() || !StateHelper.hasState(type.binding, 16);
    }

    @Override
    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this._classScopeStack.push(scope);
        return true;
    }

    @Override
    public void endVisit(MethodDeclaration methodDecl, ClassScope scope) {
        if (!this._classScopeStack.isEmpty()) {
            this._classScopeStack.pop();
        }
    }

    @Override
    public boolean visit(ConstructorDeclaration ctorDeclaration, ClassScope scope) {
        this._classScopeStack.push(scope);
        return true;
    }

    @Override
    public void endVisit(ConstructorDeclaration ctorDecl, ClassScope scope) {
        if (!this._classScopeStack.isEmpty()) {
            this._classScopeStack.pop();
        }
    }

    @Override
    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        if (scope == null) {
            return false;
        }
        ClassScope classScope = scope.classScope();
        if (classScope != null) {
            this._classScopeStack.push(classScope);
        }
        return true;
    }

    @Override
    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        if (!this._classScopeStack.isEmpty()) {
            this._classScopeStack.pop();
        }
    }

    @Override
    public boolean visit(TypeDeclaration td, BlockScope scope) {
        if ((td.bits & 0x100) != 0) {
            ClassScope classScope;
            SourceTypeBinding enclosingType = null;
            TypeDeclaration enclosingTypeDecl = null;
            if (scope != null) {
                enclosingType = scope.enclosingSourceType();
                enclosingTypeDecl = scope.referenceType();
            } else if (!this._classScopeStack.isEmpty() && (classScope = this._classScopeStack.peek()) != null) {
                enclosingTypeDecl = classScope.referenceContext;
                enclosingType = enclosingTypeDecl.binding;
            }
            if (enclosingType != null) {
                TypeModel model;
                if (enclosingType.isRole()) {
                    model = enclosingType.roleModel;
                    td.enclosingType = enclosingTypeDecl;
                    ((RoleModel)model).addLocalType(null, td.getRoleModel(((RoleModel)model).getTeamModel()));
                } else {
                    model = enclosingType.model;
                    model.addLocalType(td);
                }
            }
            if (td.scope == null) {
                return false;
            }
        }
        return true;
    }

    public void recordLocalTypesFor(TypeDeclaration type) {
        try {
            if (this.visit(type, type.scope)) {
                int i;
                int length;
                if (type.memberTypes != null) {
                    length = type.memberTypes.length;
                    i = 0;
                    while (i < length) {
                        type.memberTypes[i].traverse((ASTVisitor)this, type.scope);
                        ++i;
                    }
                }
                if (type.fields != null) {
                    length = type.fields.length;
                    i = 0;
                    while (i < length) {
                        FieldDeclaration field = type.fields[i];
                        if (field.isStatic()) {
                            field.traverse((ASTVisitor)this, type.staticInitializerScope);
                        } else {
                            field.traverse((ASTVisitor)this, type.initializerScope);
                        }
                        ++i;
                    }
                }
                if (type.methods != null) {
                    length = type.methods.length;
                    i = 0;
                    while (i < length) {
                        type.methods[i].traverse((ASTVisitor)this, type.scope);
                        ++i;
                    }
                }
                if (type.callinCallouts != null) {
                    int callinCalloutsLength = type.callinCallouts.length;
                    i = 0;
                    while (i < callinCalloutsLength) {
                        type.callinCallouts[i].traverse((ASTVisitor)this, type.scope);
                        ++i;
                    }
                }
            }
            this.endVisit(type, type.scope);
        }
        catch (AbortType abortType) {}
    }
}

