/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.AbstractAttribute;

public abstract class ListValueAttribute
extends AbstractAttribute {
    int _count;
    private int _elementSize;

    ListValueAttribute(char[] name, int count, int elementSize) {
        super(name);
        this._count = count;
        this._elementSize = elementSize;
    }

    @Override
    public boolean setupForWriting() {
        return this._count > 0;
    }

    @Override
    public void write(ClassFile classFile) {
        super.write(classFile);
        int attributeSize = this.getAttributeSize();
        if (this._contentsOffset + 6 + attributeSize >= this._contents.length) {
            this._contents = classFile.getResizedContents(6 + attributeSize);
        }
        this.writeName(this._name);
        this.writeInt(attributeSize);
        this.writeUnsignedShort(this._count);
        int i = 0;
        while (i < this._count) {
            this.writeElementValue(i);
            ++i;
        }
        this.writeBack(classFile);
    }

    protected int getAttributeSize() {
        return this._count * this._elementSize + 2;
    }

    abstract void writeElementValue(int var1);

    void readList(ClassFileStruct reader, int readOffset, int structOffset, int[] constantPoolOffsets) {
        this._count = reader.u2At(readOffset);
        this._reader = reader;
        this._readOffset = readOffset + 2;
        this._structOffset = structOffset;
        this._constantPoolOffsets = constantPoolOffsets;
        int i = 0;
        while (i < this._count) {
            this.read(i);
            ++i;
        }
    }

    void read(int i) {
        this._readOffset += this._elementSize;
    }

    @Override
    public abstract void evaluate(Binding var1, LookupEnvironment var2, char[][][] var3);

    public String toString() {
        String str = "OT-Attribute " + new String(this._name) + ": [";
        int i = 0;
        while (i < this._count) {
            str = String.valueOf(str) + this.toString(i) + (i < this._count - 1 ? ", " : "");
            ++i;
        }
        return String.valueOf(str) + "]";
    }

    abstract String toString(int var1);
}

