/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.util.Util;

public class SourceMethodMappingInfo
extends AnnotatableInfo {
    private static final int CALLOUT = 4;
    private static final int GET = 5;
    private static final int SET = 6;
    private String[] roleParameterNames;
    private int nBaseMethods;
    private String[][] baseParameterNames;
    private String[][] baseParameterTypes;
    private String[] baseReturnTypes;
    private int _mappingKind = 0;
    private boolean _hasSignature;
    private boolean _isOverride;
    private int _declaredModifiers;
    private char[] callinName = null;

    public void setRoleArgumentNames(String[] parameterNames) {
        this.roleParameterNames = parameterNames;
    }

    public void setBaseArgumentNames(String[][] parameterNames) {
        this.checkBaseCount(parameterNames.length);
        this.baseParameterNames = parameterNames;
    }

    public void setBaseArgumentTypes(String[][] parameterTypes) {
        this.checkBaseCount(parameterTypes.length);
        this.baseParameterTypes = parameterTypes;
    }

    public void setBaseReturnType(String[] returnTypes) {
        this.checkBaseCount(returnTypes.length);
        this.baseReturnTypes = returnTypes;
    }

    private void checkBaseCount(int baseCount) {
        if (this.nBaseMethods == 0) {
            this.nBaseMethods = baseCount;
        } else if (this.nBaseMethods != baseCount) {
            throw new IllegalArgumentException("Mismatching array size: " + this.nBaseMethods + " vs. " + baseCount);
        }
    }

    public void setCallinKind(int kind, boolean hasSignature, char[] name) {
        this._mappingKind = kind;
        this._hasSignature = hasSignature;
        this.callinName = name;
    }

    public void setCalloutKind(boolean override, int declaredModifiers) {
        this._isOverride = override;
        this._declaredModifiers = declaredModifiers;
        this._mappingKind = 4;
    }

    public void setCalloutKind(boolean override, int declaredModifiers, boolean isSetter) {
        this._isOverride = override;
        this._declaredModifiers = declaredModifiers;
        this._mappingKind = isSetter ? 6 : 5;
    }

    public boolean modifiersEqual(SourceMethodMappingInfo other) {
        if (this._hasSignature != other._hasSignature) {
            return false;
        }
        if (this._mappingKind != other._mappingKind) {
            return false;
        }
        if (!this.isCallin()) {
            return this._isOverride == other._isOverride && this._declaredModifiers == other._declaredModifiers;
        }
        return true;
    }

    public boolean signaturesEqual(SourceMethodMappingInfo other) {
        if (!Util.equalArraysOrNull(this.roleParameterNames, other.roleParameterNames)) {
            return false;
        }
        if (this.nBaseMethods != other.nBaseMethods) {
            return false;
        }
        int i = 0;
        while (i < this.nBaseMethods) {
            if (!Util.equalArraysOrNull(this.baseParameterNames[i], other.baseParameterNames[i])) {
                return false;
            }
            if (!Util.equalArraysOrNull(this.baseParameterTypes[i], other.baseParameterTypes[i])) {
                return false;
            }
            if (!this.baseReturnTypes[i].equals(other.baseReturnTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public char[] getCallinName() {
        return this.callinName;
    }

    public boolean isCallin() {
        return this._mappingKind < 4;
    }
}

