/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.indexer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElementDelta;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.nd.IReader;
import org.eclipse.jdt.internal.core.nd.Nd;
import org.eclipse.jdt.internal.core.nd.db.Database;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.indexer.ClassFileToIndexConverter;
import org.eclipse.jdt.internal.core.nd.indexer.FileStateCache;
import org.eclipse.jdt.internal.core.nd.indexer.IndexTester;
import org.eclipse.jdt.internal.core.nd.indexer.IndexerEvent;
import org.eclipse.jdt.internal.core.nd.indexer.Messages;
import org.eclipse.jdt.internal.core.nd.indexer.Package;
import org.eclipse.jdt.internal.core.nd.indexer.WorkspaceSnapshot;
import org.eclipse.jdt.internal.core.nd.java.FileFingerprint;
import org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.eclipse.jdt.internal.core.nd.java.NdResourceFile;
import org.eclipse.jdt.internal.core.nd.java.NdType;
import org.eclipse.jdt.internal.core.nd.java.NdTypeId;
import org.eclipse.jdt.internal.core.nd.java.NdWorkspaceLocation;
import org.eclipse.jdt.internal.core.nd.java.TypeRef;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeDescriptor;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;
import org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryType;

public final class Indexer {
    private Nd nd;
    private IWorkspaceRoot root;
    private static Indexer indexer;
    public static boolean DEBUG;
    public static boolean DEBUG_ALLOCATIONS;
    public static boolean DEBUG_TIMING;
    public static boolean DEBUG_SCHEDULING;
    public static boolean DEBUG_INSERTIONS;
    public static boolean DEBUG_SELFTEST;
    public static int DEBUG_LOG_SIZE_MB;
    private static final int TOTAL_TICKS_TO_REPORT_DURING_INDEXING = 1000;
    private boolean enableAutomaticIndexing = true;
    private boolean indexerDirtiedWhileDisabled = false;
    private final Object automaticIndexingMutex = new Object();
    private final FileStateCache fileStateCache;
    private static final Object mutex;
    private Object listenersMutex = new Object();
    private Set<Listener> listeners = Collections.newSetFromMap(new WeakHashMap());
    private JobGroup group = new JobGroup(Messages.Indexer_updating_index_job_name, 1, 1);
    private Job rescanJob = Job.create((String)Messages.Indexer_updating_index_job_name, monitor -> {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.rescan((IProgressMonitor)subMonitor);
        }
        catch (IndexException e) {
            Package.log("Database corruption detected during indexing. Deleting and rebuilding the index.", e);
            this.rebuildIndex((IProgressMonitor)subMonitor);
        }
    });
    private Job rebuildIndexJob = Job.create((String)Messages.Indexer_updating_index_job_name, monitor -> this.rebuildIndex(monitor));

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Indexer getInstance() {
        Object object = mutex;
        synchronized (object) {
            if (indexer == null) {
                indexer = new Indexer(JavaIndex.getGlobalNd(), ResourcesPlugin.getWorkspace().getRoot());
            }
            return indexer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableAutomaticIndexing(boolean enabled) {
        boolean runRescan = false;
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            if (this.enableAutomaticIndexing == enabled) {
                return;
            }
            this.enableAutomaticIndexing = enabled;
            if (enabled && this.indexerDirtiedWhileDisabled) {
                runRescan = true;
            }
        }
        if (JavaIndex.isEnabled()) {
            if (runRescan) {
                this.rescanJob.schedule();
            }
            if (!enabled) {
                try {
                    this.rescanJob.join(0L, null);
                }
                catch (InterruptedException | OperationCanceledException throwable) {}
            }
        }
    }

    private static long getGarbageCleanupTimeout() {
        return Platform.getPreferencesService().getLong("org.eclipse.jdt.core", "garbageCleanupTimeoutMs", 259200000L, null);
    }

    private static long getUsageTimestampUpdatePeriod() {
        return Indexer.getGarbageCleanupTimeout() / 4L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescan(IProgressMonitor monitor) throws CoreException {
        double averageResourceMappingMs;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Database db = this.nd.getDB();
        db.resetCacheCounters();
        db.getLog().setBufferSize(DEBUG_LOG_SIZE_MB);
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            this.indexerDirtiedWhileDisabled = false;
        }
        long currentTimeMs = System.currentTimeMillis();
        if (DEBUG) {
            Package.logInfo("Indexer running rescan");
        }
        this.fileStateCache.clear();
        WorkspaceSnapshot snapshot = WorkspaceSnapshot.create(this.root, (IProgressMonitor)subMonitor.split(1));
        Set<IPath> locations = snapshot.allLocations();
        long startGarbageCollectionMs = System.currentTimeMillis();
        int gcFiles = this.cleanGarbage(currentTimeMs, locations, (IProgressMonitor)subMonitor.split(1));
        long startFingerprintTestMs = System.currentTimeMillis();
        Map<IPath, FileFingerprint.FingerprintTestResult> fingerprints = this.testFingerprints(locations, (IProgressMonitor)subMonitor.split(1));
        HashSet<IPath> indexablesWithChanges = new HashSet<IPath>(this.getIndexablesThatHaveChanged(locations, fingerprints));
        long startIndexingMs = System.currentTimeMillis();
        long totalSizeToIndex = 0L;
        for (IPath next : indexablesWithChanges) {
            FileFingerprint.FingerprintTestResult nextFingerprint = fingerprints.get(next);
            totalSizeToIndex += nextFingerprint.getNewFingerprint().getSize();
        }
        double tickCoefficient = totalSizeToIndex == 0L ? 0.0 : 1000.0 / (double)totalSizeToIndex;
        int classesIndexed = 0;
        SubMonitor loopMonitor = subMonitor.split(94).setWorkRemaining(1000);
        for (IPath next : indexablesWithChanges) {
            FileFingerprint.FingerprintTestResult nextFingerprint = fingerprints.get(next);
            int ticks = (int)((double)nextFingerprint.getNewFingerprint().getSize() * tickCoefficient);
            classesIndexed += this.rescanArchive(currentTimeMs, next, snapshot.get(next), fingerprints.get(next).getNewFingerprint(), (IProgressMonitor)loopMonitor.split(ticks));
        }
        long endIndexingMs = System.currentTimeMillis();
        HashMap<IPath, List<IJavaElement>> pathsToUpdate = new HashMap<IPath, List<IJavaElement>>();
        for (IPath next : locations) {
            if (indexablesWithChanges.contains(next)) continue;
            pathsToUpdate.put(next, snapshot.get(next));
        }
        this.updateResourceMappings(pathsToUpdate, (IProgressMonitor)subMonitor.split(1));
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(1));
        try {
            this.nd.getDB().flush();
        }
        finally {
            this.nd.releaseWriteLock();
        }
        this.fireDelta(indexablesWithChanges, (IProgressMonitor)subMonitor.split(1));
        if (DEBUG) {
            Package.logInfo("Rescan finished");
        }
        long endResourceMappingMs = System.currentTimeMillis();
        long locateIndexablesTimeMs = startGarbageCollectionMs - currentTimeMs;
        long garbageCollectionMs = startFingerprintTestMs - startGarbageCollectionMs;
        long fingerprintTimeMs = startIndexingMs - startFingerprintTestMs;
        long indexingTimeMs = endIndexingMs - startIndexingMs;
        long resourceMappingTimeMs = endResourceMappingMs - endIndexingMs;
        double averageGcTimeMs = gcFiles == 0 ? 0.0 : (double)garbageCollectionMs / (double)gcFiles;
        double averageIndexTimeMs = classesIndexed == 0 ? 0.0 : (double)indexingTimeMs / (double)classesIndexed;
        double averageFingerprintTimeMs = locations.size() == 0 ? 0.0 : (double)fingerprintTimeMs / (double)locations.size();
        double d = averageResourceMappingMs = pathsToUpdate.size() == 0 ? 0.0 : (double)resourceMappingTimeMs / (double)pathsToUpdate.size();
        if (DEBUG_TIMING) {
            DecimalFormat msFormat = new DecimalFormat("#0.###");
            DecimalFormat percentFormat = new DecimalFormat("#0.###");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS\n");
            System.out.println("Indexing done at " + format.format(new Date(endResourceMappingMs)) + "  Located " + locations.size() + " indexables in " + locateIndexablesTimeMs + "ms");
            if (gcFiles != 0) {
                System.out.println("  Collected garbage from " + gcFiles + " files in " + garbageCollectionMs + "ms, average time = " + msFormat.format(averageGcTimeMs) + "ms");
            }
            System.out.println("  Tested " + locations.size() + " fingerprints in " + fingerprintTimeMs + "ms, average time = " + msFormat.format(averageFingerprintTimeMs) + "ms");
            if (classesIndexed != 0) {
                System.out.println("  Indexed " + classesIndexed + " classes (from " + indexablesWithChanges.size() + " files containing " + Database.formatByteString(totalSizeToIndex) + ") in " + indexingTimeMs + "ms, average time per class = " + msFormat.format(averageIndexTimeMs) + "ms");
            }
            if (pathsToUpdate.size() != 0) {
                System.out.println("  Updated " + pathsToUpdate.size() + " paths in " + resourceMappingTimeMs + "ms, average time = " + msFormat.format(averageResourceMappingMs) + "ms");
            }
            System.out.println("  " + db.getChunkStats());
            long cacheHits = db.getCacheHits();
            long cacheMisses = db.getCacheMisses();
            long totalReads = cacheMisses + cacheHits;
            double cacheMissPercent = totalReads == 0L ? 0.0 : (double)cacheMisses * 100.0 / (double)totalReads;
            System.out.println("  Cache misses = " + cacheMisses + " (" + percentFormat.format(cacheMissPercent) + "%)");
            long bytesRead = db.getBytesRead();
            long bytesWritten = db.getBytesWritten();
            double totalTimeMs = endResourceMappingMs - currentTimeMs;
            long flushTimeMs = db.getCumulativeFlushTimeMs();
            double flushPercent = totalTimeMs == 0.0 ? 0.0 : (double)flushTimeMs * 100.0 / totalTimeMs;
            System.out.println("  Reads = " + Database.formatByteString(bytesRead) + ", writes = " + Database.formatByteString(bytesWritten));
            double averageReadBytesPerSecond = db.getAverageReadBytesPerMs() * 1000.0;
            double averageWriteBytesPerSecond = db.getAverageWriteBytesPerMs() * 1000.0;
            if (bytesRead > 409600L) {
                System.out.println("  Read speed = " + Database.formatByteString((long)averageReadBytesPerSecond) + "/s");
            }
            if (bytesWritten > 409600L) {
                System.out.println("  Write speed = " + Database.formatByteString((long)averageWriteBytesPerSecond) + "/s");
            }
            System.out.println("  Time spent performing flushes = " + msFormat.format(flushTimeMs) + "ms (" + percentFormat.format(flushPercent) + "%)");
            System.out.println("  Total indexing time = " + msFormat.format(totalTimeMs) + "ms");
        }
        if (DEBUG_ALLOCATIONS) {
            Throwable throwable = null;
            Object var47_41 = null;
            try (IReader readLock = this.nd.acquireReadLock();){
                this.nd.getDB().reportFreeBlocks();
                this.nd.getDB().getMemoryStats().printMemoryStats(this.nd.getTypeRegistry());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void fireDelta(Set<IPath> indexablesWithChanges, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        IProject[] projects = this.root.getProjects();
        ArrayList<IProject> projectsToScan = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject next = iProjectArray[n2];
            if (next.isOpen()) {
                projectsToScan.add(next);
            }
            ++n2;
        }
        JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
        boolean hasChanges = false;
        JavaElementDelta delta = new JavaElementDelta(model);
        SubMonitor projectLoopMonitor = subMonitor.split(1).setWorkRemaining(projectsToScan.size());
        for (IProject project : projectsToScan) {
            projectLoopMonitor.split(1);
            try {
                IPackageFragmentRoot[] roots;
                if (!project.isOpen() || !project.isNatureEnabled("org.eclipse.jdt.core.javanature")) continue;
                IJavaProject javaProject = JavaCore.create(project);
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPath location;
                    IPackageFragmentRoot next = iPackageFragmentRootArray[n4];
                    if (next.isArchive() && indexablesWithChanges.contains(location = JavaIndex.getLocationForElement(next))) {
                        hasChanges = true;
                        delta.changed(next, 32769);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                Package.log(e);
            }
        }
        if (hasChanges) {
            this.fireChange(IndexerEvent.createChange(delta));
        }
    }

    private void updateResourceMappings(Map<IPath, List<IJavaElement>> pathsToUpdate, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)pathsToUpdate.keySet().size());
        JavaIndex index = JavaIndex.getIndex(this.nd);
        for (Map.Entry<IPath, List<IJavaElement>> entry : pathsToUpdate.entrySet()) {
            SubMonitor iterationMonitor = subMonitor.split(1).setWorkRemaining(10);
            this.nd.acquireWriteLock((IProgressMonitor)iterationMonitor.split(1));
            try {
                NdResourceFile resourceFile = index.getResourceFile(entry.getKey().toString().toCharArray());
                if (resourceFile == null) continue;
                this.attachWorkspaceFilesToResource(entry.getValue(), resourceFile);
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
    }

    private int cleanGarbage(long currentTimeMillis, Collection<IPath> allIndexables, IProgressMonitor monitor) {
        JavaIndex index = JavaIndex.getIndex(this.nd);
        int result = 0;
        HashSet<IPath> paths = new HashSet<IPath>();
        paths.addAll(allIndexables);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        ArrayList<NdResourceFile> garbage = new ArrayList<NdResourceFile>();
        ArrayList<NdResourceFile> needsUpdate = new ArrayList<NdResourceFile>();
        long usageTimestampUpdatePeriod = Indexer.getUsageTimestampUpdatePeriod();
        long garbageCleanupTimeout = Indexer.getGarbageCleanupTimeout();
        Throwable throwable = null;
        Object var16_14 = null;
        try (IReader reader = this.nd.acquireReadLock();){
            List<NdResourceFile> resourceFiles = index.getAllResourceFiles();
            result = resourceFiles.size();
            SubMonitor testMonitor = subMonitor.split(1).setWorkRemaining(resourceFiles.size());
            for (NdResourceFile next : resourceFiles) {
                testMonitor.split(1);
                if (!next.isDoneIndexing()) {
                    garbage.add(next);
                    continue;
                }
                Path nextPath = new Path(next.getLocation().toString());
                long timeLastUsed = next.getTimeLastUsed();
                long timeSinceLastUsed = currentTimeMillis - timeLastUsed;
                if (paths.contains(nextPath)) {
                    if (timeSinceLastUsed <= usageTimestampUpdatePeriod) continue;
                    needsUpdate.add(next);
                    continue;
                }
                if (timeSinceLastUsed <= garbageCleanupTimeout) continue;
                garbage.add(next);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        SubMonitor deleteMonitor = subMonitor.split(1).setWorkRemaining(garbage.size());
        for (NdResourceFile next : garbage) {
            this.deleteResource(next, (IProgressMonitor)deleteMonitor.split(1));
        }
        SubMonitor updateMonitor = subMonitor.split(1).setWorkRemaining(needsUpdate.size());
        for (NdResourceFile next : needsUpdate) {
            this.nd.acquireWriteLock((IProgressMonitor)updateMonitor.split(1));
            try {
                if (!next.isInIndex()) continue;
                next.setTimeLastUsed(currentTimeMillis);
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
        return result;
    }

    protected void deleteResource(NdResourceFile toDelete, IProgressMonitor monitor) {
        SubMonitor deletionMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
        try {
            if (toDelete.isInIndex()) {
                toDelete.markAsInvalid();
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        while (true) {
            this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
            try {
                if (!toDelete.isInIndex()) break;
                int numChildren = toDelete.getTypeCount();
                deletionMonitor.setWorkRemaining(numChildren + 1);
                if (numChildren == 0) break;
                NdType nextDeletion = toDelete.getType(numChildren - 1);
                if (DEBUG_INSERTIONS) {
                    Package.logInfo("Deleting " + nextDeletion.getTypeId().getFieldDescriptor().getString() + " from " + toDelete.getLocation().getString() + " " + toDelete.address);
                }
                nextDeletion.delete();
                continue;
            }
            finally {
                this.nd.releaseWriteLock();
                continue;
            }
            break;
        }
        this.nd.acquireWriteLock((IProgressMonitor)deletionMonitor.split(1));
        try {
            if (toDelete.isInIndex()) {
                toDelete.delete();
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
    }

    private Map<IPath, FileFingerprint.FingerprintTestResult> testFingerprints(Collection<IPath> allIndexables, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)allIndexables.size());
        HashMap<IPath, FileFingerprint.FingerprintTestResult> result = new HashMap<IPath, FileFingerprint.FingerprintTestResult>();
        for (IPath next : allIndexables) {
            result.put(next, this.testForChanges(next, (IProgressMonitor)subMonitor.split(1)));
        }
        return result;
    }

    private int rescanArchive(long currentTimeMillis, IPath thePath, List<IJavaElement> elementsMappingOntoLocation, FileFingerprint fingerprint, IProgressMonitor monitor) throws JavaModelException {
        NdResourceFile resourceFile;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (elementsMappingOntoLocation.isEmpty()) {
            return 0;
        }
        IJavaElement element = elementsMappingOntoLocation.get(0);
        String pathString = thePath.toString();
        JavaIndex javaIndex = JavaIndex.getIndex(this.nd);
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
        try {
            resourceFile = new NdResourceFile(this.nd);
            resourceFile.setTimeLastUsed(currentTimeMillis);
            resourceFile.setLocation(pathString);
            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element.getAncestor(3);
            IPath rootPathString = JavaIndex.getLocationForElement(packageFragmentRoot);
            if (!rootPathString.equals((Object)thePath)) {
                resourceFile.setPackageFragmentRoot(rootPathString.toString().toCharArray());
            }
            this.attachWorkspaceFilesToResource(elementsMappingOntoLocation, resourceFile);
        }
        finally {
            this.nd.releaseWriteLock();
        }
        if (DEBUG) {
            Package.logInfo("rescanning " + thePath.toString() + ", " + fingerprint);
        }
        int result = 0;
        try {
            if (fingerprint.fileExists()) {
                result = this.addElement(resourceFile, element, (IProgressMonitor)subMonitor.split(50));
            }
        }
        catch (JavaModelException javaModelException) {
            if (DEBUG) {
                Package.log("the file " + pathString + " cannot be indexed due to a recoverable error", null);
            }
            this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
            try {
                if (resourceFile.isInIndex()) {
                    resourceFile.delete();
                }
            }
            finally {
                this.nd.releaseWriteLock();
            }
            return 0;
        }
        catch (RuntimeException e) {
            if (DEBUG) {
                Package.log("A RuntimeException occurred while indexing " + pathString, e);
            }
            throw e;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fingerprint = FileFingerprint.getEmpty();
        }
        if (DEBUG && !fingerprint.fileExists()) {
            Package.log("the file " + pathString + " was not indexed because it does not exist", null);
        }
        List<Object> allResourcesWithThisPath = Collections.emptyList();
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(1));
        try {
            if (resourceFile.isInIndex()) {
                resourceFile.setFingerprint(fingerprint);
                allResourcesWithThisPath = javaIndex.findResourcesWithPath(pathString);
                this.fileStateCache.remove(resourceFile.getLocation().getString());
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        SubMonitor deletionMonitor = subMonitor.split(40).setWorkRemaining(allResourcesWithThisPath.size() - 1);
        for (NdResourceFile ndResourceFile : allResourcesWithThisPath) {
            if (ndResourceFile.equals(resourceFile)) continue;
            this.deleteResource(ndResourceFile, (IProgressMonitor)deletionMonitor.split(1));
        }
        return result;
    }

    private void attachWorkspaceFilesToResource(List<IJavaElement> elementsMappingOntoLocation, NdResourceFile resourceFile) {
        for (IJavaElement next : elementsMappingOntoLocation) {
            IResource nextResource = next.getResource();
            if (nextResource == null) continue;
            new NdWorkspaceLocation(this.nd, resourceFile, nextResource.getFullPath().toString().toCharArray());
        }
    }

    private int addElement(NdResourceFile resourceFile, IJavaElement element, IProgressMonitor monitor) throws JavaModelException, FileNotFoundException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (element instanceof JarPackageFragmentRoot) {
            JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)element;
            IPath workspacePath = jarRoot.getPath();
            IPath location = JavaIndex.getLocationForElement(jarRoot);
            int classesIndexed = 0;
            try {
                Throwable throwable = null;
                Object var10_21 = null;
                try (ZipFile zipFile = new ZipFile(JavaModelManager.getLocalFile(jarRoot.getPath()));){
                    if (JavaModelManager.throwIoExceptionsInGetZipFile) {
                        if (DEBUG) {
                            Package.logInfo("Throwing simulated IOException for error handling test case");
                        }
                        throw new IOException();
                    }
                    subMonitor.setWorkRemaining(zipFile.size());
                    this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
                    try {
                        resourceFile.allocateZipEntries(zipFile.size());
                    }
                    finally {
                        this.nd.releaseWriteLock();
                    }
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        boolean classFileName;
                        String fileName;
                        ZipEntry member;
                        SubMonitor nextEntry;
                        block47: {
                            nextEntry = subMonitor.split(1).setWorkRemaining(2);
                            member = e.nextElement();
                            fileName = member.getName();
                            classFileName = Util.isClassFileName(fileName);
                            if (member.isDirectory() || !classFileName) {
                                this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
                                try {
                                    if (!resourceFile.isInIndex()) break block47;
                                    if (DEBUG_INSERTIONS) {
                                        Package.logInfo("Inserting non-class file " + fileName + " into " + resourceFile.getLocation().getString() + " " + resourceFile.address);
                                    }
                                    resourceFile.addZipEntry(fileName);
                                    if (!fileName.equals("META-INF/MANIFEST.MF")) break block47;
                                    Throwable throwable2 = null;
                                    Object var18_33 = null;
                                    try (InputStream inputStream = zipFile.getInputStream(member);){
                                        char[] chars = Util.getInputStreamAsCharArray(inputStream, -1, "UTF-8");
                                        resourceFile.setManifestContent(chars);
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                finally {
                                    this.nd.releaseWriteLock();
                                }
                            }
                        }
                        if (member.isDirectory()) continue;
                        nextEntry.split(1);
                        if (!classFileName) continue;
                        String binaryName = fileName.substring(0, fileName.length() - ".class".length());
                        char[] fieldDescriptor = JavaNames.binaryNameToFieldDescriptor(binaryName.toCharArray());
                        String indexPath = String.valueOf(jarRoot.getHandleIdentifier()) + '|' + binaryName;
                        BinaryTypeDescriptor descriptor = new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
                        try {
                            byte[] contents = Util.getZipEntryByteContent(member, zipFile);
                            ClassFileReader classFileReader = new ClassFileReader(contents, descriptor.indexPath, true);
                            if (!this.addClassToIndex(resourceFile, descriptor.fieldDescriptor, descriptor.indexPath, classFileReader, (IProgressMonitor)nextEntry.split(1))) continue;
                            ++classesIndexed;
                        }
                        catch (CoreException | ClassFormatException exception) {
                            Package.log("Unable to index " + descriptor.toString(), exception);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (ZipException e) {
                Package.log("The zip file " + jarRoot.getPath() + " was corrupt", e);
                this.nd.acquireWriteLock(null);
                try {
                    if (resourceFile.isInIndex()) {
                        resourceFile.setFlags(1);
                    }
                }
                finally {
                    this.nd.releaseWriteLock();
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException ioException) {
                throw new JavaModelException(ioException, 985);
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
            if (DEBUG && classesIndexed == 0) {
                Package.logInfo("The path " + element.getPath() + " contained no class files");
            }
            return classesIndexed;
        }
        if (element instanceof IOrdinaryClassFile) {
            IOrdinaryClassFile classFile = (IOrdinaryClassFile)element;
            SubMonitor iterationMonitor = subMonitor.split(1);
            BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
            boolean indexed = false;
            try {
                ClassFileReader classFileReader = BinaryTypeFactory.rawReadTypeTestForExists(descriptor, true, false);
                if (classFileReader != null) {
                    indexed = this.addClassToIndex(resourceFile, descriptor.fieldDescriptor, descriptor.indexPath, classFileReader, (IProgressMonitor)iterationMonitor);
                }
            }
            catch (CoreException | ClassFormatException e) {
                Package.log("Unable to index " + classFile.toString(), e);
            }
            return indexed ? 1 : 0;
        }
        Package.logInfo("Unable to index elements of type " + element);
        return 0;
    }

    private boolean addClassToIndex(NdResourceFile resourceFile, char[] fieldDescriptor, char[] indexPath, ClassFileReader binaryType, IProgressMonitor monitor) throws ClassFormatException, CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ClassFileToIndexConverter converter = new ClassFileToIndexConverter(resourceFile);
        boolean indexed = false;
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(5));
        try {
            if (resourceFile.isInIndex()) {
                if (DEBUG_INSERTIONS) {
                    Package.logInfo("Inserting " + new String(fieldDescriptor) + " into " + resourceFile.getLocation().getString() + " " + resourceFile.address);
                }
                converter.addType(binaryType, fieldDescriptor, (IProgressMonitor)subMonitor.split(45));
                resourceFile.setJdkLevel(binaryType.getVersion());
                indexed = true;
            }
        }
        finally {
            this.nd.releaseWriteLock();
        }
        if (DEBUG_SELFTEST && indexed) {
            JavaIndex index = JavaIndex.getIndex(this.nd);
            try {
                Throwable throwable = null;
                Object var11_14 = null;
                try (IReader readLock = this.nd.acquireReadLock();){
                    NdTypeId typeId = index.findType(fieldDescriptor);
                    NdType targetType = null;
                    if (typeId != null) {
                        List<NdType> implementations = typeId.getTypes();
                        for (NdType nextType : implementations) {
                            NdResourceFile nextResourceFile = nextType.getResourceFile();
                            if (!nextResourceFile.equals(resourceFile)) continue;
                            targetType = nextType;
                            break;
                        }
                    }
                    if (targetType != null) {
                        IndexBinaryType actualType = new IndexBinaryType(TypeRef.create(targetType), indexPath);
                        IndexTester.testType(binaryType, actualType);
                    } else {
                        Package.logInfo("Could not find class in index immediately after indexing it: " + new String(indexPath));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (RuntimeException e) {
                Package.log("Error during indexing: " + new String(indexPath), e);
            }
        }
        return indexed;
    }

    private List<IPath> getIndexablesThatHaveChanged(Collection<IPath> indexables, Map<IPath, FileFingerprint.FingerprintTestResult> fingerprints) {
        ArrayList<IPath> indexablesWithChanges = new ArrayList<IPath>();
        for (IPath next : indexables) {
            FileFingerprint.FingerprintTestResult testResult = fingerprints.get(next);
            if (testResult.matches()) continue;
            indexablesWithChanges.add(next);
        }
        return indexablesWithChanges;
    }

    private FileFingerprint.FingerprintTestResult testForChanges(IPath thePath, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        JavaIndex javaIndex = JavaIndex.getIndex(this.nd);
        String pathString = thePath.toString();
        subMonitor.split(50);
        NdResourceFile resourceFile = null;
        FileFingerprint fingerprint = FileFingerprint.getEmpty();
        this.nd.acquireReadLock();
        try {
            resourceFile = javaIndex.getResourceFile(pathString.toCharArray());
            if (resourceFile != null) {
                fingerprint = resourceFile.getFingerprint();
            }
        }
        finally {
            this.nd.releaseReadLock();
        }
        FileFingerprint.FingerprintTestResult result = fingerprint.test(thePath, (IProgressMonitor)subMonitor.split(40));
        if (resourceFile != null && result.matches() && result.needsNewFingerprint()) {
            this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(10));
            try {
                if (resourceFile.isInIndex()) {
                    if (DEBUG) {
                        Package.logInfo("Writing updated fingerprint for " + thePath + ": " + result.getNewFingerprint());
                    }
                    resourceFile.setFingerprint(result.getNewFingerprint());
                }
            }
            finally {
                this.nd.releaseWriteLock();
            }
        }
        return result;
    }

    public Indexer(Nd toPopulate, IWorkspaceRoot workspaceRoot) {
        this.nd = toPopulate;
        this.root = workspaceRoot;
        this.rescanJob.setSystem(true);
        this.rescanJob.setJobGroup(this.group);
        this.rebuildIndexJob.setSystem(true);
        this.rebuildIndexJob.setJobGroup(this.group);
        this.fileStateCache = FileStateCache.getCache(toPopulate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescanAll() {
        if (DEBUG_SCHEDULING) {
            Package.logInfo("Scheduling rescanAll now");
        }
        Object object = this.automaticIndexingMutex;
        synchronized (object) {
            if (!this.enableAutomaticIndexing) {
                if (!this.indexerDirtiedWhileDisabled) {
                    this.indexerDirtiedWhileDisabled = true;
                }
                return;
            }
        }
        if (!JavaIndex.isEnabled()) {
            return;
        }
        this.rescanJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener newListener) {
        Object object = this.listenersMutex;
        synchronized (object) {
            Set<Listener> oldListeners = this.listeners;
            this.listeners = Collections.newSetFromMap(new WeakHashMap());
            this.listeners.addAll(oldListeners);
            this.listeners.add(newListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener oldListener) {
        Object object = this.listenersMutex;
        synchronized (object) {
            if (!this.listeners.contains(oldListener)) {
                return;
            }
            Set<Listener> oldListeners = this.listeners;
            this.listeners = Collections.newSetFromMap(new WeakHashMap());
            this.listeners.addAll(oldListeners);
            this.listeners.remove(oldListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(IndexerEvent event) {
        Set<Listener> localListeners;
        Object object = this.listenersMutex;
        synchronized (object) {
            localListeners = this.listeners;
        }
        for (Listener next : localListeners) {
            next.consume(event);
        }
    }

    public void waitForIndex(IProgressMonitor monitor) {
    }

    public void waitForIndex(int waitingPolicy, IProgressMonitor monitor) {
        if (!JavaIndex.isEnabled()) {
            return;
        }
        switch (waitingPolicy) {
            case 1: {
                break;
            }
            case 2: {
                if (this.rescanJob.getState() == 0) break;
                throw new OperationCanceledException();
            }
            case 3: {
                this.waitForIndex(monitor);
            }
        }
    }

    public void rebuildIndex(IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.rescanJob.cancel();
        try {
            this.rescanJob.join(0L, (IProgressMonitor)subMonitor.split(1));
        }
        catch (InterruptedException interruptedException) {}
        this.nd.acquireWriteLock((IProgressMonitor)subMonitor.split(1));
        try {
            this.nd.clear((IProgressMonitor)subMonitor.split(2));
            this.nd.getDB().flush();
        }
        finally {
            this.nd.releaseWriteLock();
        }
        if (!JavaIndex.isEnabled()) {
            return;
        }
        this.rescan((IProgressMonitor)subMonitor.split(97));
    }

    public void requestRebuildIndex() {
        this.rebuildIndexJob.schedule();
    }

    public void makeDirty(IPath location) {
        this.fileStateCache.remove(location.toString());
        this.rescanAll();
    }

    public void makeDirty(IProject project) {
        this.fileStateCache.clear();
        this.rescanAll();
    }

    public void makeWorkspacePathDirty(IPath pathToRescan) {
        this.fileStateCache.clear();
        this.rescanAll();
    }

    public static interface Listener {
        public void consume(IndexerEvent var1);
    }
}

