/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.logging.aeri.core.filters;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.util.WildcardPatterns;
import org.eclipse.jdt.annotation.Nullable;

public class StatusIgnorePattern {
    private Pattern pluginPattern;
    private Pattern exceptionPattern;
    private Pattern messagePattern;
    private ExceptionStacktracePosition exceptionPosition;
    private StatusChainPosition statusChainPosition;

    @Nullable
    public static StatusIgnorePattern fromString(String s) {
        String tail;
        int secondSep;
        int firstSep = s.indexOf(58);
        if (firstSep == -1) {
            return null;
        }
        String pluginPattern = s.substring(0, firstSep);
        StatusChainPosition statusChainPosition = StatusChainPosition.ANY;
        if (pluginPattern.startsWith("^")) {
            pluginPattern = pluginPattern.substring(1);
            statusChainPosition = StatusChainPosition.FIRST;
        }
        if ((secondSep = (tail = s.substring(firstSep + 1)).indexOf(58)) == -1) {
            return null;
        }
        String exceptionPattern = tail.substring(0, secondSep);
        ExceptionStacktracePosition exceptionStacktracePosition = ExceptionStacktracePosition.ANY;
        if (exceptionPattern.startsWith("^")) {
            exceptionPattern = exceptionPattern.substring(1);
            exceptionStacktracePosition = ExceptionStacktracePosition.TOP;
        } else if (exceptionPattern.startsWith("$")) {
            exceptionPattern = exceptionPattern.substring(1);
            exceptionStacktracePosition = ExceptionStacktracePosition.BOTTOM;
        }
        String messagePattern = tail.substring(secondSep + 1);
        StatusIgnorePattern ip = new StatusIgnorePattern();
        ip.pluginPattern = WildcardPatterns.convert((String)StringUtils.defaultIfEmpty((CharSequence)pluginPattern, (CharSequence)"*"));
        ip.statusChainPosition = statusChainPosition;
        ip.exceptionPattern = WildcardPatterns.convert((String)StringUtils.defaultIfEmpty((CharSequence)exceptionPattern, (CharSequence)"*"));
        ip.exceptionPosition = exceptionStacktracePosition;
        ip.messagePattern = WildcardPatterns.convert((String)StringUtils.defaultIfEmpty((CharSequence)messagePattern, (CharSequence)"*"));
        return ip;
    }

    public Pattern getPluginPattern() {
        return this.pluginPattern;
    }

    public Pattern getExceptionPattern() {
        return this.exceptionPattern;
    }

    public Pattern getMessagePattern() {
        return this.messagePattern;
    }

    public StatusChainPosition getStatusChainPosition() {
        return this.statusChainPosition;
    }

    public ExceptionStacktracePosition getExceptionPosition() {
        return this.exceptionPosition;
    }

    public boolean matches(IStatus status) {
        if (this.matches(status.getPlugin(), status.getException(), status.getMessage())) {
            return true;
        }
        if (this.statusChainPosition == StatusChainPosition.ANY) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (this.matches(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean matches(String pluginId, Throwable exception, String message) {
        boolean pluginMatches = this.pluginPattern.matcher(pluginId).matches();
        boolean messageMatches = this.messagePattern.matcher(message).matches();
        if (pluginMatches && messageMatches) {
            switch (this.exceptionPosition) {
                case ANY: {
                    Throwable current = exception;
                    while (current != null) {
                        if (this.exceptionPattern.matcher(current.getClass().getName()).matches()) {
                            return true;
                        }
                        current = current.getCause();
                    }
                    break;
                }
                case BOTTOM: {
                    Throwable current = exception;
                    while (current.getCause() != null) {
                        current = current.getCause();
                    }
                    if (!this.exceptionPattern.matcher(current.getClass().getName()).matches()) break;
                    return true;
                }
                case TOP: {
                    if (!this.exceptionPattern.matcher(exception.getClass().getName()).matches()) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static enum ExceptionStacktracePosition {
        TOP,
        BOTTOM,
        ANY;

    }

    public static enum StatusChainPosition {
        FIRST,
        ANY;

    }
}

