/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.junit4;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.parsley.junit4.AbstractEmfParsleyTest;
import org.eclipse.emf.parsley.junit4.ui.util.DisplayHelperTestRule;
import org.eclipse.emf.parsley.junit4.ui.util.RunnableWithResult;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;
import org.junit.Rule;

public abstract class AbstractEmfParsleyShellBasedTest
extends AbstractEmfParsleyTest {
    private static final Logger LOGGER = Logger.getLogger(AbstractEmfParsleyShellBasedTest.class);
    protected static int TAB_INDENT = 2;
    @Rule
    public DisplayHelperTestRule displayHelperTestRule = new DisplayHelperTestRule();

    protected Shell getShell() {
        return this.displayHelperTestRule.getShell();
    }

    protected <T> T syncExec(final RunnableWithResult<T> toExecute) {
        final ArrayList arrayList = new ArrayList();
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    arrayList.add(toExecute.run());
                }
                catch (Throwable e) {
                    LOGGER.error((Object)("Exception in runnable: " + e.getMessage()), e);
                    arrayList.add(null);
                }
            }
        });
        return (T)arrayList.get(0);
    }

    protected void syncExecVoid(final Runnable toExecute) {
        final ArrayList arrayList = new ArrayList();
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    toExecute.run();
                }
                catch (Throwable e) {
                    arrayList.add(e);
                }
            }
        });
        if (!arrayList.isEmpty()) {
            throw Exceptions.sneakyThrow((Throwable)((Throwable)arrayList.get(0)));
        }
    }

    protected Display getDisplay() {
        return this.displayHelperTestRule.getDisplay();
    }

    protected <T> T execAndFlushPendingEvents(RunnableWithResult<T> toExecute) {
        T result = toExecute.run();
        this.flushPendingEvents();
        return result;
    }

    protected void flushPendingEvents() {
        this.displayHelperTestRule.flushPendingEvents();
    }

    protected Image getEMFImageFromObject(Object object) {
        return ExtendedImageRegistry.INSTANCE.getImage(object);
    }

    protected URI getEMFImage(EObject eObject) {
        return URI.createURI((String)(String.valueOf(this.getEMFResourceLocator().getImage("full/obj16/Item").toString()) + "#" + eObject.eClass().getName()));
    }

    protected EMFEditPlugin getEMFResourceLocator() {
        return EMFEditPlugin.INSTANCE;
    }

    protected void assertTable(TableViewer tableViewer, CharSequence expected) {
        Assert.assertEquals((Object)expected.toString().trim().replaceAll("\r", ""), (Object)this.tableItemsRepresentation(tableViewer.getTable().getItems()).trim().replaceAll("\r", ""));
    }

    protected String tableItemsRepresentation(TableItem[] items) {
        StringBuffer buffer = new StringBuffer();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            buffer.append(String.valueOf(item.getText().toString()) + "\n");
            ++n2;
        }
        return buffer.toString();
    }

    protected void assertAllLabels(TreeViewer treeViewer, CharSequence expected) {
        Assert.assertEquals((Object)expected.toString().trim().replaceAll("\r", ""), (Object)this.treeItemsRepresentation(this.getTreeItems(treeViewer)).trim().replaceAll("\r", ""));
    }

    protected TreeItem[] getTreeItems(TreeViewer treeViewer) {
        return treeViewer.getTree().getItems();
    }

    protected String treeItemsRepresentation(TreeItem[] items) {
        StringBuffer buffer = new StringBuffer();
        this.treeItemsRepresentation(items, buffer, 0);
        return buffer.toString();
    }

    private void treeItemsRepresentation(TreeItem[] items, StringBuffer buffer, int tabs) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.treeItemRepresentation(item, buffer, tabs);
            ++n2;
        }
    }

    private void treeItemRepresentation(TreeItem item, StringBuffer buffer, int tabs) {
        int i = 0;
        while (i < tabs) {
            buffer.append(" ");
            ++i;
        }
        buffer.append(String.valueOf(item.getText().toString()) + "\n");
        this.treeItemsRepresentation(item.getItems(), buffer, tabs + TAB_INDENT);
    }
}

