/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.declaration.inheritance.ReplaceFeature;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="useSuperClass", label="Fold Super Class", description="In the metamodel, a number of features are replaced by features of a new super class. In the model, the values are moved to these features based on a mapping.", breaking=true)
public class UseSuperClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class to which the super class is added")
    public EClass subClass;
    @EdaptParameter(description="The new super class")
    public EClass superClass;
    @EdaptParameter(description="The features to be replaced")
    public List<EStructuralFeature> toReplace;
    @EdaptParameter(description="The features by which they are replaced (in the same order)")
    public List<EStructuralFeature> replaceBy;

    @EdaptConstraint(restricts="toReplace", description="The features to be replaced must belong to the sub class")
    public boolean checkToReplaceInSubClass(EStructuralFeature toReplace) {
        return this.subClass.getEStructuralFeatures().contains((Object)toReplace);
    }

    @EdaptConstraint(restricts="replaceBy", description="The features to replace must be available in the super class")
    public boolean checkReplaceByInSuperClass(EStructuralFeature replaceBy) {
        return this.superClass.getEAllStructuralFeatures().contains((Object)replaceBy);
    }

    @EdaptConstraint(description="The number of features to be replaced and to replace them must be the same")
    public boolean checkFeaturesSameSize() {
        return this.toReplace.size() == this.replaceBy.size();
    }

    @EdaptConstraint(description="The features must be of the same multiplicity")
    public boolean checkFeaturesSameMultiplicity() {
        return this.hasSameValue(this.toReplace, this.replaceBy, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_Many());
    }

    @EdaptConstraint(description="The features must be of the same type")
    public boolean checkFeaturesSameType() {
        return this.hasSameValue(this.toReplace, this.replaceBy, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType());
    }

    @Override
    public void execute(Metamodel metamodel, Model model) throws MigrationException {
        this.subClass.getESuperTypes().add((Object)this.superClass);
        this.subClass.getESuperTypes().removeAll((Collection)this.superClass.getEAllSuperTypes());
        int i = 0;
        while (i < this.toReplace.size()) {
            ReplaceFeature operation = new ReplaceFeature();
            operation.replaceBy = this.replaceBy.get(i);
            operation.toReplace = this.toReplace.get(i);
            operation.checkAndExecute(metamodel, model);
            ++i;
        }
    }
}

