/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.util;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenUtil {
    private static Set<String> javaReservedWords;
    private static Set<String> javaDefaultTypes;
    protected static final String MATCH_LINE_SEPARATOR = "(\n\r?|\r\n?)";
    protected static final Pattern BRACE_LINE_PATTERN;

    static {
        BRACE_LINE_PATTERN = Pattern.compile("(\\s*(\n\r?|\r\n?)\\s*\\{\\s*?)(\n\r?|\r\n?)");
    }

    public static Set<String> getJavaReservedWords() {
        if (javaReservedWords == null) {
            HashSet<String> result = new HashSet<String>(100);
            result.add("abstract");
            result.add("assert");
            result.add("boolean");
            result.add("break");
            result.add("byte");
            result.add("case");
            result.add("catch");
            result.add("char");
            result.add("class");
            result.add("const");
            result.add("continue");
            result.add("default");
            result.add("do");
            result.add("double");
            result.add("else");
            result.add("enum");
            result.add("extends");
            result.add("false");
            result.add("final");
            result.add("finally");
            result.add("float");
            result.add("for");
            result.add("goto");
            result.add("if");
            result.add("implements");
            result.add("import");
            result.add("instanceof");
            result.add("int");
            result.add("interface");
            result.add("long");
            result.add("native");
            result.add("new");
            result.add("null");
            result.add("package");
            result.add("private");
            result.add("protected");
            result.add("public");
            result.add("return");
            result.add("short");
            result.add("static");
            result.add("strictfp");
            result.add("super");
            result.add("switch");
            result.add("synchronized");
            result.add("this");
            result.add("throw");
            result.add("throws");
            result.add("transient");
            result.add("true");
            result.add("try");
            result.add("void");
            result.add("volatile");
            result.add("while");
            javaReservedWords = Collections.unmodifiableSet(result);
        }
        return javaReservedWords;
    }

    public static Set<String> getJavaDefaultTypes() {
        if (javaDefaultTypes == null) {
            HashSet<String> result = new HashSet<String>(100);
            result.add("AbstractMethodError");
            result.add("Appendable");
            result.add("ArithmeticException");
            result.add("ArrayIndexOutOfBoundsException");
            result.add("ArrayStoreException");
            result.add("AssertionError");
            result.add("AutoCloseable");
            result.add("Boolean");
            result.add("BootstrapMethodError");
            result.add("Byte");
            result.add("Character");
            result.add("CharSequence");
            result.add("Class");
            result.add("ClassCastException");
            result.add("ClassCircularityError");
            result.add("ClassFormatError");
            result.add("ClassLoader");
            result.add("ClassNotFoundException");
            result.add("ClassValue");
            result.add("Cloneable");
            result.add("CloneNotSupportedException");
            result.add("Comparable");
            result.add("Compiler");
            result.add("Deprecated");
            result.add("Double");
            result.add("Enum");
            result.add("EnumConstantNotPresentException");
            result.add("Error");
            result.add("Exception");
            result.add("ExceptionInInitializerError");
            result.add("Float");
            result.add("FunctionalInterface");
            result.add("IllegalAccessError");
            result.add("IllegalAccessException");
            result.add("IllegalArgumentException");
            result.add("IllegalCallerException");
            result.add("IllegalMonitorStateException");
            result.add("IllegalStateException");
            result.add("IllegalThreadStateException");
            result.add("IncompatibleClassChangeError");
            result.add("IndexOutOfBoundsException");
            result.add("InheritableThreadLocal");
            result.add("InstantiationError");
            result.add("InstantiationException");
            result.add("Integer");
            result.add("InternalError");
            result.add("InterruptedException");
            result.add("Iterable");
            result.add("LayerInstantiationException");
            result.add("LinkageError");
            result.add("Long");
            result.add("Math");
            result.add("Module");
            result.add("ModuleLayer");
            result.add("NegativeArraySizeException");
            result.add("NoClassDefFoundError");
            result.add("NoSuchFieldError");
            result.add("NoSuchFieldException");
            result.add("NoSuchMethodError");
            result.add("NoSuchMethodException");
            result.add("NullPointerException");
            result.add("Number");
            result.add("NumberFormatException");
            result.add("Object");
            result.add("OutOfMemoryError");
            result.add("Override");
            result.add("Package");
            result.add("Process");
            result.add("ProcessBuilder");
            result.add("ProcessHandle");
            result.add("Readable");
            result.add("ReflectiveOperationException");
            result.add("Runnable");
            result.add("Runtime");
            result.add("RuntimeException");
            result.add("RuntimePermission");
            result.add("SafeVarargs");
            result.add("SecurityException");
            result.add("SecurityManager");
            result.add("Short");
            result.add("StackOverflowError");
            result.add("StackTraceElement");
            result.add("StackWalker");
            result.add("StrictMath");
            result.add("String");
            result.add("StringBuffer");
            result.add("StringBuilder");
            result.add("StringIndexOutOfBoundsException");
            result.add("SuppressWarnings");
            result.add("System");
            result.add("Thread");
            result.add("ThreadDeath");
            result.add("ThreadGroup");
            result.add("ThreadLocal");
            result.add("Throwable");
            result.add("TypeNotPresentException");
            result.add("UnknownError");
            result.add("UnsatisfiedLinkError");
            result.add("UnsupportedClassVersionError");
            result.add("UnsupportedOperationException");
            result.add("VerifyError");
            result.add("VirtualMachineError");
            result.add("Void");
            result.add("boolean");
            result.add("byte");
            result.add("char");
            result.add("double");
            result.add("float");
            result.add("int");
            result.add("long");
            result.add("short");
            javaDefaultTypes = Collections.unmodifiableSet(result);
        }
        return javaDefaultTypes;
    }

    public static boolean isJavaReservedWord(String s) {
        return CodeGenUtil.getJavaReservedWords().contains(s);
    }

    public static boolean isJavaDefaultType(String s) {
        return CodeGenUtil.getJavaDefaultTypes().contains(s);
    }

    public static boolean isJavaLangType(String s) {
        return CodeGenUtil.getJavaDefaultTypes().contains(s) && CodeGenUtil.isUpperCase(s.charAt(0));
    }

    public static boolean isJavaPrimitiveType(String s) {
        return CodeGenUtil.getJavaDefaultTypes().contains(s) && CodeGenUtil.isLowerCase(s.charAt(0));
    }

    public static String parseString(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuilder result = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '\\' && len > i + 1) {
                if ("btnfr\"'\\".indexOf(s.charAt(i + 1)) != -1) {
                    c = CodeGenUtil.parseChar(s.substring(i, i + 2));
                    ++i;
                } else if (s.charAt(i + 1) == 'u' && len > i + 5) {
                    c = CodeGenUtil.parseChar(s.substring(i, i + 6));
                    i += 5;
                } else {
                    int j = i + 1;
                    while (j < len && j - i < 4) {
                        char digit = s.charAt(j);
                        if (digit < '0' || digit > '7') break;
                        ++j;
                    }
                    c = CodeGenUtil.parseChar(s.substring(i, j));
                    i = j - 1;
                }
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static char parseChar(String c) {
        int i;
        if (c == null) {
            throw new IllegalArgumentException("null");
        }
        if ("\\b".equals(c)) {
            return '\b';
        }
        if ("\\t".equals(c)) {
            return '\t';
        }
        if ("\\n".equals(c)) {
            return '\n';
        }
        if ("\\f".equals(c)) {
            return '\f';
        }
        if ("\\r".equals(c)) {
            return '\r';
        }
        if ("\\\"".equals(c)) {
            return '\"';
        }
        if ("\\'".equals(c)) {
            return '\'';
        }
        if ("\\\\".equals(c)) {
            return '\\';
        }
        if (c.startsWith("\\u") && c.length() == 6) {
            int i2 = Integer.parseInt(c.substring(2), 16);
            if (i2 >= 0 && i2 <= 65535) {
                return (char)i2;
            }
        } else if (c.length() >= 2 && c.length() <= 4 && c.charAt(0) == '\\' && (i = Integer.parseInt(c.substring(1), 8)) >= 0 && i <= 65535) {
            return (char)i;
        }
        if (c.length() != 1) {
            throw new IllegalArgumentException(c);
        }
        return c.charAt(0);
    }

    public static Diagnostic validateClassName(String name, Object context) {
        return JDTHelper.IS_AVAILABLE ? JDTHelper.validateClassName(name, context) : Diagnostic.OK_INSTANCE;
    }

    public static Diagnostic validatePackageName(String name, Object context) {
        return JDTHelper.IS_AVAILABLE ? JDTHelper.validatePackageName(name, context) : Diagnostic.OK_INSTANCE;
    }

    public static String validJavaIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EclipseHelper.isValidJavaIdentifier(name)) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            result.append(name.charAt(0));
        } else {
            result.append('_');
            if (Character.isJavaIdentifierPart(name.charAt(0))) {
                result.append(name.charAt(0));
            }
        }
        int i = 1;
        while (i < name.length()) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) {
                result.append(name.charAt(i));
            }
            ++i;
        }
        return result.length() == 0 ? "_" : result.toString();
    }

    public static String capName(String name, Locale locale) {
        if (name.length() == 0) {
            return name;
        }
        return String.valueOf(name.substring(0, 1).toUpperCase(locale)) + name.substring(1);
    }

    public static String capName(String name) {
        return CodeGenUtil.capName(name, Locale.getDefault());
    }

    public static String uncapName(String name, Locale locale) {
        if (name.length() == 0) {
            return name;
        }
        return String.valueOf(name.substring(0, 1).toLowerCase(locale)) + name.substring(1);
    }

    public static String uncapName(String name) {
        return CodeGenUtil.uncapName(name, Locale.getDefault());
    }

    public static String uncapPrefixedName(String name, boolean forceDifferent, Locale locale) {
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase(locale);
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == lowerName.charAt(i)) break;
            ++i;
        }
        if (i > 1 && i < name.length() && !CodeGenUtil.isDigit(name.charAt(i))) {
            --i;
        }
        String prefix = name.substring(0, i);
        String lowerCasePrefix = prefix.toLowerCase(locale);
        if (forceDifferent && lowerCasePrefix.equals(prefix)) {
            lowerCasePrefix = "_" + lowerCasePrefix;
        }
        return String.valueOf(lowerCasePrefix) + name.substring(i);
    }

    public static String uncapPrefixedName(String name, boolean forceDifferent) {
        return CodeGenUtil.uncapPrefixedName(name, forceDifferent, Locale.getDefault());
    }

    public static String safeName(String name) {
        if (CodeGenUtil.isJavaReservedWord(name)) {
            return String.valueOf(name) + "_";
        }
        return name;
    }

    public static String upperName(String name, Locale locale) {
        return CodeGenUtil.format(name, '_', null, false, true).toUpperCase(locale);
    }

    public static String upperName(String name) {
        return CodeGenUtil.upperName(name, Locale.getDefault());
    }

    @Deprecated
    public static String format(String name, char separator, String prefix, boolean includePrefix) {
        return CodeGenUtil.format(name, separator, prefix, includePrefix, false);
    }

    public static String format(String name, char separator, String prefix, boolean includePrefix, boolean includeLeadingSeparator) {
        String leadingSeparators;
        String string = leadingSeparators = includeLeadingSeparator ? CodeGenUtil.getLeadingSeparators(name, '_') : null;
        if (leadingSeparators != null) {
            name = name.substring(leadingSeparators.length());
        }
        List<String> parsedName = new ArrayList<String>();
        if (prefix != null && name.startsWith(prefix) && name.length() > prefix.length() && CodeGenUtil.isUpperCase(name.charAt(prefix.length()))) {
            name = name.substring(prefix.length());
            if (includePrefix) {
                parsedName = CodeGenUtil.parseName(prefix, '_');
            }
        }
        if (name.length() != 0) {
            parsedName.addAll(CodeGenUtil.parseName(name, '_'));
        }
        StringBuilder result = new StringBuilder();
        Iterator nameIter = parsedName.iterator();
        while (nameIter.hasNext()) {
            String nameComponent = (String)nameIter.next();
            result.append(nameComponent);
            if (!nameIter.hasNext() || nameComponent.length() <= 1) continue;
            result.append(separator);
        }
        if (result.length() == 0 && prefix != null) {
            result.append(prefix);
        }
        return leadingSeparators != null ? "_" + result.toString() : result.toString();
    }

    private static String getLeadingSeparators(String name, char separator) {
        int i = 0;
        int len = name.length();
        while (i < len && name.charAt(i) == separator) {
            ++i;
        }
        return i != 0 ? name.substring(0, i) : null;
    }

    public static List<String> parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (CodeGenUtil.isUpperCase(curChar) || !lastIsLower && CodeGenUtil.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuilder();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != separator) {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }

    public static String javaIdentifier(String sourceName, Locale locale) {
        StringBuilder result = new StringBuilder();
        if (sourceName != null) {
            StringBuilder currentWord = new StringBuilder();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char codePoint = sourceName.charAt(index);
                if (CodeGenUtil.isUpperCase(codePoint) || !lastIsLower && CodeGenUtil.isDigit(codePoint) || Character.isJavaIdentifierPart((int)codePoint)) {
                    if (lastIsLower && currentWord.length() > 1 || (codePoint == '$' || codePoint == '_') && currentWord.length() > 0) {
                        result.append(CodeGenUtil.capName(currentWord.toString(), locale));
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = false;
                } else {
                    if (!lastIsLower) {
                        result.append(CodeGenUtil.capName(currentWord.toString(), locale));
                        currentWord = new StringBuilder();
                    }
                    lastIsLower = true;
                }
                if (codePoint != '_' && codePoint != '$' && Character.isJavaIdentifierPart((int)codePoint)) {
                    currentWord.appendCodePoint(codePoint);
                }
                index = sourceName.offsetByCodePoints(index, 1);
            }
            result.append(CodeGenUtil.capName(currentWord.toString(), locale));
        }
        return result.length() == 0 || !Character.isJavaIdentifierStart(result.codePointAt(0)) ? "_" + result : result.toString();
    }

    @Deprecated
    public static boolean isInJavaOutput(IResource resource) {
        return EclipseUtil.isInJavaOutput(resource);
    }

    @Deprecated
    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IPath localLocation, IProgressMonitor progressMonitor) throws CoreException {
        return EclipseUtil.findOrCreateContainer(path, forceRefresh, localLocation, progressMonitor);
    }

    @Deprecated
    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IProjectDescription projectDescription, IProgressMonitor progressMonitor) throws CoreException {
        return EclipseUtil.findOrCreateContainer(path, forceRefresh, projectDescription, progressMonitor);
    }

    @Deprecated
    public static List<String> getClasspathPaths(String pluginID) throws JETException {
        return EclipseUtil.getClasspathPaths(pluginID);
    }

    @Deprecated
    public static void addClasspathEntries(Collection<?> classpathEntries, String variableName, String pluginID) throws JETException {
        EclipseUtil.addClasspathEntries(classpathEntries, variableName, pluginID);
    }

    @Deprecated
    public static void addClasspathEntries(Collection<?> classpathEntries, String pluginID) throws Exception {
        EclipseUtil.addClasspathEntries(classpathEntries, pluginID);
    }

    public static String getPackageName(String qualifiedClassName) {
        int index;
        if (qualifiedClassName != null && (index = qualifiedClassName.lastIndexOf(46)) >= 0) {
            return qualifiedClassName.substring(0, index);
        }
        return null;
    }

    public static String getSimpleClassName(String qualifiedClassName) {
        int index;
        if (qualifiedClassName != null && (index = qualifiedClassName.lastIndexOf(46)) >= 0) {
            return qualifiedClassName.substring(index + 1);
        }
        return qualifiedClassName;
    }

    public static Monitor createMonitor(Monitor monitor, int ticks) {
        return EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.createMonitor(monitor, ticks) : monitor;
    }

    public static String convertFormat(String tabReplacement, boolean convertToStandardBraceStyle, String value) {
        if (tabReplacement != null && !"\t".equals(tabReplacement)) {
            char[] text = value.toCharArray();
            StringBuilder result = new StringBuilder(text.length + text.length / 10);
            boolean blankLine = true;
            int tabCount = 0;
            int previous = 0;
            int i = 0;
            int length = text.length;
            while (i < length) {
                char c = text[i];
                if (c == '\t') {
                    if (blankLine) {
                        ++tabCount;
                    }
                } else {
                    if (tabCount > 0) {
                        result.append(text, previous, i - tabCount - previous);
                        int j = 0;
                        while (j < tabCount) {
                            result.append(tabReplacement);
                            ++j;
                        }
                        previous = i;
                        tabCount = 0;
                    }
                    blankLine = c == '\n' || c == '\r';
                }
                ++i;
            }
            result.append(text, previous, text.length - previous);
            value = result.toString();
        }
        if (convertToStandardBraceStyle) {
            value = new BraceFixer().apply(value);
        }
        return value;
    }

    public static String unicodeEscapeEncode(String unicode) {
        StringBuilder result = new StringBuilder(unicode.length());
        int i = 0;
        int size = unicode.length();
        while (i < size) {
            char character = unicode.charAt(i);
            if (character > '\u00ff') {
                result.append("\\u");
                String hex = Integer.toString(character, 16);
                int j = hex.length();
                while (j < 4) {
                    result.append("0");
                    ++j;
                }
                result.append(hex);
            } else {
                result.append(character);
            }
            ++i;
        }
        return result.toString();
    }

    public static String xmlEscapeEncode(String value) {
        StringBuilder result = new StringBuilder(value.length());
        int i = 0;
        int size = value.length();
        while (i < size) {
            char character = value.charAt(i);
            switch (character) {
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                default: {
                    result.append(character);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String xmlEscapeDecode(String value) {
        return value.replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">");
    }

    public static FacadeHelper instantiateFacadeHelper(String facadeHelperClass) {
        try {
            Class<?> cls = Class.forName(facadeHelperClass);
            if (FacadeHelper.class.isAssignableFrom(cls)) {
                return (FacadeHelper)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception cls) {
            // empty catch block
        }
        FacadeHelper result = null;
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            result = EclipseHelper.instantiateRegisteredFacadeHelper(facadeHelperClass);
        }
        if (result == null) {
            CodeGenPlugin.INSTANCE.log(new Exception("Unable to instantiate a facade helper for " + facadeHelperClass));
        }
        return result;
    }

    public static String validPluginID(String base) {
        StringBuffer sb = new StringBuffer(base);
        int i = sb.length() - 1;
        while (i >= 0) {
            char c = sb.charAt(i);
            if (!('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '-' || c == '.')) {
                if (c == ' ') {
                    sb.setCharAt(i, '_');
                } else {
                    sb.deleteCharAt(i);
                }
            }
            --i;
        }
        return sb.length() == 0 ? "_" : sb.toString();
    }

    public static boolean isUncheckedCast(String type) {
        int start = type.indexOf("<");
        int end = type.lastIndexOf(">");
        if (start != -1 && end != -1) {
            int i = start + 1;
            while (i < end) {
                switch (type.charAt(i)) {
                    case ' ': 
                    case ',': 
                    case '?': {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean isUpperCase(int codePoint) {
        if (codePoint < 128) {
            return codePoint >= 65 && codePoint <= 90;
        }
        return Character.isUpperCase(codePoint);
    }

    private static boolean isLowerCase(int codePoint) {
        if (codePoint < 128) {
            return codePoint >= 97 && codePoint <= 122;
        }
        return Character.isLowerCase(codePoint);
    }

    private static boolean isDigit(int codePoint) {
        if (codePoint < 128) {
            return codePoint >= 48 && codePoint <= 57;
        }
        return Character.isDigit(codePoint);
    }

    private static class BraceFixer {
        protected char[] string;
        protected StringBuilder stringBuilder;
        protected int current;

        private BraceFixer() {
        }

        public String apply(String string) {
            this.current = 0;
            this.string = string.toCharArray();
            this.stringBuilder = new StringBuilder();
            int i = 0;
            int length = this.string.length;
            while (i < length) {
                int begin;
                int end;
                char character = this.string[i];
                if (character == '{' && (end = this.scanForLineEnd(i + 1)) != -1 && (begin = this.scanForStart(i - 1)) != -1) {
                    this.handleMatch(begin, end);
                    i = end;
                }
                ++i;
            }
            this.stringBuilder.append(this.string, this.current, this.string.length - this.current);
            return this.stringBuilder.toString();
        }

        private int scanForLineEnd(int index) {
            int i = index;
            int length = this.string.length;
            while (i < length) {
                char character = this.string[i];
                if (character == '\n') {
                    return i;
                }
                if (character == '\r') {
                    if (++i >= length || this.string[i] != '\n') break;
                    return i - 1;
                }
                if (character != ' ' && character != '\t') break;
                ++i;
            }
            return -1;
        }

        private int scanForStart(int index) {
            boolean sawLineFeed = false;
            int i = index;
            while (i >= 0) {
                char character = this.string[i];
                if (character == '\n') {
                    if (i > 0 && this.string[i - 1] == '\r') {
                        --i;
                    }
                    sawLineFeed = true;
                } else if (character != ' ' && character != '\t') {
                    if (sawLineFeed) {
                        return i + 1;
                    }
                    return -1;
                }
                --i;
            }
            return -1;
        }

        public void replace(int begin, int end, String replacement) {
            this.stringBuilder.append(this.string, this.current, begin - this.current);
            this.stringBuilder.append(replacement);
            this.current = end;
        }

        public boolean handleMatch(int begin, int end) {
            if (this.current != 0 && (begin <= this.current || this.string[begin - 1] == ';')) {
                return true;
            }
            int i = begin - 1;
            while (i >= this.current) {
                char character = this.string[i];
                if (character == '\n' || character == '\r' || i == this.current) {
                    boolean slash = false;
                    while (++i < begin) {
                        character = this.string[i];
                        if (character == '/') {
                            if (slash) {
                                return true;
                            }
                            slash = true;
                            continue;
                        }
                        slash = false;
                    }
                    break;
                }
                --i;
            }
            this.replace(begin, end, " {");
            return true;
        }
    }

    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static Monitor createMonitor(Monitor monitor, int ticks) {
            if (monitor instanceof IProgressMonitor) {
                return new BasicMonitor.EclipseSubProgress((IProgressMonitor)monitor, ticks);
            }
            return new BasicMonitor.EclipseSubProgress(BasicMonitor.toIProgressMonitor((Monitor)monitor), ticks);
        }

        public static boolean isValidJavaIdentifier(String name) {
            return JavaConventions.validateIdentifier((String)name, (String)"1.5", (String)"1.5").isOK();
        }

        public static FacadeHelper instantiateRegisteredFacadeHelper(String facadeHelperClass) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.codegen", "facadeHelpers");
            IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configurationElements.length) {
                if ("facadeHelper".equals(configurationElements[i].getName()) && facadeHelperClass.equals(configurationElements[i].getAttribute("class"))) {
                    try {
                        Object object = configurationElements[i].createExecutableExtension("class");
                        if (object instanceof FacadeHelper) {
                            return (FacadeHelper)object;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++i;
            }
            return null;
        }

        public static String[] getJavaCompliance(Object context) {
            URI uri;
            if (context instanceof IResource) {
                String compliance;
                IResource resource = (IResource)context;
                IProject project = resource.getProject();
                IJavaProject javaProject = JavaCore.create((IProject)project);
                String source = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
                if (source == null) {
                    source = "1.5";
                }
                if ((compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)) == null) {
                    compliance = "1.5";
                }
                return new String[]{source, compliance};
            }
            if (context instanceof URI && EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (uri = (URI)context).isPlatformResource()) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IFile file = root.getFile((IPath)new Path(uri.toPlatformString(true)));
                return EclipseHelper.getJavaCompliance(file);
            }
            if (context instanceof String) {
                return EclipseHelper.getJavaCompliance(URI.createURI((String)context.toString()));
            }
            return new String[]{"1.5", "1.5"};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EclipseUtil {
        private static final int JLS;
        private static final int JLS4;
        public static final String PLUGIN_ID_CLASSPATH_ATTRIBUTE_NAME = "plugin_id";

        static {
            Field field2;
            int jls = 3;
            try {
                field2 = AST.class.getField("JLS4");
                jls = (Integer)field2.get(null);
            }
            catch (Throwable field2) {
                // empty catch block
            }
            JLS4 = jls;
            try {
                field2 = AST.class.getField("JLS8");
                jls = (Integer)field2.get(null);
            }
            catch (Throwable field3) {
                // empty catch block
            }
            try {
                field2 = AST.class.getField("JLS9");
                jls = (Integer)field2.get(null);
            }
            catch (Throwable field4) {
                // empty catch block
            }
            try {
                field2 = AST.class.getField("JLS10");
                jls = (Integer)field2.get(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JLS = jls;
        }

        public static ASTParser newASTParser() {
            return ASTParser.newParser((int)JLS4);
        }

        public static ASTParser newASTParser(boolean latest) {
            return ASTParser.newParser((int)(latest ? JLS : JLS4));
        }

        public static boolean isInJavaOutput(IResource resource) {
            IProject project = resource.getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                if (javaProject.exists() && project != project.getWorkspace().getRoot().findMember(javaProject.getOutputLocation()) && javaProject.getOutputLocation().isPrefixOf(resource.getFullPath())) {
                    return true;
                }
            }
            catch (JavaModelException exception) {
                CodeGenPlugin.INSTANCE.log((Object)exception);
            }
            return false;
        }

        public static List<String> getClasspathPaths(String pluginID) throws JETException {
            ArrayList<String> result;
            block11: {
                result = new ArrayList<String>();
                try {
                    ManifestElement[] elements;
                    Bundle bundle = Platform.getBundle((String)pluginID);
                    String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
                    if (requires == null) {
                        requires = ".";
                    }
                    if ((elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires)) == null) break block11;
                    int i = 0;
                    while (i < elements.length) {
                        ManifestElement element = elements[i];
                        String value = element.getValue();
                        if (".".equals(value)) {
                            value = "/";
                        }
                        try {
                            URL url = bundle.getEntry(value);
                            if (url != null) {
                                URL resolvedURL = FileLocator.resolve((URL)url);
                                String resolvedURLString = resolvedURL.toString();
                                if (resolvedURLString.endsWith("!/")) {
                                    resolvedURLString = resolvedURL.getFile();
                                    resolvedURLString = resolvedURLString.substring(0, resolvedURLString.length() - "!/".length());
                                }
                                if (resolvedURLString.startsWith("file:")) {
                                    result.add(resolvedURLString.substring("file:".length()));
                                } else {
                                    result.add(FileLocator.toFileURL((URL)url).getFile());
                                }
                            }
                        }
                        catch (IOException exception) {
                            throw new JETException(exception);
                        }
                        ++i;
                    }
                }
                catch (BundleException exception) {
                    throw new JETException(exception);
                }
            }
            return result;
        }

        public static void addClasspathEntries(Collection<IClasspathEntry> classpathEntries, String variableName, String pluginID) throws JETException {
            ListIterator<String> i = EclipseUtil.getClasspathPaths(pluginID).listIterator();
            while (i.hasNext()) {
                Path path = new Path(i.next());
                if (variableName == null) {
                    classpathEntries.add(JavaCore.newLibraryEntry((IPath)path, null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)PLUGIN_ID_CLASSPATH_ATTRIBUTE_NAME, (String)pluginID)}, (boolean)true));
                    continue;
                }
                String mangledName = String.valueOf(variableName) + (i.previousIndex() == 0 ? "" : "_" + i.previousIndex());
                try {
                    JavaCore.setClasspathVariable((String)mangledName, (IPath)path, null);
                }
                catch (JavaModelException exception) {
                    throw new JETException(exception);
                }
                classpathEntries.add(JavaCore.newVariableEntry((IPath)new Path(mangledName), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)PLUGIN_ID_CLASSPATH_ATTRIBUTE_NAME, (String)pluginID)}, (boolean)true));
            }
        }

        public static void addClasspathEntries(Collection<IClasspathEntry> classpathEntries, String pluginID) throws JETException {
            EclipseUtil.addClasspathEntries(classpathEntries, null, pluginID);
        }

        public static Monitor createMonitor(IProgressMonitor monitor, int ticks) {
            return new BasicMonitor.EclipseSubProgress(monitor, ticks);
        }

        public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IPath localLocation, IProgressMonitor progressMonitor) throws CoreException {
            String projectName = path.segment(0);
            IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
            projectDescription.setLocation(localLocation);
            return EclipseUtil.findOrCreateContainer(path, forceRefresh, projectDescription, progressMonitor);
        }

        public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IProjectDescription projectDescription, IProgressMonitor progressMonitor) throws CoreException {
            try {
                String projectName = path.segment(0);
                progressMonitor.beginTask("", path.segmentCount() + 3);
                progressMonitor.subTask(CodeGenPlugin.getPlugin().getString("_UI_ExaminingProject_message", new Object[]{projectName}));
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(path.segment(0));
                if (forceRefresh) {
                    project.refreshLocal(2, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                } else {
                    progressMonitor.worked(1);
                }
                if (!project.exists()) {
                    project.create(projectDescription, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    project.open((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                } else {
                    project.open((IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)2));
                }
                IProject container = project;
                int i = 1;
                int length = path.segmentCount();
                while (i < length) {
                    IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                    if (!folder.exists()) {
                        folder.create(false, true, (IProgressMonitor)BasicMonitor.subProgress((IProgressMonitor)progressMonitor, (int)1));
                    } else {
                        progressMonitor.worked(1);
                    }
                    container = folder;
                    ++i;
                }
                IProject iProject = container;
                return iProject;
            }
            finally {
                progressMonitor.done();
            }
        }

        public static String getJavaComplianceLevel(IProject project) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            return javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }

        public static class StreamProgressMonitor
        extends NullProgressMonitor {
            protected PrintStream printStream;

            public StreamProgressMonitor(PrintStream printStream) {
                this.printStream = printStream;
            }

            public void beginTask(String name, int totalWork) {
                if (name != null && name.length() != 0) {
                    this.printStream.println(">>> " + name);
                }
                super.beginTask(name, totalWork);
            }

            public void setTaskName(String name) {
                if (name != null && name.length() != 0) {
                    this.printStream.println("<>> " + name);
                }
                super.setTaskName(name);
            }

            public void subTask(String name) {
                if (name != null && name.length() != 0) {
                    this.printStream.println(">>  " + name);
                }
                super.subTask(name);
            }
        }
    }

    private static class JDTHelper {
        public static boolean IS_AVAILABLE;

        static {
            boolean isAvailable = false;
            try {
                Status.OK_STATUS.toString();
                isAvailable = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IS_AVAILABLE = isAvailable;
        }

        private JDTHelper() {
        }

        public static String[] getJavaCompliance(Object context) {
            String[] stringArray;
            if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
                stringArray = EclipseHelper.getJavaCompliance(context);
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "1.5";
                stringArray = stringArray2;
                stringArray2[1] = "1.5";
            }
            return stringArray;
        }

        public static Diagnostic validateClassName(String name, Object context) {
            String[] javaCompliance = JDTHelper.getJavaCompliance(context);
            IStatus status = JavaConventions.validateJavaTypeName((String)name, (String)javaCompliance[0], (String)javaCompliance[1]);
            return BasicDiagnostic.toDiagnostic((IStatus)status);
        }

        public static Diagnostic validatePackageName(String name, Object context) {
            String[] javaCompliance = JDTHelper.getJavaCompliance(context);
            IStatus status = JavaConventions.validatePackageName((String)name, (String)javaCompliance[0], (String)javaCompliance[1]);
            return BasicDiagnostic.toDiagnostic((IStatus)status);
        }
    }

    @Deprecated
    public static class StreamProgressMonitor
    extends EclipseUtil.StreamProgressMonitor {
        public StreamProgressMonitor(PrintStream printStream) {
            super(printStream);
        }
    }
}

