/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.providers.content.virtual.VirtualNode;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SchemaObjectEditorExtensionsRegistryReader;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.navigator.CommonViewer;

public class SchemaObjectEditorUtils {
    public static IEditorPart openEditor(String dbName, String dbVersion, String objectTypeId, ISchemaObjectEditModel modelObject, DatabaseIdentifier databaseIdentifier) {
        IEditorDescriptor editor = SchemaObjectEditorUtils.getEditor(dbName, dbVersion, objectTypeId);
        if (editor != null) {
            SchemaObjectEditorInput input = new SchemaObjectEditorInput(editor, modelObject, databaseIdentifier);
            IEditorPart part = null;
            try {
                part = SOEUIPlugin.getActiveWorkbenchPage().openEditor((IEditorInput)input, "org.eclipse.datatools.sqltools.schemaobjecteditor.editor");
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 0, String.valueOf(Messages.SchemaObjectEditorUtils_internal_error_when_opening) + editor.getEditorName(), (Throwable)e);
                ErrorDialog.openError((Shell)SOEUIPlugin.getActiveWorkbenchShell(), (String)Messages.SchemaObjectEditorUtils_error, (String)Messages.SchemaObjectEditorUtils_error_when_open, (IStatus)status);
            }
            return part;
        }
        Status status = new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 0, Messages.SchemaObjectEditorUtils_no_suitable_editor, null);
        ErrorDialog.openError((Shell)SOEUIPlugin.getActiveWorkbenchShell(), (String)Messages.SchemaObjectEditorUtils_error, (String)(String.valueOf(Messages.SchemaObjectEditorUtils_vendor_name) + dbName + Messages.SchemaObjectEditorUtils_version + dbVersion + Messages.SchemaObjectEditorUtils_object_type + objectTypeId + Messages.SchemaObjectEditorUtils_no_editor), (IStatus)status);
        return null;
    }

    public static IEditorPart openEditor(String editorId, ISchemaObjectEditModel modelObject, DatabaseIdentifier databaseIdentifier) {
        IEditorDescriptor editor = SchemaObjectEditorUtils.getEditorById(editorId);
        if (editor != null) {
            SchemaObjectEditorInput input = new SchemaObjectEditorInput(editor, modelObject, databaseIdentifier);
            IEditorPart part = null;
            try {
                part = SOEUIPlugin.getActiveWorkbenchPage().openEditor((IEditorInput)input, "org.eclipse.datatools.sqltools.schemaobjecteditor.editor");
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 0, String.valueOf(Messages.SchemaObjectEditorUtils_internal_error_when_opening) + editor.getEditorName(), (Throwable)e);
                ErrorDialog.openError((Shell)SOEUIPlugin.getActiveWorkbenchShell(), (String)Messages.SchemaObjectEditorUtils_error, (String)Messages.SchemaObjectEditorUtils_error_open, (IStatus)status);
            }
            return part;
        }
        Status status = new Status(4, "org.eclipse.datatools.sqltools.schemaobjecteditor.ui", 0, Messages.SchemaObjectEditorUtils_no_suitable_editor, null);
        ErrorDialog.openError((Shell)SOEUIPlugin.getActiveWorkbenchShell(), (String)Messages.SchemaObjectEditorUtils_error, (String)(String.valueOf(Messages.SchemaObjectEditorUtils_editor_id) + editorId + Messages.SchemaObjectEditorUtils_no_extension), (IStatus)status);
        return null;
    }

    protected static synchronized IEditorDescriptor getEditor(String dbName, String dbVersion, String objectTypeId) {
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        if (editors != null) {
            ArrayList<IEditorDescriptor> matcheres = new ArrayList<IEditorDescriptor>();
            ArrayList<String> versions = new ArrayList<String>();
            int i = 0;
            while (i < editors.length) {
                if (editors[i].getVendorName().equals(dbName) && editors[i].getSchemaObjectType().equals(objectTypeId)) {
                    DatabaseVendorDefinitionId.VersionComparator comparator = new DatabaseVendorDefinitionId.VersionComparator();
                    int result = comparator.compare((Object)dbVersion, (Object)editors[i].getVersion());
                    if (result == 0) {
                        return editors[i];
                    }
                    matcheres.add(editors[i]);
                    versions.add(editors[i].getVersion());
                }
                ++i;
            }
            if (matcheres.size() > 0) {
                IEditorDescriptor editorToUse = null;
                Collections.sort(versions);
                String highest = (String)versions.get(versions.size() - 1);
                for (IEditorDescriptor editor : matcheres) {
                    if (!editor.getVersion().equals(highest)) continue;
                    editorToUse = editor;
                }
                IPreferenceStore store = SOEUIPlugin.getDefault().getPreferenceStore();
                if (!store.getBoolean("SchemaObjectEditorPreferencePage.use.latest.version")) {
                    MessageDialogWithToggle d = MessageDialogWithToggle.openYesNoQuestion((Shell)SOEUIPlugin.getActiveWorkbenchShell(), (String)Messages.SchemaObjectEditorUtils_question, (String)(String.valueOf(Messages.SchemaObjectEditorUtils_no_exact_editor) + dbVersion + Messages.SchemaObjectEditorUtils_use_higest_version_editor), (String)Messages.SchemaObjectEditorUtils_always_open, (boolean)false, (IPreferenceStore)store, (String)"SchemaObjectEditorPreferencePage.use.latest.version");
                    int result = d.getReturnCode();
                    switch (result) {
                        case 2: {
                            if (d.getToggleState()) {
                                store.setValue("SchemaObjectEditorPreferencePage.use.latest.version", true);
                            }
                            return editorToUse;
                        }
                        case 3: {
                            return null;
                        }
                    }
                } else {
                    return editorToUse;
                }
            }
        }
        return null;
    }

    public static synchronized IEditorDescriptor getEditorByObjectType(String dbName, String dbVersion, EClass objectType) {
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        if (editors != null) {
            ArrayList<IEditorDescriptor> matcheres = new ArrayList<IEditorDescriptor>();
            ArrayList<String> versions = new ArrayList<String>();
            String objectTypeId = objectType.getInstanceClassName();
            int i = 0;
            while (i < editors.length) {
                if (editors[i].getVendorName().equals(dbName) && editors[i].getSchemaObjectType().equals(objectTypeId)) {
                    DatabaseVendorDefinitionId.VersionComparator comparator = new DatabaseVendorDefinitionId.VersionComparator();
                    int result = comparator.compare((Object)dbVersion, (Object)editors[i].getVersion());
                    if (result == 0) {
                        return editors[i];
                    }
                    matcheres.add(editors[i]);
                    versions.add(editors[i].getVersion());
                }
                ++i;
            }
            if (matcheres.size() > 0) {
                return (IEditorDescriptor)matcheres.get(0);
            }
            i = 0;
            while (i < editors.length) {
                if (editors[i].getVendorName().equals(dbName)) {
                    EClass clazz = EcoreFactoryImpl.eINSTANCE.createEClass();
                    clazz.setInstanceClassName(editors[i].getSchemaObjectType());
                    if (clazz.isSuperTypeOf(objectType)) {
                        DatabaseVendorDefinitionId.VersionComparator comparator = new DatabaseVendorDefinitionId.VersionComparator();
                        int result = comparator.compare((Object)dbVersion, (Object)editors[i].getVersion());
                        if (result == 0) {
                            return editors[i];
                        }
                        matcheres.add(editors[i]);
                        versions.add(editors[i].getVersion());
                    }
                }
                ++i;
            }
            if (matcheres.size() > 0) {
                return (IEditorDescriptor)matcheres.get(0);
            }
        }
        return null;
    }

    public static IEditorDescriptor getEditorById(String editorId) {
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].getEditorId().equals(editorId)) {
                return editors[i];
            }
            ++i;
        }
        return null;
    }

    public static IEditorDescriptor[] getEditorsByName(String editorName) {
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        ArrayList<IEditorDescriptor> es = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].getEditorName().equals(editorName)) {
                es.add(editors[i]);
            }
            ++i;
        }
        return es.toArray(new IEditorDescriptor[es.size()]);
    }

    public static IEditorDescriptor[] getEditorsByVendorName(String vendorName) {
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        ArrayList<IEditorDescriptor> es = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].getVendorName().equals(vendorName)) {
                es.add(editors[i]);
            }
            ++i;
        }
        return es.toArray(new IEditorDescriptor[es.size()]);
    }

    public static Map getEditorsCatalogedByDBDefinition() {
        HashMap editorsMap = new HashMap();
        SchemaObjectEditorExtensionsRegistryReader reader = SchemaObjectEditorExtensionsRegistryReader.getInstance();
        IEditorDescriptor[] editors = reader.getEditorDescriptors();
        IEditorDescriptor[] clonedEditors = (IEditorDescriptor[])editors.clone();
        int i = 0;
        while (i < clonedEditors.length) {
            List<IEditorDescriptor> es;
            String dbdefinition = String.valueOf(clonedEditors[i].getVendorName()) + "_" + clonedEditors[i].getVersion();
            if (editorsMap.get(dbdefinition) != null) {
                es = (List)editorsMap.get(dbdefinition);
                es.add(clonedEditors[i]);
            } else {
                es = new ArrayList();
                es.add(clonedEditors[i]);
                editorsMap.put(dbdefinition, es);
            }
            ++i;
        }
        return editorsMap;
    }

    public static void expandNode(SQLObject obj) {
    }

    public static TreeItem findAndExpandVirtualNode(TreeItem item, String NodeType, CommonViewer viewer) {
        if (item == null) {
            return null;
        }
        TreeItem[] treeItems = item.getItems();
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getData() instanceof VirtualNode && ((VirtualNode)treeItems[i].getData()).getGroupID().equals(NodeType)) {
                viewer.expandToLevel(treeItems[i].getData(), 1);
                return treeItems[i];
            }
            ++i;
        }
        return null;
    }

    public static TreeItem findAndExpandObjectNode(TreeItem item, SQLObject obj, CommonViewer viewer) {
        if (item == null) {
            return null;
        }
        TreeItem[] treeItems = item.getItems();
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getData().equals(obj)) {
                viewer.expandToLevel(treeItems[i].getData(), 1);
                return treeItems[i];
            }
            ++i;
        }
        return null;
    }
}

