/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.launching;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IEvent;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterWrapper;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.EventParameter;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.EventParameterTableDialog;
import org.eclipse.datatools.sqltools.routineeditor.parameter.internal.ParameterTableDialog;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditorUIActivator;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.Messages;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class LaunchUI {
    public static List configParameter(Shell shell, ParameterDescriptor[] pds, List valueList, boolean always, ILaunchConfiguration configuration) {
        if (!(pds != null && pds.length != 0 || always)) {
            valueList.clear();
            return valueList;
        }
        ParameterWrapper[] wrappers = LaunchUI.getParameterWrapper(pds, valueList);
        ParameterTableDialog dialog = null;
        try {
            DatabaseIdentifier dbid = LaunchHelper.readDatabaseIdentifier((ILaunchConfiguration)configuration);
            SQLDevToolsUIConfiguration conf = SQLToolsUIFacade.getConfiguration((DatabaseIdentifier)dbid, null);
            dialog = conf.getUIComponentService().getParameterTableDialog(shell, wrappers, configuration);
        }
        catch (CoreException e) {
            RoutineEditorUIActivator.getDefault().log(e);
        }
        if (dialog == null) {
            dialog = new ParameterTableDialog(shell, wrappers);
        }
        if (dialog.open() == 0) {
            valueList.clear();
            int i = 0;
            while (i < wrappers.length) {
                if (wrappers[i].isNull()) {
                    valueList.add(null);
                } else {
                    valueList.add(wrappers[i].getValue());
                }
                ++i;
            }
            return valueList;
        }
        return null;
    }

    public static ParameterWrapper[] getParameterWrapper(ParameterDescriptor[] pds, List valueList) {
        ParameterWrapper[] wrappers = new ParameterWrapper[pds.length];
        int i = 0;
        while (i < pds.length) {
            wrappers[i] = new ParameterWrapper(pds[i]);
            if (valueList.size() > i && valueList.get(i) != null) {
                wrappers[i].setNull(false);
                wrappers[i].setValue((String)valueList.get(i));
            } else {
                String defaultValue = wrappers[i].getParameterDescriptor().getDefaultValue();
                if (defaultValue != null) {
                    wrappers[i].setNull(false);
                    wrappers[i].setValue(defaultValue);
                } else {
                    wrappers[i].setNull(true);
                }
            }
            ++i;
        }
        return wrappers;
    }

    public static boolean configEventParameters(Shell shell, String[] pNames, Map eventTriggerParams, ProcIdentifier proc) {
        int i = 0;
        while (i < pNames.length) {
            if (!eventTriggerParams.containsKey(pNames[i])) {
                eventTriggerParams.put(pNames[i], "");
            }
            ++i;
        }
        EventParameter[] eps = new EventParameter[eventTriggerParams.size()];
        int mapsize = eventTriggerParams.size();
        Iterator keyValuePairs1 = eventTriggerParams.entrySet().iterator();
        int i2 = 0;
        while (i2 < mapsize) {
            Map.Entry entry = keyValuePairs1.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (eps[i2] == null) {
                eps[i2] = new EventParameter();
            }
            if (key != null) {
                eps[i2].setName((String)key);
            }
            if (value != null) {
                eps[i2].setValue((String)value);
            }
            ++i2;
        }
        if (eps.length >= 0) {
            IControlConnection con;
            try {
                con = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(proc.getDatabaseIdentifier());
            }
            catch (Exception e) {
                RoutineEditorUIActivator.getDefault().log(e);
                return false;
            }
            EventParameterTableDialog dlg = new EventParameterTableDialog(shell, eps, (IEvent)con.getDBItem(proc));
            if (dlg.open() == 0) {
                eps = dlg.getEventParameter();
                eventTriggerParams.clear();
                int i3 = 0;
                while (i3 < eps.length) {
                    if (eps[i3].getValue() != null && !"".equals(eps[i3].getValue()) && !"''".equals(eps[i3].getValue())) {
                        String name = eps[i3].getName();
                        String value = eps[i3].getValue();
                        eventTriggerParams.put(name, value);
                    }
                    ++i3;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static ProcIdentifier getActiveProcIdentifier() {
        Object obj;
        IStructuredSelection ss;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof ProcIdentifier) {
            return (ProcIdentifier)obj;
        }
        IEditorPart part = page.getActiveEditor();
        if (part != null) {
            IEditorInput input = part.getEditorInput();
            return (ProcIdentifier)input.getAdapter(ProcIdentifier.class);
        }
        return null;
    }

    public static ProcIdentifier selectDatabaseObject(Shell shell, DatabaseIdentifier databaseIdentifier, int type, ProcIdentifier old) throws SQLException, NoSuchProfileException {
        IControlConnection controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(databaseIdentifier);
        ProcIdentifier[] procids = controlCon.getAllProcs();
        ArrayList<ProcIdentifier> resultlist = new ArrayList<ProcIdentifier>();
        int i = 0;
        while (i < procids.length) {
            if (type == procids[i].getType()) {
                resultlist.add(procids[i]);
            }
            ++i;
        }
        Collections.sort(resultlist, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((ProcIdentifier)o1).getLongDisplayString().compareToIgnoreCase(((ProcIdentifier)o2).getLongDisplayString());
            }
        });
        procids = resultlist.toArray(new ProcIdentifier[resultlist.size()]);
        ListDialog dialog = new ListDialog(shell);
        switch (type) {
            case 0: {
                dialog.setTitle(Messages.LaunchUI_selectSP);
                dialog.setMessage(Messages.LaunchUI_selectSPMessage);
                break;
            }
            case 1: {
                dialog.setTitle(Messages.LaunchUI_selectUDF);
                dialog.setMessage(Messages.LaunchUI_selectUDFMessage);
                break;
            }
            case 2: {
                dialog.setTitle(Messages.LaunchUI_selectEVENT);
                dialog.setMessage(Messages.LaunchUI_selectEVENTMessage);
                break;
            }
            case 3: {
                dialog.setTitle(Messages.LaunchUI_selectTRIGGER);
                dialog.setMessage(Messages.LaunchUI_selectTRIGGERMessage);
            }
        }
        dialog.setInput((Object)procids);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ProcIdentifier)element).getLongDisplayString();
            }
        });
        if (old != null) {
            dialog.setInitialSelections(new Object[]{old});
        }
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null || result.length == 0) {
                return null;
            }
            return (ProcIdentifier)result[0];
        }
        return null;
    }
}

