/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.AbstractSqlDataValidator;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.utils.SQLUtil;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.sql.reference.DBObject;
import org.eclipse.datatools.sqltools.sql.reference.IDatatype;
import org.eclipse.datatools.sqltools.sql.util.HexHelper;
import org.eclipse.osgi.util.NLS;

public class ASADataValidator
extends AbstractSqlDataValidator {
    private static ILog _log = ExamplePlugin.getDefault().getLog();
    private static final String[] _basetypes1 = new String[]{"BIGINT", "BIT", "DATE", "DEC", "DOUBLE", "FLOAT", "INTEGER", "INT", "LONG VARCHAR", "LONG BINARY", "REAL", "SMALLINT", "TIME", "TIMESTAMP", "TINYINT", "UNSIGNED BIGINT", "UNSIGNED INT", "UNSIGNED SMALLINT"};
    private static final String[] _basetypes2 = new String[]{"BINARY", "CHAR", "CHARACTER", "DECIMAL", "NUMERIC", "VARBINARY", "VARCHAR"};

    public static boolean isTypeWithoutWS(String typeName) {
        int i = 0;
        while (i < _basetypes1.length) {
            if (_basetypes1[i].equalsIgnoreCase(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isTypeWithWS(String typeName) {
        int i = 0;
        while (i < _basetypes2.length) {
            if (_basetypes2[i].equalsIgnoreCase(typeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ASADataValidator(DatabaseIdentifier databaseIdentifier) {
        super(databaseIdentifier);
        this._status = 0;
    }

    public int validate(String dataType, String inputValue) {
        if (inputValue == null) {
            this._status = 0;
            this._errorMessage = null;
            return this._status;
        }
        IControlConnection controlCon = null;
        IDatatype currentType = null;
        try {
            controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(this._databaseIdentifier);
            currentType = controlCon.getTypeByNameStr(dataType);
        }
        catch (SQLException e) {
            this._status = 3;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
            return this._status;
        }
        catch (NoSuchProfileException e) {
            this._status = 3;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
            return this._status;
        }
        catch (Exception e) {
            this._status = 3;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
            _log.log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", e.getMessage()));
            return this._status;
        }
        if (currentType != null) {
            String unquote;
            if (SQLUtil.isStringType(dataType) && !inputValue.equals(unquote = SQLUtil.unquote(inputValue))) {
                inputValue = unquote;
            }
            return this.validate(currentType, inputValue);
        }
        this._status = 3;
        this._errorMessage = NLS.bind((String)Messages.DataValidation_createDataTypeError, (Object)dataType);
        this._convertedValue = inputValue;
        return this._status;
    }

    public int validate(IDatatype dataType, String inputValue) {
        if (inputValue == null) {
            this._status = 0;
            this._errorMessage = null;
            return this._status;
        }
        Object o = null;
        try {
            String conValue = inputValue;
            o = this.convert(dataType.toString(), inputValue, this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
            if (o == null) {
                conValue = null;
            } else if (o instanceof byte[]) {
                byte[] os = (byte[])o;
                conValue = HexHelper.toHexString((byte[])os);
            } else {
                conValue = o instanceof Boolean ? ((o = (Boolean)o).toString() == "false" ? "0" : "1") : o.toString();
            }
            String typeName = null;
            typeName = dataType.isUDT() ? ((DBObject)dataType.getBaseType()).getName() : ((DBObject)dataType).getName();
            if (typeName.equalsIgnoreCase("date") && conValue.indexOf(32) > 0) {
                conValue = conValue.substring(0, conValue.indexOf(32));
            }
            if (typeName.equalsIgnoreCase("time") && conValue.indexOf(32) > 0 && conValue.lastIndexOf(46) > 0) {
                conValue = conValue.substring(conValue.indexOf(32) + 1, conValue.lastIndexOf(46));
            }
            this._convertedValue = conValue;
            if (this.needSupportExpression) {
                this._convertedValue = inputValue.indexOf(conValue) > 0 ? conValue : (o instanceof byte[] || o instanceof Boolean ? conValue : inputValue);
            }
            if (inputValue == null) {
                if (this._convertedValue == null) {
                    this._status = 0;
                    this._errorMessage = null;
                    return this._status;
                }
                this._status = 1;
                this._errorMessage = Messages.DataValidation_warnMessage;
                return this._status;
            }
            if (inputValue.equalsIgnoreCase(this._convertedValue)) {
                this._status = 0;
                this._errorMessage = null;
                return this._status;
            }
            this._status = 1;
            this._errorMessage = Messages.DataValidation_warnMessage;
            return this._status;
        }
        catch (SQLException e) {
            this._status = 2;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
        }
        catch (NoSuchProfileException e) {
            this._status = 3;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
        }
        catch (Exception e) {
            this._status = 2;
            this._errorMessage = e.getMessage();
            this._convertedValue = inputValue;
        }
        return this._status;
    }

    public static boolean needQuote(String dataType) {
        if (dataType == null) {
            return false;
        }
        return (dataType = dataType.toLowerCase()).equals("char") || dataType.equals("character") || dataType.equals("long varchar") || dataType.equals("varchar") || dataType.equals("character varying");
    }

    public Object convert(String dataType, String inputValue, String profileName, String dbName) throws Exception {
        Object o;
        block29: {
            ResultSet rs;
            Statement stmt;
            block27: {
                block28: {
                    String inputValueUnquote = null;
                    DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
                    o = null;
                    String typeName = null;
                    int p1 = dataType.indexOf("(");
                    typeName = p1 > 0 ? dataType.substring(0, p1) : dataType;
                    if (inputValue != null) {
                        inputValueUnquote = SQLUtil.unquote(inputValue);
                        if (ASADataValidator.needQuote(typeName)) {
                            inputValue = SQLUtil.quote(inputValue, "'");
                        }
                        inputValue = SQLUtil.getQuotedString(dataType, inputValue, databaseIdentifier);
                    }
                    String strType = "";
                    strType = dataType.toString();
                    stmt = null;
                    rs = null;
                    Connection cn = null;
                    try {
                        try {
                            cn = SQLUtil.getConnection(databaseIdentifier);
                            stmt = cn.createStatement();
                            String sql = this.createQuerySQL(dataType, inputValue, strType, true);
                            rs = stmt.executeQuery(sql);
                            while (rs.next()) {
                                o = rs.getObject(1);
                            }
                            break block27;
                        }
                        catch (Exception e) {
                            try {
                                stmt = cn.createStatement();
                                String sql = this.createQuerySQL(dataType, inputValueUnquote, strType, false);
                                rs = stmt.executeQuery(sql);
                                while (rs.next()) {
                                    o = rs.getObject(1);
                                }
                            }
                            catch (Exception exception) {
                                throw e;
                            }
                        }
                        if (rs == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Exception exception) {
                                _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                            }
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception exception) {
                                _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {
                        _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {
                        _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                    }
                }
                break block29;
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {
                    _log.log((IStatus)new Status(2, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.common_ignoreException));
                }
            }
        }
        return o;
    }

    private String createQuerySQL(String dataType, String inputValue, String strType, boolean needQuoted) {
        StringBuffer query = new StringBuffer();
        if (inputValue == null || inputValue.startsWith("0x") || SQLUtil.isStringType(dataType)) {
            query.append("select convert(").append(strType).append(",").append(inputValue).append(")");
        } else if (needQuoted) {
            query.append("select convert(").append(strType).append(",'").append(inputValue).append("')");
        } else {
            query.append("select convert(").append(strType).append(",").append(inputValue).append(")");
        }
        return query.toString();
    }
}

