/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.source;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.Messages;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilderWrapper;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseParameter;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseRoutine;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementDefault;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatementsFactory;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DataTypeProvider;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.ui.RoutineEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.model.ISchemaObjectEditModel;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.NestedEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.sql.parser.ParserParameters;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sql.parser.SQLParser;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTTrigger;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.util.ModelUtil;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SourcePage
extends NestedEditorPage
implements ISchemaObjectEditorPage {
    public static final String PAGE_ID = "org.eclipse.datatools.sqltools.schemaobjecteditor.routineSourcePage";
    protected RoutineEditor _routineEditor = null;
    protected ProcEditorInput _input = null;
    protected boolean _sourceChanged = false;
    protected boolean _dirty = false;
    protected SQLObject _mainObject;
    protected List _schemas;
    protected ISchemaObjectEditModel _editModelObject;
    private IDocumentListener _docListener;

    public SourcePage() {
        this(PAGE_ID, Messages.SourcePage_page_name);
    }

    public SourcePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public SourcePage(String id, String title) {
        super(id, title);
    }

    public IEditorPart getNestedEditor() {
        if (this._routineEditor == null) {
            this._routineEditor = new RoutineEditor();
            this._routineEditor.setParentEditor((IEditorPart)this.getEditor());
        }
        return this._routineEditor;
    }

    public IEditorInput getNestedEditorInput() {
        if (this._input != null) {
            return this._input;
        }
        ProcIdentifier proc = this.getProcIdentifier();
        if (proc != null) {
            this._input = new ProcEditorInput(proc);
            return this._input;
        }
        return null;
    }

    protected ProcIdentifier getProcIdentifier() {
        ISchemaObjectEditorInput parentInput;
        ProcIdentifier proc = null;
        FormEditor editor = this.getEditor();
        if (editor != null && editor instanceof ISchemaObjectEditor && (parentInput = (ISchemaObjectEditorInput)this.getEditor().getEditorInput()) != null) {
            this._mainObject = parentInput.getEditModelObject().getMainSQLObject();
            SQLObject oldMainObject = parentInput.getEditModelObject().getSchemaObjectImmutableModel().getMainSQLObject();
            Catalog catalog = ModelUtil.getCatalog((EObject)oldMainObject);
            Database db = (Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)oldMainObject);
            this._schemas = ModelUtil.getSchemas((Database)db, (String)(catalog == null ? null : catalog.getName()));
            this._editModelObject = ((SchemaObjectEditorInput)parentInput).getEditModelObject();
            if (this._mainObject instanceof SQLObject) {
                proc = SQLDevToolsUtil.getProcIdentifier((DatabaseIdentifier)parentInput.getDatabaseIdentifier(), (SQLObject)this._mainObject);
            }
        }
        return proc;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IDocument doc = this._routineEditor.getDocumentProvider().getDocument((Object)this._input);
        this._docListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                SourcePage.this._sourceChanged = true;
                SourcePage.this._dirty = true;
            }
        };
        doc.addDocumentListener(this._docListener);
        this._dirty = false;
    }

    public void dispose() {
        super.dispose();
    }

    public void setActive(boolean active) {
        if (active) {
            this._sourceChanged = false;
            String body = this.getBody();
            if (this._routineEditor != null) {
                IDocument doc = this._routineEditor.getDocumentProvider().getDocument((Object)this._input);
                if (this.getEditor().isDirty()) {
                    doc.set(body);
                }
                doc.addDocumentListener(this._docListener);
            }
        } else if (this._routineEditor != null) {
            IDocument doc = this._routineEditor.getDocumentProvider().getDocument((Object)this._input);
            doc.removeDocumentListener(this._docListener);
        }
    }

    protected SchemaObjectEditorPage.PageForm createManagedForm(ScrolledForm form) {
        return new SourcePageForm((SchemaObjectEditorPage)this, form);
    }

    public void aboutToLeave() {
    }

    public boolean canLeaveThePage() {
        if (this._routineEditor != null) {
            this._errorMsg = this.validateSource(true);
        }
        if (this._errorMsg != null) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.SourcePage_error, (String)this._errorMsg);
            return false;
        }
        return true;
    }

    protected String getBody() {
        if (this._mainObject instanceof Routine) {
            return ((Routine)this._mainObject).getSource().getBody();
        }
        if (this._mainObject instanceof Trigger && this._routineEditor != null) {
            return SybaseDdlBuilderWrapper.getInstance().getTriggerBody((Trigger)this._mainObject);
        }
        return "";
    }

    protected void setBody(IDocument doc) {
        if (this._mainObject instanceof Routine) {
            ((Routine)this._mainObject).getSource().setBody(doc.get());
        } else if (this._mainObject instanceof Trigger) {
            ((Trigger)this._mainObject).getActionStatement().clear();
            SQLStatementDefault stmt = SQLStatementsFactory.eINSTANCE.createSQLStatementDefault();
            stmt.setSQL(doc.get());
            ((Trigger)this._mainObject).getActionStatement().add((Object)stmt);
        }
    }

    private String validateSource(boolean headerMode) {
        boolean validationOn = SQLEditorPlugin.getDefault().getPreferenceStore().getBoolean("syntax.validation");
        ParsingResult result = null;
        this._errorMsg = null;
        if (this._sourceChanged) {
            this._sourceChanged = false;
            IDocument doc = this._routineEditor.getDocumentProvider().getDocument((Object)this._input);
            this.setBody(doc);
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)this._routineEditor.getConnectionInfo().getDatabaseVendorDefinitionId());
            SQLParser p = f.getSQLService().getSQLParser();
            ParserParameters parserParameters = new ParserParameters(false, this._routineEditor.getSQLType());
            parserParameters.setProperty((Object)"__header_mode", (Object)Boolean.TRUE);
            result = p.parse(doc.get(), parserParameters);
            result.getRootNode().setDocument(doc);
            this._errorMsg = !result.getExceptions().isEmpty() ? Messages.SourcePage_syntax_error : this.reInitSQLObject(result, this._mainObject);
        }
        if (this._errorMsg == null && validationOn && !headerMode && (result = this._routineEditor.getParsingResult()) != null && !result.getExceptions().isEmpty()) {
            this._errorMsg = Messages.SourcePage_syntax_error;
        }
        return this._errorMsg;
    }

    protected String reInitSQLObject(ParsingResult result, Object object) {
        IASTStart root = result.getRootNode();
        if (root == null || root.jjtGetNumChildren() != 1) {
            return Messages.SourcePage_invalid_content;
        }
        int i = 0;
        while (i < root.jjtGetNumChildren()) {
            String msg;
            Node node = root.jjtGetChild(i);
            if (node instanceof IASTDeployable && object instanceof SybaseRoutine) {
                SybaseRoutine proc = (SybaseRoutine)object;
                IASTDeployable astProc = (IASTDeployable)node;
                msg = this.reInitRoutine(proc, astProc);
                if (msg != null) {
                    return msg;
                }
            } else if (node instanceof IASTTrigger && object instanceof Trigger) {
                Trigger trigger = (Trigger)object;
                IASTTrigger astTrigger = (IASTTrigger)node;
                msg = this.reInitTrigger(trigger, astTrigger);
                if (msg != null) {
                    return msg;
                }
            } else if (node instanceof IASTDeployable && object instanceof Event) {
                Event event = (Event)object;
                String msg2 = this.reInitEvent(event, (IASTDeployable)node);
                if (msg2 != null) {
                    return msg2;
                }
            } else {
                return Messages.SourcePage_invalid_content;
            }
            ++i;
        }
        return null;
    }

    protected String setName(SQLObject object, Schema schema, IASTDeployable deployable) {
        String[] name = SQLUtil.parseDatabaseObject((String)deployable.getDBObjectName());
        if (name == null || name.length == 0) {
            return Messages.SourcePage_no_name;
        }
        object.setName(name[0]);
        if (name.length > 1 && (name[1] == null || schema != null && !name[1].equalsIgnoreCase(schema.getName()))) {
            return Messages.SourcePage_owner_changed;
        }
        return null;
    }

    protected String reInitEvent(Event event, IASTDeployable node) {
        String msg = this.setName((SQLObject)event, null, node);
        if (msg != null) {
            return msg;
        }
        return null;
    }

    protected String reInitTrigger(Trigger trigger, IASTTrigger astTrigger) {
        Trigger oldTrigger = (Trigger)this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject();
        Schema schema = oldTrigger.getSchema();
        String msg = this.setName((SQLObject)trigger, schema, (IASTDeployable)astTrigger);
        if (msg != null) {
            return msg;
        }
        trigger.setInsertType(astTrigger.isInsertType());
        trigger.setUpdateType(astTrigger.isUpdateType());
        trigger.setDeleteType(astTrigger.isDeleteType());
        return null;
    }

    protected String reInitRoutine(SybaseRoutine proc, IASTDeployable astProc) {
        Routine oldRoutine = (Routine)this._editModelObject.getSchemaObjectImmutableModel().getMainSQLObject();
        Schema schema = oldRoutine.getSchema();
        String msg = this.setName((SQLObject)proc, schema, astProc);
        if (msg != null) {
            return msg;
        }
        this.reInitParameters(proc, astProc, schema);
        return null;
    }

    protected void reInitParameters(SybaseRoutine proc, IASTDeployable astProc, Schema schema) {
        EList parameters = proc.getParameters();
        parameters.clear();
        int j = 0;
        while (j < astProc.jjtGetNumChildren()) {
            Node astParamList = astProc.jjtGetChild(j);
            if (astParamList instanceof IASTSQLParamDefList) {
                DatabaseDefinition dbdef = null;
                EObject database = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)schema);
                if (database instanceof Database) {
                    dbdef = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)database);
                }
                int k = 0;
                while (k < astParamList.jjtGetNumChildren()) {
                    Node child = astParamList.jjtGetChild(k);
                    if (child instanceof IASTSQLParam) {
                        ParameterMode mode;
                        IASTSQLParam astParam = (IASTSQLParam)child;
                        SybaseParameter param = SybasesqlmodelFactory.eINSTANCE.createSybaseParameter();
                        param.setName(astParam.getName());
                        if (dbdef != null) {
                            DataTypeProvider provider = SQLToolsFacade.getConfigurationByVendorIdentifier((DatabaseVendorDefinitionId)new DatabaseVendorDefinitionId(dbdef.getProduct(), dbdef.getVersion())).getSQLDataService().getDataTypeProvider();
                            DataType newType = provider.getDataType(SQLUtil.unquote((String)astParam.getType()), (Schema)this._schemas.get(0), this._routineEditor.getDatabaseIdentifier());
                            param.setDataType(newType);
                        }
                        if ((mode = ParameterMode.get((int)astParam.getDirection())).getValue() == 1) {
                            mode = ParameterMode.INOUT_LITERAL;
                        }
                        param.setMode(mode);
                        param.setDefaultValue(astParam.getDefaultValue());
                        parameters.add((Object)param);
                    }
                    ++k;
                }
            }
            ++j;
        }
    }

    public boolean aboutToSave(IProgressMonitor monitor) {
        String msg;
        if (this._dirty && (msg = this.validateSource(false)) != null) {
            boolean goon = MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Messages.SourcePage_warning, (String)NLS.bind((String)Messages.SourcePage_warning_msg, (Object)msg));
            return goon;
        }
        return true;
    }

    public void refresh() {
        super.refresh();
        this._input = null;
        this._mainObject = null;
        this._editModelObject = null;
        this._schemas = null;
        this._routineEditor.setInput(this.getNestedEditorInput());
        IDocument doc = this._routineEditor.getDocumentProvider().getDocument((Object)this._input);
        doc.addDocumentListener(this._docListener);
        this._dirty = false;
        this._sourceChanged = false;
        ((ISchemaObjectEditor)this.getEditor()).clearDirty();
    }

    protected class SourcePageForm
    extends SchemaObjectEditorPage.PageForm {
        public SourcePageForm(SchemaObjectEditorPage page, ScrolledForm form) {
            super(page, form);
        }

        public void commit(boolean onSave) {
            super.commit(onSave);
            SourcePage.this.canLeaveThePage();
        }
    }
}

