/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.helper;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDriver;
import org.eclipse.datatools.connectivity.oda.LogConfiguration;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.DriverExtensionHelper;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaConnection;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaHelperException;
import org.eclipse.datatools.connectivity.oda.consumer.helper.OdaObject;
import org.eclipse.datatools.connectivity.oda.consumer.internal.impl.LogConfigHelper;
import org.eclipse.datatools.connectivity.oda.consumer.internal.impl.LogPathHelper;
import org.eclipse.datatools.connectivity.oda.consumer.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.util.logging.LogManager;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

public class OdaDriver
extends OdaObject
implements IDriver {
    public static final String ODA_BRIDGED_DRIVER = "BridgedDriverInstance";
    private String m_logDirectory;
    private Object m_appContext;
    private Object m_initAppContext;

    public OdaDriver(String odaDataSourceId) throws OdaException {
        ExtensionManifest odaDataSourceManifest = null;
        try {
            odaDataSourceManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        }
        catch (IllegalArgumentException ex) {
            OdaException odaEx = new OdaException((Throwable)ex);
            this.handleError(odaEx);
        }
        this.init(odaDataSourceManifest);
    }

    public OdaDriver(ExtensionManifest driverConfig) throws OdaException {
        this.init(driverConfig);
    }

    public OdaDriver(ExtensionManifest driverConfig, Object appContext) throws OdaException {
        this.m_initAppContext = appContext;
        this.init(driverConfig);
        this.m_initAppContext = null;
    }

    public OdaDriver(String driverClassName, Locale locale, ClassLoader driverClassloader, boolean switchContextClassloader) throws OdaException {
        super(switchContextClassloader, driverClassloader);
        String context = "OdaDriver.OdaDriver( " + driverClassName + ", " + locale + ", " + driverClassloader + " )\t";
        this.logMethodCalled(context);
        try {
            try {
                if (switchContextClassloader) {
                    this.setContextClassloader();
                }
                Class<?> driverClass = driverClassloader == null ? Class.forName(driverClassName) : driverClassloader.loadClass(driverClassName);
                IDriver newDriver = this.newDriverInstance(driverClass, null, false);
                this.setObject(newDriver);
                this.logMethodExitWithReturn(context, this);
            }
            catch (Exception ex) {
                OdaHelperException odaEx = new OdaHelperException(Messages.helper_cannotConstructConnectionFactory, String.valueOf(driverClassName) + ", " + driverClassloader);
                odaEx.initCause(ex);
                this.handleError(odaEx);
                if (switchContextClassloader) {
                    this.resetContextClassloader();
                }
            }
        }
        finally {
            if (switchContextClassloader) {
                this.resetContextClassloader();
            }
        }
    }

    private void init(ExtensionManifest driverConfig) throws OdaException {
        if (driverConfig == null) {
            throw new OdaException(Messages.helper_missingDriverInfo);
        }
        String context = "OdaDriver.init( " + driverConfig + " )\t";
        this.logMethodCalled(context);
        IDriver wrappedDriver = this.loadDriverInstance(driverConfig, true, true);
        this.setObject(wrappedDriver);
        this.setLogConfiguration(driverConfig);
        this.logMethodExitWithReturn(context, this);
    }

    private IDriver loadDriverInstance(ExtensionManifest driverConfig, boolean honorClassLoaderSwitch, boolean appliesBridgeExtension) throws OdaException {
        JavaRuntimeInterface javaRuntime = DriverExtensionHelper.getRuntimeInterface(driverConfig);
        IDriver loadedDriver = null;
        try {
            try {
                Class driverClass = DriverExtensionHelper.loadDriverClass(driverConfig);
                if (Platform.getBundle((String)driverConfig.getNamespace()) == null) {
                    javaRuntime.setLoadedClassLocation(driverClass, this.m_initAppContext);
                }
                if (honorClassLoaderSwitch) {
                    boolean needSwitch = javaRuntime.needSetThreadContextClassLoader();
                    this.setUseContextClassLoaderSwitch(needSwitch);
                    if (needSwitch) {
                        this.setDriverClassLoader(driverClass.getClassLoader());
                        this.setContextClassloader();
                    }
                }
                loadedDriver = this.newDriverInstance(driverClass, driverConfig.getDataSourceElementID(), appliesBridgeExtension);
            }
            catch (Exception ex) {
                OdaHelperException odaEx = new OdaHelperException(Messages.helper_cannotConstructConnectionFactory, javaRuntime.getDriverClass());
                odaEx.initCause(ex);
                this.handleError(odaEx);
                if (honorClassLoaderSwitch) {
                    this.resetContextClassloader();
                }
            }
        }
        finally {
            if (honorClassLoaderSwitch) {
                this.resetContextClassloader();
            }
        }
        return loadedDriver;
    }

    private IDriver newDriverInstance(Class driverClass, String driverDataSourceId, boolean appliesBridgeExtension) throws InstantiationException, IllegalAccessException {
        IDriver driverBridge;
        Object driverInstance = driverClass.newInstance();
        if (appliesBridgeExtension && (driverBridge = this.newDriverBridge(driverInstance, driverDataSourceId)) != null) {
            return driverBridge;
        }
        if (driverInstance instanceof IDriver) {
            return (IDriver)driverInstance;
        }
        throw new IllegalArgumentException(driverInstance.toString());
    }

    protected IDriver newDriverBridge(Object driver) {
        return this.newDriverBridge(driver, null);
    }

    protected IDriver newDriverBridge(Object driverInstance, String driverDataSourceId) {
        assert (driverInstance != null);
        if (driverDataSourceId == null) {
            return null;
        }
        String driverBridgeId = this.getDriverBridgeId(driverInstance);
        if (driverBridgeId == null || driverBridgeId.equalsIgnoreCase(driverDataSourceId)) {
            return null;
        }
        return this.newDriverBridgeExtension(driverInstance, driverBridgeId);
    }

    private String getDriverBridgeId(Object driver) {
        return DriverExtensionHelper.getDriverBridgeId(driver.getClass());
    }

    private IDriver newDriverBridgeExtension(Object driver, String driverBridgeDataSourceId) {
        if (driverBridgeDataSourceId == null) {
            return null;
        }
        try {
            ExtensionManifest bridgeManifest = ManifestExplorer.getInstance().getExtensionManifest(driverBridgeDataSourceId);
            if (bridgeManifest != null) {
                IDriver driverBridge = this.loadDriverInstance(bridgeManifest, false, false);
                this.setDriverBridgeContext(driverBridge, driver);
                IDriver parentBridge = this.newDriverBridge(driverBridge, bridgeManifest.getDataSourceElementID());
                if (parentBridge != null) {
                    driverBridge = parentBridge;
                }
                return driverBridge;
            }
        }
        catch (OdaException e) {
            this.logWarning("OdaDriver.newDriverBridgeExtension", e.toString());
        }
        return null;
    }

    private void setDriverBridgeContext(IDriver driverBridge, Object driver) {
        if (driverBridge == null || driver == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(ODA_BRIDGED_DRIVER, driver);
        try {
            driverBridge.setAppContext(map);
        }
        catch (RuntimeException e) {
            this.logWarning("OdaDriver.setDriverBridgeContext", e.toString());
        }
        catch (OdaException ex) {
            this.logWarning("OdaDriver.setDriverBridgeContext", ex.toString());
        }
    }

    private IDriver getDriver() {
        return (IDriver)this.getObject();
    }

    private String getLoggerName() {
        return "org.eclipse.datatools.connectivity.oda.consumer";
    }

    public void setLogDirectory(String logDirectory) {
        this.m_logDirectory = logDirectory;
    }

    private void setLogConfiguration(ExtensionManifest driverManifest) throws OdaException {
        LogConfigHelper configHelper = new LogConfigHelper(driverManifest);
        this.setLogConfiguration(configHelper.getDriverLogConfiguration());
    }

    /*
     * Loose catch block
     */
    public void setLogConfiguration(LogConfiguration logConfig) throws OdaException {
        String context;
        block14: {
            context = "OdaDriver.setLogConfiguration( " + logConfig + " )\t";
            this.logMethodCalled(context);
            if (logConfig == null) {
                this.logMethodExit(context);
                return;
            }
            try {
                if (this.getLogger() == null && this.m_logDirectory == null) {
                    this.m_logDirectory = logConfig.getDataSourceId();
                }
                if (this.m_logDirectory != null && this.m_logDirectory.length() > 0) {
                    ResourceIdentifiers resourceIdentifiers = ResourceIdentifiers.get((Object)this.m_initAppContext);
                    this.m_logDirectory = LogPathHelper.getAbsoluteLogDirName(this.m_logDirectory, resourceIdentifiers);
                    this.setLogger(LogManager.getLogger((String)this.getLoggerName(), (int)logConfig.getLogLevel(), (String)this.m_logDirectory, (String)"OdaHelperLog", null));
                }
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
            try {
                this.setContextClassloader();
                this.getDriver().setLogConfiguration(logConfig);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IDriver.setLogConfiguration");
                this.resetContextClassloader();
                break block14;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block14;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block14;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.logMethodExit(context);
    }

    public IConnection getConnection(String dataSourceId) throws OdaException {
        String context = "OdaDriver.getConnection( " + dataSourceId + " )\t";
        this.logMethodCalled(context);
        try {
            this.setContextClassloader();
            IConnection connection = this.getDriver().getConnection(dataSourceId);
            IConnection ret = connection == null ? null : this.newConnectionHelper(connection);
            this.logMethodExitWithReturn(context, ret);
            IConnection iConnection = ret;
            return iConnection;
        }
        catch (UnsupportedOperationException uoException) {
            this.handleUnsupportedOp(uoException, "IDriver.getConnection( String dataSourceId )");
            return null;
        }
        catch (RuntimeException rtException) {
            this.handleError(rtException);
            return null;
        }
        catch (OdaException exception) {
            this.handleError(exception);
            return null;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    protected IConnection newConnectionHelper(IConnection connection) throws OdaException {
        int maxOpenConnections;
        OdaConnection connHelper = new OdaConnection(connection, this.switchContextClassloader(), this.getDriverClassLoader(), this.getOriginalContextClassLoader());
        connHelper.setDriverAppContext(this.m_appContext);
        try {
            maxOpenConnections = this.getMaxConnections();
        }
        catch (OdaException odaException) {
            maxOpenConnections = 0;
        }
        OdaConnection.setMaxConnections(maxOpenConnections);
        return connHelper;
    }

    public int getMaxConnections() throws OdaException {
        this.logMethodCalled("OdaDriver.getMaxConnections()\t");
        try {
            this.setContextClassloader();
            int ret = this.getDriver().getMaxConnections();
            this.logMethodExitWithReturn("OdaDriver.getMaxConnections()\t", ret);
            int n = ret;
            return n;
        }
        catch (UnsupportedOperationException uoException) {
            int n = this.handleUnsupportedOpAndRetZero(uoException, "IDriver.getMaxConnections()");
            return n;
        }
        catch (RuntimeException rtException) {
            int n = this.handleErrorAndReturnNegOne(rtException);
            return n;
        }
        catch (OdaException odaException) {
            int n = this.handleErrorAndReturnNegOne(odaException);
            return n;
        }
        finally {
            this.resetContextClassloader();
        }
    }

    /*
     * Loose catch block
     */
    public void setAppContext(Object context) throws OdaException {
        block10: {
            String contextObjInfo = context == null ? "null" : context.getClass().getName();
            this.logMethodCalled("OdaDriver.setAppContext()\t");
            if (this.m_appContext == context) {
                this.log("OdaDriver.setAppContext()\t", "Same pass-thru application context object: " + contextObjInfo);
                this.logMethodExit("OdaDriver.setAppContext()\t");
                return;
            }
            try {
                this.setContextClassloader();
                this.log("OdaDriver.setAppContext()\t", "Passing thru application context to underlying ODA driver: " + contextObjInfo);
                this.getDriver().setAppContext(context);
            }
            catch (UnsupportedOperationException uoException) {
                this.logUnsupportedOp(uoException, "IDriver.setAppContext");
                this.resetContextClassloader();
                break block10;
            }
            catch (RuntimeException rtException) {
                this.handleError(rtException);
                break block10;
            }
            catch (OdaException odaException) {
                this.handleError(odaException);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.resetContextClassloader();
                break block10;
            }
            {
                finally {
                    this.resetContextClassloader();
                }
            }
            this.resetContextClassloader();
        }
        this.m_appContext = context;
        this.logMethodExit("OdaDriver.setAppContext()\t");
    }
}

