/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.ConsoleStreamRegistry;
import org.eclipse.cft.server.ui.internal.console.StandardLogContentType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.MessageConsole;

public class CloudFoundryConsole {
    static final String ATTRIBUTE_SERVER = "org.eclipse.cft.server.Server";
    static final String ATTRIBUTE_APP = "org.eclipse.cft.server.CloudApp";
    static final String ATTRIBUTE_INSTANCE = "org.eclipse.cft.server.CloudInstance";
    static final String CONSOLE_TYPE = "org.eclipse.cft.server.appcloud";
    private Map<LogContentType, ConsoleStream> activeStreams = new HashMap<LogContentType, ConsoleStream>();
    private final ConsoleConfig config;

    public CloudFoundryConsole(ConsoleConfig config) {
        this.config = config;
    }

    public MessageConsole getConsole() {
        return this.config.getMessageConsole();
    }

    public synchronized void startTailing(LogContentType type) {
        try {
            this.getStream(type);
        }
        catch (CoreException ce) {
            CloudFoundryPlugin.logError((Throwable)ce);
        }
    }

    protected synchronized ConsoleStream getStream(LogContentType type) throws CoreException {
        if (type == null) {
            return null;
        }
        ConsoleStream stream = this.activeStreams.get(type);
        if (stream == null) {
            stream = ConsoleStreamRegistry.getInstance().getStream(type);
            if (stream == null) {
                throw CloudErrorUtil.toCoreException((String)NLS.bind((String)Messages.ERROR_NO_CONSOLE_STREAM_FOUND, (Object)type));
            }
            stream.initialiseStream(this.config);
            this.activeStreams.put(type, stream);
        }
        return stream;
    }

    public synchronized void stop() {
        for (Map.Entry<LogContentType, ConsoleStream> entry : this.activeStreams.entrySet()) {
            entry.getValue().close();
        }
        this.activeStreams.clear();
    }

    public void writeToStdError(String message) {
        this.writeToStream(message, StandardLogContentType.STD_ERROR);
    }

    public void writeToStdOut(String message) {
        this.writeToStream(message, StandardLogContentType.STD_OUT);
    }

    protected synchronized void writeToStream(String message, LogContentType type) {
        if (message != null) {
            this.writeToStream(new CloudLog(message, type));
        }
    }

    public synchronized void writeToStream(CloudLog log) {
        if (log == null) {
            return;
        }
        try {
            ConsoleStream stream = this.getStream(log.getLogType());
            stream.write(log);
        }
        catch (CoreException e) {
            CloudFoundryPlugin.logError((Throwable)e);
        }
    }
}

