/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.project;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.QtNature;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tools.templates.freemarker.FMProjectGenerator;
import org.eclipse.tools.templates.freemarker.SourceRoot;
import org.osgi.framework.Bundle;

public class QtProjectGenerator
extends FMProjectGenerator {
    public QtProjectGenerator(String manifestPath) {
        super(manifestPath);
    }

    protected void initProjectDescription(IProjectDescription description) {
        description.setNatureIds(new String[]{"org.eclipse.cdt.core.cnature", "org.eclipse.cdt.core.ccnature", "org.eclipse.cdt.qt.core.qtNature"});
        QtNature.setupBuilder(description);
    }

    public Bundle getSourceBundle() {
        return Activator.getDefault().getBundle();
    }

    public void generate(Map<String, Object> model, IProgressMonitor monitor) throws CoreException {
        super.generate(model, monitor);
        IProject project = this.getProject();
        ArrayList<Object> entries = new ArrayList<Object>();
        List srcRoots = this.getManifest().getSrcRoots();
        if (srcRoots != null && !srcRoots.isEmpty()) {
            for (SourceRoot srcRoot : srcRoots) {
                IFolder sourceFolder = project.getFolder(srcRoot.getDir());
                if (!sourceFolder.exists()) {
                    sourceFolder.create(true, true, monitor);
                }
                entries.add(CoreModel.newSourceEntry((IPath)sourceFolder.getFullPath()));
            }
        } else {
            entries.add(CoreModel.newSourceEntry((IPath)this.getProject().getFullPath()));
        }
        entries.add(CoreModel.newOutputEntry((IPath)this.getProject().getFolder("build").getFullPath()));
        CoreModel.getDefault().create(project).setRawPathEntries(entries.toArray(new IPathEntry[entries.size()]), monitor);
    }
}

