/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.launch;

import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.StandardProcessVMNode;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.jface.viewers.TreePath;

public class GdbStandardProcessVMNode
extends StandardProcessVMNode {
    public GdbStandardProcessVMNode(AbstractVMProvider provider) {
        super(provider);
    }

    public String toString() {
        return "GdbStandardProcessVMNode";
    }

    public void update(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.done();
            } else {
                int count = 0;
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (!(process instanceof InferiorRuntimeProcess)) {
                        update.setChild((Object)process, count++);
                    }
                    ++n4;
                }
                update.done();
            }
            ++n2;
        }
    }

    public void update(IChildrenCountUpdate[] updates) {
        IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
            if (this.checkUpdate((IViewerUpdate)update)) {
                ILaunch launch = this.findLaunch(update.getElementPath());
                if (launch == null) {
                    assert (false);
                    update.setChildCount(0);
                    update.done();
                    return;
                }
                int count = 0;
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (!(process instanceof InferiorRuntimeProcess)) {
                        ++count;
                    }
                    ++n4;
                }
                update.setChildCount(count);
                update.done();
            }
            ++n2;
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
            ILaunch launch = this.findLaunch(update.getElementPath());
            if (launch == null) {
                assert (false);
                update.setHasChilren(false);
                update.done();
                return;
            }
            boolean hasChildren = false;
            IProcess[] iProcessArray = launch.getProcesses();
            int n3 = iProcessArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IProcess process = iProcessArray[n4];
                if (!(process instanceof InferiorRuntimeProcess)) {
                    hasChildren = true;
                    break;
                }
                ++n4;
            }
            update.setHasChilren(hasChildren);
            update.done();
            ++n2;
        }
    }

    private ILaunch findLaunch(TreePath path) {
        int i = path.getSegmentCount() - 1;
        while (i >= 0) {
            if (path.getSegment(i) instanceof ILaunch) {
                return (ILaunch)path.getSegment(i);
            }
            --i;
        }
        return null;
    }

    public int getDeltaFlags(Object e) {
        DebugEvent de;
        int myFlags = 0;
        if (e instanceof DebugEvent && !((de = (DebugEvent)e).getSource() instanceof InferiorRuntimeProcess) && (de.getKind() == 16 || de.getKind() == 4 || de.getKind() == 8)) {
            myFlags = 2048;
        }
        return myFlags;
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (e instanceof DebugEvent && !(((DebugEvent)e).getSource() instanceof InferiorRuntimeProcess)) {
            DebugEvent de = (DebugEvent)e;
            if (de.getKind() == 16) {
                this.handleChange(de, (ModelDelta)parent);
            } else if (de.getKind() == 4) {
                this.handleCreate(de, (ModelDelta)parent);
            } else if (de.getKind() == 8) {
                this.handleTerminate(de, (ModelDelta)parent);
            }
        }
        requestMonitor.done();
    }
}

