/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.osview;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.osview.OSData;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.mi.service.IMIRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class SessionOSData {
    private DsfSession fSession;
    private DsfServicesTracker fTracker;
    private IGDBHardwareAndOS2 fHardwareOs;
    private ICommandControlService.ICommandControlDMContext fContext;
    private IGDBHardwareAndOS2.IResourceClass[] fResourceClasses = new IGDBHardwareAndOS2.IResourceClass[0];
    private Map<String, OSData> fExistingData = new HashMap<String, OSData>();
    private Map<String, Date> fTimestamp = new HashMap<String, Date>();
    private Listener fUIListener;
    private Control fUIControl;
    private boolean fWaitingForSession = true;
    private boolean fSupported = true;
    private boolean fAcceptingCommands = false;
    private boolean fFetchingClasses = false;
    private boolean fFetchingContent = false;

    public SessionOSData(DsfSession session, ICommandControlService.ICommandControlDMContext executionContext) {
        this.fSession = session;
        BundleContext c = GdbUIPlugin.getDefault().getBundle().getBundleContext();
        this.fTracker = new DsfServicesTracker(c, this.fSession.getId());
        this.fContext = executionContext;
        DsfExecutor executor = this.fSession.getExecutor();
        executor.submit((Runnable)new DsfRunnable(){

            public void run() {
                IMIRunControl runControl = (IMIRunControl)SessionOSData.this.fTracker.getService(IMIRunControl.class);
                SessionOSData.this.fAcceptingCommands = runControl.isTargetAcceptingCommands();
                SessionOSData.this.fSession.addServiceEventListener((Object)SessionOSData.this, null);
                SessionOSData.this.fHardwareOs = (IGDBHardwareAndOS2)SessionOSData.this.fTracker.getService(IGDBHardwareAndOS2.class);
                if (SessionOSData.this.fHardwareOs == null) {
                    SessionOSData.this.fSupported = false;
                    SessionOSData.this.notifyUI();
                    return;
                }
                if (SessionOSData.this.fHardwareOs.isAvailable()) {
                    SessionOSData.this.fetchClasses();
                }
            }
        });
    }

    @ConfinedToDsfExecutor(value="")
    private void fetchClasses() {
        this.fWaitingForSession = false;
        this.fFetchingClasses = true;
        this.fHardwareOs.getResourceClasses((IDMContext)this.fContext, (DataRequestMonitor)new DataRequestMonitor<IGDBHardwareAndOS2.IResourceClass[]>((Executor)this.fSession.getExecutor(), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleCompleted() {
                if (this.isSuccess()) {
                    SessionOSData.this.fResourceClasses = (IGDBHardwareAndOS2.IResourceClass[])this.getData();
                    if (SessionOSData.this.fResourceClasses.length == 0) {
                        SessionOSData.this.fSupported = false;
                    }
                } else {
                    SessionOSData.this.fSupported = false;
                }
                SessionOSData.this.fFetchingClasses = false;
                SessionOSData.this.notifyUI();
            }
        });
    }

    @DsfServiceEventHandler
    public void eventDispatched(DataModelInitializedEvent e) {
        if (this.fHardwareOs != null) {
            this.fetchClasses();
        }
    }

    public boolean waitingForSessionInitialization() {
        return this.fWaitingForSession;
    }

    public boolean osResourcesSupported() {
        return this.fSupported;
    }

    public void dispose() {
        this.fSession.removeServiceEventListener((Object)this);
        this.fTracker.dispose();
    }

    public IGDBHardwareAndOS2.IResourceClass[] getResourceClasses() {
        return this.fResourceClasses;
    }

    public OSData existingData(String resourceClass) {
        return this.fExistingData.get(resourceClass);
    }

    public Date timestamp(String resourceClass) {
        return this.fTimestamp.get(resourceClass);
    }

    public boolean canFetchData() {
        return this.fAcceptingCommands && !this.fFetchingContent;
    }

    public boolean fetchingClasses() {
        return this.fFetchingClasses;
    }

    public boolean fetchingContent() {
        return this.fFetchingContent;
    }

    public void fetchData(final String resourceClass) {
        this.fFetchingContent = true;
        this.notifyUI();
        final DsfExecutor executor = this.fSession.getExecutor();
        executor.submit((Runnable)new DsfRunnable(){

            public void run() {
                SessionOSData.this.fHardwareOs.getResourcesInformation((IDMContext)SessionOSData.this.fContext, resourceClass, (DataRequestMonitor)new DataRequestMonitor<IGDBHardwareAndOS2.IResourcesInformation>((Executor)executor, null){

                    @ConfinedToDsfExecutor(value="fExecutor")
                    protected void handleCompleted() {
                        SessionOSData.this.fFetchingContent = false;
                        if (this.isSuccess()) {
                            OSData data = new OSData(resourceClass, (IGDBHardwareAndOS2.IResourcesInformation)this.getData());
                            SessionOSData.this.fExistingData.put(resourceClass, data);
                            SessionOSData.this.fTimestamp.put(resourceClass, new Date());
                        } else {
                            StatusManager.getManager().handle(this.getStatus(), 2);
                        }
                        SessionOSData.this.notifyUI();
                    }
                });
            }
        });
    }

    public void setUIListener(Listener listener, Control control) {
        this.fUIListener = listener;
        this.fUIControl = control;
    }

    private void notifyUI() {
        Control c = this.fUIControl;
        if (c != null && !c.isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                if (!c.isDisposed()) {
                    this.fUIListener.update();
                }
            });
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        if (e instanceof IRunControl.IContainerResumedDMEvent) {
            this.fAcceptingCommands = false;
            this.notifyUI();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        if (e instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.fAcceptingCommands = true;
            this.notifyUI();
        }
    }

    public ICommandControlService.ICommandControlDMContext getContext() {
        return this.fContext;
    }

    public static interface Listener {
        public void update();
    }
}

