/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model.xml;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorage;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlStorageElement
implements ICStorageElement {
    protected static final String[] emptyStringList = new String[0];
    final Object fLock;
    public Element fElement;
    private ICStorageElement fParent;
    protected List<ICStorageElement> fChildList = new ArrayList<ICStorageElement>();
    private volatile boolean fChildrenCreated;
    private String[] fAttributeFilters;
    private String[] fChildFilters;

    public XmlStorageElement(Element element) {
        this(element, null, false);
    }

    public XmlStorageElement(Element element, ICStorageElement parent, boolean alowReferencingParent) {
        this(element, parent, null, null);
    }

    public XmlStorageElement(Element element, ICStorageElement parent, String[] attributeFilters, String[] childFilters) {
        this.fElement = element;
        this.fParent = parent;
        this.fLock = element.getOwnerDocument();
        if (attributeFilters != null && attributeFilters.length != 0) {
            this.fAttributeFilters = (String[])attributeFilters.clone();
        }
        if (childFilters != null && childFilters.length != 0) {
            this.fChildFilters = (String[])childFilters.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChildren() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fChildrenCreated) {
                return;
            }
            this.fChildList.clear();
            NodeList list = this.fElement.getChildNodes();
            int size = list.getLength();
            int i = 0;
            while (i < size) {
                Node node = list.item(i);
                if (node.getNodeType() == 1 && this.isChildAlowed(node.getNodeName())) {
                    this.createAddChild((Element)node, true, null, null);
                }
                ++i;
            }
            this.fChildrenCreated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XmlStorageElement createAddChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        Object object = this.fLock;
        synchronized (object) {
            XmlStorageElement child = this.createChild(element, alowReferencingParent, attributeFilters, childFilters);
            this.fChildList.add(child);
            return child;
        }
    }

    protected XmlStorageElement createChild(Element element, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        return new XmlStorageElement(element, this, attributeFilters, childFilters);
    }

    @Override
    public ICStorageElement[] getChildren() {
        return this.getChildren(XmlStorageElement.class);
    }

    protected ICStorageElement[] getChildren(Class<XmlStorageElement> clazz) {
        return this.getChildren(clazz, true);
    }

    protected ICStorageElement[] getChildren(boolean load) {
        return this.getChildren(XmlStorageElement.class, load);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICStorageElement[] getChildren(Class<XmlStorageElement> clazz, boolean load) {
        Object object = this.fLock;
        synchronized (object) {
            if (load) {
                this.createChildren();
            }
            ICStorageElement[] children = (ICStorageElement[])Array.newInstance(clazz, this.fChildList.size());
            return this.fChildList.toArray(children);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICStorageElement[] getChildrenByName(String name) {
        Object object = this.fLock;
        synchronized (object) {
            this.createChildren();
            ArrayList<ICStorageElement> children = new ArrayList<ICStorageElement>();
            for (ICStorageElement child : this.fChildList) {
                if (!name.equals(child.getName())) continue;
                children.add(child);
            }
            return children.toArray(new ICStorageElement[children.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChildren() {
        Object object = this.fLock;
        synchronized (object) {
            this.createChildren();
            return !this.fChildList.isEmpty();
        }
    }

    @Override
    public ICStorageElement getParent() {
        return this.fParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.isPropertyAlowed(name) && this.fElement.hasAttribute(name)) {
                return this.fElement.getAttribute(name);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            return this.fElement.hasAttribute(name);
        }
    }

    private boolean isPropertyAlowed(String name) {
        if (this.fAttributeFilters != null) {
            return this.checkString(name, this.fAttributeFilters);
        }
        return true;
    }

    private boolean isChildAlowed(String name) {
        if (this.fChildFilters != null) {
            return this.checkString(name, this.fChildFilters);
        }
        return true;
    }

    private boolean checkString(String name, String[] array) {
        if (array.length > 0) {
            int i = 0;
            while (i < array.length) {
                if (name.equals(array[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(ICStorageElement el) {
        if (el instanceof XmlStorageElement) {
            ICStorageElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] == el) {
                    XmlStorageElement xmlEl = (XmlStorageElement)el;
                    Object object = this.fLock;
                    synchronized (object) {
                        Object object2 = xmlEl.fLock;
                        synchronized (object2) {
                            String value;
                            Node nextSibling = xmlEl.fElement.getNextSibling();
                            this.fElement.removeChild(xmlEl.fElement);
                            if (nextSibling != null && nextSibling.getNodeType() == 3 && (value = nextSibling.getNodeValue()) != null && value.trim().length() == 0) {
                                this.fElement.removeChild(nextSibling);
                            }
                            this.fChildList.remove(el);
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAttribute(String name) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.isPropertyAlowed(name)) {
                this.fElement.removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(String name, String value) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.isPropertyAlowed(name)) {
                this.fElement.setAttribute(name, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.fLock;
        synchronized (object) {
            this.createChildren();
            ICStorageElement[] children = this.fChildList.toArray(new ICStorageElement[this.fChildList.size()]);
            int i = 0;
            while (i < children.length) {
                this.removeChild(children[i]);
                ++i;
            }
            NamedNodeMap map = this.fElement.getAttributes();
            int i2 = 0;
            while (i2 < map.getLength()) {
                Node attr = map.item(i2);
                if (this.isPropertyAlowed(attr.getNodeName())) {
                    map.removeNamedItem(attr.getNodeName());
                }
                ++i2;
            }
            Node node = this.fElement.getFirstChild();
            while (node != null) {
                Node nextChildNode = node.getNextSibling();
                if (node.getNodeType() == 3) {
                    this.fElement.removeChild(node);
                }
                node = nextChildNode;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICStorageElement createChild(String name, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) {
        if (!this.isChildAlowed(name)) {
            return null;
        }
        Object object = this.fLock;
        synchronized (object) {
            Element childElement = this.fElement.getOwnerDocument().createElement(name);
            this.fElement.appendChild(childElement);
            return this.createAddChild(childElement, alowReferencingParent, attributeFilters, childFilters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.fLock;
        synchronized (object) {
            return this.fElement.getNodeName();
        }
    }

    @Override
    public ICStorageElement createChild(String name) {
        return this.createChild(name, true, null, null);
    }

    @Override
    public String getValue() {
        Text text = this.getTextChild();
        if (text != null) {
            return text.getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String value) {
        Text text = this.getTextChild();
        Object object = this.fLock;
        synchronized (object) {
            if (value != null) {
                if (text == null) {
                    text = this.fElement.getOwnerDocument().createTextNode(value);
                    this.fElement.appendChild(text);
                } else {
                    text.setData(value);
                }
            } else if (text != null) {
                this.fElement.removeChild(text);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Text getTextChild() {
        Object object = this.fLock;
        synchronized (object) {
            NodeList nodes = this.fElement.getChildNodes();
            Text text = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 3) {
                    text = (Text)node;
                    break;
                }
                ++i;
            }
            return text;
        }
    }

    @Override
    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        return this.addChild(el, true, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICStorageElement addChild(ICStorageElement el, boolean alowReferencingParent, String[] attributeFilters, String[] childFilters) throws UnsupportedOperationException {
        if (!this.isChildAlowed(el.getName())) {
            return null;
        }
        if (el instanceof XmlStorageElement) {
            XmlStorageElement xmlStEl = (XmlStorageElement)el;
            Object object = this.fLock;
            synchronized (object) {
                Object object2 = xmlStEl.fLock;
                synchronized (object2) {
                    Element xmlEl = xmlStEl.fElement;
                    Document thisDoc = this.fElement.getOwnerDocument();
                    Document otherDoc = xmlEl.getOwnerDocument();
                    xmlEl = !thisDoc.equals(otherDoc) ? (Element)thisDoc.importNode(xmlEl, true) : (Element)xmlEl.cloneNode(true);
                    xmlEl = (Element)this.fElement.appendChild(xmlEl);
                    return this.createAddChild(xmlEl, alowReferencingParent, attributeFilters, childFilters);
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public String[] getAttributeFilters() {
        if (this.fAttributeFilters != null) {
            return (String[])this.fAttributeFilters.clone();
        }
        return emptyStringList;
    }

    public String[] getChildFilters() {
        if (this.fChildFilters != null) {
            return (String[])this.fChildFilters.clone();
        }
        return emptyStringList;
    }

    @Override
    public boolean equals(ICStorageElement el) {
        ICStorageElement[] otherChildren;
        XmlStorageElement[] children;
        String[] otherAttrs;
        if (!this.getName().equals(el.getName())) {
            return false;
        }
        if (!XmlStorageElement.valuesMatch(this.getValue(), el.getValue())) {
            return false;
        }
        String[] attrs = this.getAttributeNames();
        if (attrs.length != (otherAttrs = el.getAttributeNames()).length) {
            return false;
        }
        if (attrs.length != 0) {
            HashSet<String> set = new HashSet<String>(Arrays.asList(attrs));
            set.removeAll(Arrays.asList(otherAttrs));
            if (set.size() != 0) {
                return false;
            }
            int i = 0;
            while (i < attrs.length) {
                if (!this.getAttribute(attrs[i]).equals(el.getAttribute(attrs[i]))) {
                    return false;
                }
                ++i;
            }
        }
        if ((children = (XmlStorageElement[])this.getChildren()).length != (otherChildren = el.getChildren()).length) {
            return false;
        }
        if (children.length != 0) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].equals(otherChildren[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean valuesMatch(String value, String other) {
        if (value == null) {
            return other == null || other.trim().length() == 0;
        }
        if (other == null) {
            return value.trim().length() == 0;
        }
        return value.trim().equals(other.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAttributeNames() {
        Object object = this.fLock;
        synchronized (object) {
            NamedNodeMap nodeMap = this.fElement.getAttributes();
            int length = nodeMap.getLength();
            ArrayList<String> list = new ArrayList<String>(length);
            int i = 0;
            while (i < length) {
                Node node = nodeMap.item(i);
                String name = node.getNodeName();
                if (this.isPropertyAlowed(name)) {
                    list.add(name);
                }
                ++i;
            }
            return list.toArray(new String[list.size()]);
        }
    }

    @Override
    public ICStorageElement createCopy() throws UnsupportedOperationException, CoreException {
        Element newEl = this.createXmlElementCopy();
        return new XmlStorageElement(newEl, null, this.fAttributeFilters, this.fChildFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element createXmlElementCopy() throws CoreException {
        try {
            Object object = this.fLock;
            synchronized (object) {
                Document doc;
                Element newXmlEl = null;
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = doc = builder.newDocument();
                synchronized (document) {
                    if (this.fElement.getParentNode().getNodeType() == 9) {
                        Document baseDoc = this.fElement.getOwnerDocument();
                        NodeList list = baseDoc.getChildNodes();
                        int i = 0;
                        while (i < list.getLength()) {
                            Node node = list.item(i);
                            if ((node = this.importAddNode(doc, node)).getNodeType() == 1 && newXmlEl == null) {
                                newXmlEl = (Element)node;
                            }
                            ++i;
                        }
                    } else {
                        newXmlEl = (Element)this.importAddNode(doc, this.fElement);
                    }
                }
                return newXmlEl;
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (FactoryConfigurationError e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    private Node importAddNode(Document doc, Node node) {
        node = node.getOwnerDocument().equals(doc) ? node.cloneNode(true) : doc.importNode(node, true);
        return doc.appendChild(node);
    }

    public ICSettingsStorage createSettingStorage(boolean readOnly) throws CoreException, UnsupportedOperationException {
        return new XmlStorage(this.fElement, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder builder = new StringBuilder();
        Object object = this.fLock;
        synchronized (object) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(this.fElement);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                builder.append(stream.toString());
            }
            catch (Exception e) {
                return this.fElement.toString();
            }
        }
        return builder.toString();
    }
}

