/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.build.crossgcc;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.runtime.Platform;

public class CrossEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        if (path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[1];
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[0] = path;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            IOption option = toolchain.getOptionBySuperClassId("cdt.managedbuild.option.gnu.cross.path");
            String path = (String)option.getValue();
            File sysroot = new File(path);
            File bin = new File(sysroot, "bin");
            if (bin.isDirectory()) {
                sysroot = bin;
            }
            return new PathEnvironmentVariable(sysroot);
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getPath();
        }
    }
}

