/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class BPELEditModel
extends EditModel {
    protected IFile extensionsFile;
    protected IFile artifactsFile;

    protected BPELEditModel(ResourceSet resourceSet, IResource primaryFile) {
        super(resourceSet, primaryFile);
    }

    public static EditModel getEditModel(IResource primaryFile) {
        return BPELEditModel.getEditModel((IResource)primaryFile, (EditModel.Factory)new BPELEditModelFactory());
    }

    public IFile getExtensionsFile() {
        if (this.extensionsFile == null) {
            IPath extensionsPath = this.getPrimaryFile().getFullPath().removeFileExtension().addFileExtension("bpelex");
            this.extensionsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(extensionsPath);
        }
        return this.extensionsFile;
    }

    public IFile getArtifactsFile() {
        if (this.artifactsFile == null) {
            IPath artifactsPath = this.getPrimaryFile().getFullPath().removeFileExtension();
            String shortName = String.valueOf(artifactsPath.lastSegment()) + "Artifacts";
            artifactsPath = artifactsPath.removeLastSegments(1).append(shortName).addFileExtension("wsdl");
            this.artifactsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(artifactsPath);
        }
        return this.artifactsFile;
    }

    static class BPELEditModelFactory
    extends EditModel.Factory {
        BPELEditModelFactory() {
        }

        protected EditModel createEditModel(ResourceSet resourceSet, IResource primaryFile) {
            return new BPELEditModel(resourceSet, primaryFile);
        }
    }
}

