/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.proposal.providers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ListMap;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredContentProvider;

public class ModelContentProposalProvider
implements IContentProposalProvider {
    static final IContentProposal[] NO_PROPOSALS = new IContentProposal[0];
    private ValueProvider valueProvider;
    private List<IContentProposal> fEndProposals = new ArrayList<IContentProposal>();
    private List<IContentProposal> fStartProposals = new LinkedList<IContentProposal>();
    private IStructuredContentProvider contentProvider;
    private IFilter filter;

    public ModelContentProposalProvider(ValueProvider aValueProvider, IStructuredContentProvider aContentProvider) {
        this(aValueProvider, aContentProvider, null);
    }

    public ModelContentProposalProvider(ValueProvider aValueProvider, IStructuredContentProvider aContentProvider, IFilter aFilter) {
        this.valueProvider = aValueProvider;
        this.contentProvider = aContentProvider;
        this.filter = aFilter;
    }

    public void addProposalToStart(IContentProposal proposal) {
        this.fStartProposals.add(proposal);
    }

    public void addProposalToEnd(IContentProposal proposal) {
        this.fEndProposals.add(proposal);
    }

    public IContentProposal[] getProposals(String contents, int position) {
        IContentProposal[] proposals;
        ArrayList<IContentProposal> all = new ArrayList<IContentProposal>();
        all.addAll(this.fStartProposals);
        IContentProposal[] iContentProposalArray = proposals = (IContentProposal[])ListMap.Map(this.doFilter(this.contentProvider.getElements(this.valueProvider.value())), new ListMap.Visitor(){

            @Override
            public Object visit(Object obj) {
                IContentProposal adapter = BPELUtil.adapt(obj, IContentProposal.class);
                return adapter != null ? adapter : ListMap.IGNORE;
            }
        }, (Object[])NO_PROPOSALS);
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProposal p = iContentProposalArray[n2];
            all.add(p);
            ++n2;
        }
        all.addAll(this.fEndProposals);
        return all.toArray(NO_PROPOSALS);
    }

    Object[] doFilter(Object[] elements) {
        if (this.filter == null || elements.length < 1) {
            return elements;
        }
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (this.filter.select(e)) {
                out.add(e);
            }
            ++n2;
        }
        return out.toArray();
    }

    public static abstract class ValueProvider {
        public abstract Object value();
    }
}

