/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.properties.ExpressionSection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class WaitConditionSection
extends ExpressionSection {
    protected Button[] radioButtons;
    protected int fButtonCount;
    protected int fCurrentButtonIndex;
    static final String[] gLabels = new String[]{Messages.WaitConditionSection_Date_1, Messages.WaitConditionSection_Duration_2};
    static Map<EClass, EStructuralFeature[]> CLASS2FEATURES = new HashMap<EClass, EStructuralFeature[]>();

    static {
        CLASS2FEATURES.put(BPELPackage.eINSTANCE.getWait(), new EStructuralFeature[]{BPELPackage.eINSTANCE.getWait_Until(), BPELPackage.eINSTANCE.getWait_For()});
        CLASS2FEATURES.put(BPELPackage.eINSTANCE.getOnAlarm(), new EStructuralFeature[]{BPELPackage.eINSTANCE.getOnAlarm_Until(), BPELPackage.eINSTANCE.getOnAlarm_For()});
    }

    @Override
    protected String getExpressionType() {
        return this.getButtonExprType(this.fCurrentButtonIndex);
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.fCurrentButtonIndex = this.getButtonIndexFromModel();
        this.updateRadioButtonWidgets();
    }

    protected void updateRadioButtonWidgets() {
        this.fCurrentButtonIndex = this.getButtonIndexFromModel();
        if (this.fCurrentButtonIndex >= 0) {
            this.radioButtons[this.fCurrentButtonIndex].setSelection(true);
        }
        int i = 0;
        while (i < this.radioButtons.length) {
            if (i != this.fCurrentButtonIndex) {
                this.radioButtons[i].setSelection(false);
            }
            ++i;
        }
    }

    protected void createRadioButtonWidgets(Composite parent) {
        this.fButtonCount = gLabels.length;
        Composite radioComposite = this.getWidgetFactory().createComposite(parent);
        radioComposite.setLayout((Layout)new GridLayout(2, true));
        this.radioButtons = new Button[this.fButtonCount];
        int i = 0;
        while (i < this.fButtonCount) {
            this.radioButtons[i] = this.fWidgetFactory.createButton(radioComposite, gLabels[i], 16);
            this.radioButtons[i].addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    if (button.getSelection()) {
                        int i = 0;
                        while (i < WaitConditionSection.this.radioButtons.length) {
                            if (WaitConditionSection.this.radioButtons[i] == button) {
                                WaitConditionSection.this.fCurrentButtonIndex = i;
                                WaitConditionSection.this.saveExpressionToModel();
                                break;
                            }
                            ++i;
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
    }

    @Override
    protected void createClient(Composite parent) {
        super.createClient(parent);
        this.createRadioButtonWidgets(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.property_wait");
    }

    protected String getButtonExprType(int buttonIndex) {
        if (buttonIndex == 0) {
            return "deadline";
        }
        if (buttonIndex == 1) {
            return "duration";
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected Expression getExprFromModel() {
        Object input = this.getInput();
        EStructuralFeature feature = this.getStructuralFeature((EObject)input);
        if (feature == null) {
            return null;
        }
        Object result = input.eGet(feature);
        if (result != null && result instanceof Expression) {
            return (Expression)result;
        }
        return null;
    }

    protected int getButtonIndexFromModel() {
        Object input = this.getInput();
        EStructuralFeature feature = this.getStructuralFeature((EObject)input);
        if (feature == null) {
            return 1;
        }
        if (feature.getName().indexOf("until") >= 0) {
            return 0;
        }
        return 1;
    }

    protected boolean isValidClientUseType(String useType) {
        return "deadlineCondition".equals(useType) || "durationCondition".equals(useType);
    }

    @Override
    protected EStructuralFeature getStructuralFeature() {
        return this.getStructuralFeature(this.fCurrentButtonIndex);
    }

    protected EStructuralFeature getStructuralFeature(int index) {
        EStructuralFeature[] features = CLASS2FEATURES.get(this.getInput().eClass());
        assert (features != null) : "Features cannot be null";
        return features[index];
    }

    @Override
    protected EStructuralFeature getStructuralFeature(EObject eObj) {
        EStructuralFeature[] features;
        EStructuralFeature[] eStructuralFeatureArray = features = CLASS2FEATURES.get(eObj.eClass());
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature f = eStructuralFeatureArray[n2];
            Object result = eObj.eGet(f);
            if (result != null) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void saveExpressionToModel() {
        if (this.modelUpdate.get()) {
            return;
        }
        EStructuralFeature aFeature = this.getStructuralFeature();
        EObject target = this.getExpressionTarget();
        CompoundCommand result = new CompoundCommand();
        Condition exp = BPELFactory.eINSTANCE.createCondition();
        exp.setBody((Object)(this.expressionText != null ? this.expressionText.getText().trim() : ""));
        result.add((Command)new SetCommand(target, this.getExpression4Target((Expression)exp), aFeature));
        EStructuralFeature[] eStructuralFeatureArray = CLASS2FEATURES.get(this.getInput().eClass());
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (!feature.equals(aFeature) && target.eIsSet(feature)) {
                result.add((Command)new SetCommand(target, null, feature));
            }
            ++n2;
        }
        this.getCommandFramework().execute((Command)result);
    }
}

