/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetVariableKindCommand;
import org.eclipse.bpel.ui.commands.SetVariableTypeCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.VariableTypeSelector;
import org.eclipse.bpel.ui.uiextensionmodel.VariableExtension;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;

public class VariableTypeSection
extends BPELPropertySection {
    protected VariableTypeSelector variableTypeSelector;
    protected Composite parentComposite;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected boolean isMessageTypeAffected(Notification n) {
        return n.getFeatureID(Variable.class) == 5;
    }

    protected boolean isTypeAffected(Notification n) {
        return n.getFeatureID(Variable.class) == 7;
    }

    protected boolean isElementAffected(Notification n) {
        return n.getFeatureID(Variable.class) == 1;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new BatchedMultiObjectAdapter(){
            boolean update = false;

            @Override
            public void notify(Notification n) {
                if (this.update) {
                    return;
                }
                int eventGroup = n.getEventType() / 100;
                if (eventGroup == 21) {
                    this.update = true;
                    return;
                }
                if (VariableTypeSection.this.isMessageTypeAffected(n)) {
                    this.update = true;
                    return;
                }
                if (VariableTypeSection.this.isTypeAffected(n)) {
                    this.update = true;
                    return;
                }
                if (VariableTypeSection.this.isElementAffected(n)) {
                    this.update = true;
                    return;
                }
                if (n.getNotifier() instanceof VariableExtension) {
                    this.update = true;
                    return;
                }
            }

            @Override
            public void finish() {
                if (this.update) {
                    VariableTypeSection.this.updateVariableTypeSelector();
                }
                this.update = false;
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        VariableExtension varExt = (VariableExtension)ModelHelper.getExtension(this.getInput());
        if (varExt != null) {
            this.fAdapters[0].addToObject((Notifier)varExt);
        }
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.parentComposite = this.createFlatFormComposite(parent);
        this.variableTypeSelector = new VariableTypeSelector(composite, 0, this.getBPELEditor(), this.fWidgetFactory, new VariableTypeCallback(), false, 255);
        FlatFormData data = new FlatFormData();
        data.top = new FlatFormAttachment(0, 0);
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.variableTypeSelector.setLayoutData(data);
    }

    public void updateVariableTypeSelector() {
        this.variableTypeSelector.setVariable((Variable)this.getInput());
        this.updateMarkers();
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.updateVariableTypeSelector();
    }

    @Override
    public Object getUserContext() {
        return this.variableTypeSelector.getUserContext();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.variableTypeSelector.restoreUserContext(userContext);
    }

    @Override
    public boolean isValidMarker(IMarker marker) {
        String context = null;
        try {
            context = (String)marker.getAttribute("href.context");
        }
        catch (Exception exception) {
            return false;
        }
        return !"name".equals(context);
    }

    @Override
    protected void updateMarkers() {
        this.variableTypeSelector.dataTypeLabel.clear();
        IMarker[] iMarkerArray = this.getMarkers(this.getInput());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            this.variableTypeSelector.dataTypeLabel.addStatus(BPELUtil.adapt((Object)m, IStatus.class));
            ++n2;
        }
    }

    public class VariableTypeCallback
    implements VariableTypeSelector.Callback {
        @Override
        public void selectRadioButton(int index) {
            Variable var = (Variable)VariableTypeSection.this.getInput();
            VariableExtension varExt = (VariableExtension)ModelHelper.getExtension((EObject)var);
            CompoundCommand command = new CompoundCommand();
            if (var.getMessageType() != null || var.getType() != null || var.getXSDElement() != null) {
                command.add((Command)new SetVariableTypeCommand(var, null));
            }
            if (varExt.getVariableKind() != index) {
                command.add((Command)new SetVariableKindCommand(varExt, index));
            }
            if (!command.isEmpty()) {
                VariableTypeSection.this.getCommandFramework().execute(VariableTypeSection.this.wrapInShowContextCommand((Command)command));
            }
        }

        @Override
        public void selectXSDType(XSDTypeDefinition xsdType) {
            Variable variable = (Variable)VariableTypeSection.this.getInput();
            SetVariableTypeCommand cmd = new SetVariableTypeCommand(variable, (EObject)xsdType);
            VariableTypeSection.this.getCommandFramework().execute(VariableTypeSection.this.wrapInShowContextCommand((Command)cmd));
        }

        @Override
        public void selectXSDElement(XSDElementDeclaration xsdElement) {
            Variable variable = (Variable)VariableTypeSection.this.getInput();
            SetVariableTypeCommand cmd = new SetVariableTypeCommand(variable, (EObject)xsdElement);
            VariableTypeSection.this.getCommandFramework().execute(VariableTypeSection.this.wrapInShowContextCommand((Command)cmd));
        }

        @Override
        public void selectMessageType(Message message) {
            Variable variable = (Variable)VariableTypeSection.this.getInput();
            SetVariableTypeCommand cmd = new SetVariableTypeCommand(variable, (EObject)message);
            VariableTypeSection.this.getCommandFramework().execute(VariableTypeSection.this.wrapInShowContextCommand((Command)cmd));
        }
    }
}

