/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.FocusContext;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.details.RadioButtonIValue;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class JoinFailureSection
extends BPELPropertySection {
    protected Button yesRadio;
    protected Button noRadio;
    protected Button sameAsParentRadio;
    Composite fComposite;
    EditController fRadioController;
    IValue fContext;

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                Object notifier = n.getNotifier();
                if (!(notifier instanceof Activity) || !(JoinFailureSection.this.getInput() instanceof Activity)) {
                    return;
                }
                Activity activity = (Activity)notifier;
                Activity myInput = (Activity)JoinFailureSection.this.getModel();
                if (n.getFeature() == BPELPackage.eINSTANCE.getActivity_Targets()) {
                    if (myInput == activity) {
                        JoinFailureSection.this.updateActivity(myInput);
                    }
                } else if (n.getFeature() == BPELPackage.eINSTANCE.getActivity_SuppressJoinFailure() && activity != myInput) {
                    JoinFailureSection.this.updateActivity(myInput);
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Object p = this.getInput();
        if (p == null) {
            return;
        }
        p = p.eContainer();
        while (p != null) {
            if (p instanceof Activity || p instanceof Process) {
                this.fAdapters[0].addToObject((Notifier)p);
            }
            p = p.eContainer();
        }
    }

    protected boolean inheritSuppressed(Activity activity) {
        Boolean result = null;
        EObject p = activity.eContainer();
        while (p != null && result == null) {
            if (p instanceof Activity) {
                Activity a = (Activity)p;
                result = a.getSuppressJoinFailure();
            } else if (p instanceof Process) {
                Process process = (Process)p;
                result = process.getSuppressJoinFailure();
            }
            p = p.eContainer();
        }
        if (result == null) {
            return false;
        }
        return result;
    }

    protected void createSuppressJoinFailureWidgets(Composite composite) {
        Label suppressLabel = this.fWidgetFactory.createLabel(composite, Messages.JoinFailureDetails_Suppress_Join_Failure__1);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 5);
        data.top = new FlatFormAttachment(0, 4);
        suppressLabel.setLayoutData((Object)data);
        this.yesRadio = this.fWidgetFactory.createButton(composite, Messages.JoinFailureDetails_Yes_2, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)suppressLabel, 157));
        data.top = new FlatFormAttachment(0, 4);
        this.yesRadio.setLayoutData((Object)data);
        this.yesRadio.setData("value", (Object)Boolean.TRUE);
        this.noRadio = this.fWidgetFactory.createButton(composite, Messages.JoinFailureDetails_No_3, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.yesRadio, 5);
        data.top = new FlatFormAttachment((Control)this.yesRadio, 0, 0x1000000);
        this.noRadio.setLayoutData((Object)data);
        this.noRadio.setData("value", (Object)Boolean.FALSE);
        this.sameAsParentRadio = this.fWidgetFactory.createButton(composite, Messages.JoinFailureDetails_Use_Same_Value_as_Parent_4, 16);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.noRadio, 5);
        data.top = new FlatFormAttachment((Control)this.yesRadio, 0, 0x1000000);
        this.sameAsParentRadio.setLayoutData((Object)data);
        this.sameAsParentRadio.setData("value", RadioButtonIValue.UNSET_VALUE);
        this.fContext = new FocusContext(new Control[]{this.yesRadio, this.noRadio, this.sameAsParentRadio});
    }

    protected void createControllers() {
        this.fRadioController = this.createEditController();
        this.fRadioController.setViewIValue((IValue)new RadioButtonIValue(new Button[]{this.yesRadio, this.noRadio, this.sameAsParentRadio}));
        this.fRadioController.startListeningTo(new Control[]{this.yesRadio, this.noRadio, this.sameAsParentRadio});
    }

    @Override
    protected void createClient(Composite parent) {
        this.fComposite = this.createFlatFormComposite(parent);
        this.createSuppressJoinFailureWidgets(this.fComposite);
        this.createControllers();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fComposite, "org.eclipse.bpel.ui.property_join_failure");
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        if (newInput instanceof Process) {
            this.fRadioController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getProcess_SuppressJoinFailure());
            this.fRadioController.setInput(newInput);
            this.sameAsParentRadio.setEnabled(false);
        } else if (newInput instanceof Activity) {
            this.fRadioController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getActivity_SuppressJoinFailure());
            this.fRadioController.setInput(newInput);
            this.updateActivity((Activity)newInput);
        }
    }

    protected void updateActivity(Activity activity) {
        String newDefault;
        boolean bEnable = activity.getTargets() != null;
        this.fComposite.setEnabled(bEnable);
        this.yesRadio.setEnabled(bEnable);
        this.noRadio.setEnabled(bEnable);
        this.sameAsParentRadio.setEnabled(bEnable);
        String string = newDefault = this.inheritSuppressed(activity) ? Messages.JoinFailureDetails_Use_Same_Value_as_Parent__Yes__5 : Messages.JoinFailureDetails_Use_Same_Value_as_Parent__No__6;
        if (!this.sameAsParentRadio.getText().equals(newDefault)) {
            this.sameAsParentRadio.setText(newDefault);
            this.sameAsParentRadio.getParent().layout(true);
        }
    }

    @Override
    public Object getUserContext() {
        return this.fContext.get();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.fContext.set(userContext);
    }
}

