/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.wsdl.wizards;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.bpel.common.wsdl.helpers.UriAndUrlHelper;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class UriResourceImportWizardPage
extends WizardPage {
    private URI uri;
    private IContainer outputContainer;
    private boolean complete = false;
    private String initialUri;
    private final String shortName;
    private final String[] filterNames;
    private final String[] filterExtensions;

    public UriResourceImportWizardPage(IStructuredSelection selection, String shortName, String[] filterNames, String[] filterExtensions) {
        super("Import Page");
        this.shortName = shortName;
        this.filterNames = filterNames;
        this.filterExtensions = filterExtensions;
        if (!selection.isEmpty()) {
            Object o = selection.getFirstElement();
            IResource res = (IResource)UriResourceImportWizardPage.getAdapter(o, IResource.class);
            if (res instanceof IContainer) {
                this.outputContainer = (IContainer)res;
            } else if (res != null) {
                this.outputContainer = res.getParent();
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label l = new Label(container, 0);
        l.setText(String.valueOf(this.shortName) + " URI:");
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 6;
        layoutData.horizontalSpan = 2;
        l.setLayoutData((Object)layoutData);
        final Text text = new Text(container, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String uri = text.getText();
                if (uri.trim().length() == 0) {
                    return;
                }
                try {
                    UriResourceImportWizardPage.this.uri = UriAndUrlHelper.urlToUri(uri);
                }
                catch (Exception exception) {
                    UriResourceImportWizardPage.this.uri = null;
                }
                UriResourceImportWizardPage.this.validate();
            }
        });
        if (this.initialUri != null) {
            text.setText(this.initialUri);
        }
        Button b = new Button(container, 8);
        b.setText("Browse...");
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(text.getShell(), 4);
                dlg.setFilterNames(UriResourceImportWizardPage.this.filterNames);
                dlg.setFilterExtensions(UriResourceImportWizardPage.this.filterExtensions);
                String path = dlg.open();
                if (path != null) {
                    String uri = new File(path).toURI().toString();
                    text.setText(uri);
                    text.setSelection(uri.length());
                    text.setFocus();
                }
            }
        });
        l = new Label(container, 0);
        l.setText("Select the container in which the " + this.shortName + " will be imported.");
        layoutData = new GridData();
        layoutData.verticalIndent = 10;
        layoutData.horizontalSpan = 2;
        l.setLayoutData((Object)layoutData);
        TreeViewer viewer = new TreeViewer(container, 2564);
        layoutData = new GridData(1808);
        layoutData.heightHint = 200;
        layoutData.horizontalSpan = 2;
        viewer.getTree().setLayoutData((Object)layoutData);
        viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        viewer.setContentProvider((IContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    IResource[] members;
                    try {
                        members = ((IContainer)o).members();
                    }
                    catch (Exception exception) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource member = iResourceArray[n2];
                        if (member instanceof IContainer) {
                            results.add(member);
                        }
                        ++n2;
                    }
                    return results.toArray();
                }
                return new Object[0];
            }
        });
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        viewer.setInput((Object)root);
        if (this.outputContainer != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)this.outputContainer), true);
            viewer.expandToLevel((Object)this.outputContainer, 1);
            viewer.reveal((Object)this.outputContainer.getProject());
        }
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                if (!s.isEmpty()) {
                    UriResourceImportWizardPage.this.outputContainer = (IContainer)s.getFirstElement();
                } else {
                    UriResourceImportWizardPage.this.outputContainer = null;
                }
                UriResourceImportWizardPage.this.validate();
            }
        });
        text.setFocus();
        this.setControl((Control)container);
    }

    private void validate() {
        if (this.uri == null) {
            this.setErrorMessage("The " + this.shortName + "'s URI is invalid.");
            this.setPageComplete(false);
            return;
        }
        if ("file".equals(this.uri.getScheme()) && !new File(this.uri).exists()) {
            this.setErrorMessage("This URI points to a file that does not exist.");
            this.setPageComplete(false);
            return;
        }
        if (this.outputContainer == null) {
            this.setErrorMessage("You must select the destination container.");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public boolean isPageComplete() {
        return this.complete;
    }

    public void setPageComplete(boolean complete) {
        this.complete = complete;
        super.setPageComplete(complete);
    }

    public IContainer getOutputContainer() {
        return this.outputContainer;
    }

    public URI getUriToImport() {
        return this.uri;
    }

    public void setInitialUri(String initialUri) {
        this.initialUri = initialUri;
    }

    public static Object getAdapter(Object sourceObject, Class<?> adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull(adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }
}

