/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeNode;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.ValueEntry;

public class ValueNode<K, V>
extends BTreeNode<K, V> {
    static final int EMPTY_NODE_SIZE = 16;
    private int nodeSize = 16;
    private int prevNodeId = -1;
    private int nextNodeId = -1;
    private int entryCount = 0;
    private ValueEntry<V> firstEntry = null;
    private ValueEntry<V> lastEntry = null;

    ValueNode(BTree<K, V> tree, int id) {
        super(tree, 3, id);
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.nodeSize = in.readInt();
        this.prevNodeId = in.readInt();
        this.nextNodeId = in.readInt();
        this.entryCount = in.readInt();
        int i = 0;
        while (i < this.entryCount) {
            BTreeValue value = this.btree.readValue(in);
            ValueEntry<V> entry = new ValueEntry<V>(value);
            if (this.firstEntry == null) {
                this.firstEntry = entry;
                this.lastEntry = entry;
            } else {
                this.lastEntry.setNext(entry);
                entry.setPrev(this.lastEntry);
                this.lastEntry = entry;
            }
            ++i;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeSize);
        out.writeInt(this.prevNodeId);
        out.writeInt(this.nextNodeId);
        out.writeInt(this.entryCount);
        ValueEntry<V> entry = this.firstEntry;
        while (entry != null) {
            this.btree.writeValue(out, entry.getValue());
            entry = entry.getNext();
        }
    }

    public ValueEntry<V> getFirstEntry() {
        return this.firstEntry;
    }

    protected ValueEntry<V> getLastEntry() {
        return this.lastEntry;
    }

    public ValueEntry<V> append(BTreeValue<V> value) throws IOException {
        ValueEntry<V> entry = new ValueEntry<V>(value);
        if (this.lastEntry == null) {
            this.firstEntry = entry;
            this.lastEntry = entry;
        } else {
            this.lastEntry.setNext(entry);
            entry.setPrev(this.lastEntry);
            this.lastEntry = entry;
        }
        this.nodeSize += this.btree.getValueSize(value);
        ++this.entryCount;
        this.dirty = true;
        return entry;
    }

    public int getPrevNodeId() {
        return this.prevNodeId;
    }

    public void setPrevNodeId(int prevNodeId) {
        this.prevNodeId = prevNodeId;
    }

    public int getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(int nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    @Override
    void dumpNode() throws IOException {
        System.out.println("VALUE:" + this.nodeId);
        System.out.println("nodeSize:" + this.nodeSize);
        System.out.println("prevNodeId:" + this.prevNodeId);
        System.out.println("nextNodeId:" + this.nextNodeId);
        System.out.println("entryCount:" + this.entryCount);
    }

    @Override
    void dumpAll() throws IOException {
        this.dumpNode();
        ValueEntry<V> entry = this.firstEntry;
        while (entry != null) {
            System.out.println(this.btree.getValue(entry.getValue()));
            entry = entry.getNext();
        }
    }
}

