/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.IOException;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;

public class Block
extends Cacheable
implements ArchiveConstants {
    ArchiveFileV2 af;
    int id;
    final int blockSize;
    byte[] blockData;
    private int dataSize;
    private int dirtyStart;
    private int dirtyEnd;

    Block(ArchiveFileV2 af, int blockId, int size) {
        super(af.caches, Integer.valueOf(blockId));
        this.af = af;
        this.blockSize = size;
        this.blockData = new byte[size];
        this.id = blockId;
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
        this.dataSize = 0;
    }

    public void refresh() throws IOException {
        this.dataSize = this.af.read(this.id, 0, this.blockData, 0, this.blockSize);
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public void flush() throws IOException {
        if (this.dirtyEnd != this.dirtyStart) {
            this.af.write(this.id, this.dirtyStart, this.blockData, this.dirtyStart, this.dirtyEnd - this.dirtyStart);
        }
        this.dirtyStart = 0;
        this.dirtyEnd = 0;
    }

    public byte[] getData() {
        return this.blockData;
    }

    public int write(int tgt, byte[] b, int off, int len) throws IOException {
        int size = this.blockSize - tgt;
        if (size > len) {
            size = len;
        }
        System.arraycopy(b, off, this.blockData, tgt, size);
        if (this.dirtyStart > tgt) {
            this.dirtyStart = tgt;
        }
        if (this.dirtyEnd < tgt + size) {
            this.dirtyEnd = tgt + size;
        }
        if (this.dataSize < this.dirtyEnd) {
            this.dataSize = this.dirtyEnd;
        }
        return size;
    }

    public int read(int src, byte[] b, int off, int len) throws IOException {
        int size = this.dataSize - src;
        if (size > len) {
            size = len;
        }
        System.arraycopy(this.blockData, src, b, off, size);
        return size;
    }
}

