/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.ui.plugin.ChartUIPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class UIHelper {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.ui/util");

    public static Point getScreenLocation(Composite cmpTarget) {
        Point ptScreen = new Point(0, 0);
        try {
            Composite cTmp = cmpTarget;
            while (!(cTmp instanceof Shell)) {
                ptScreen.x += cTmp.getLocation().x;
                ptScreen.y += cTmp.getLocation().y;
                cTmp = cTmp.getParent();
            }
        }
        catch (Exception e) {
            logger.log(e);
        }
        return cmpTarget.getShell().toDisplay(ptScreen);
    }

    public static void centerOnScreen(Shell shell) {
        org.eclipse.birt.core.ui.utils.UIHelper.centerOnScreen((Shell)shell);
    }

    public static URL getURL(String sPluginRelativePath) {
        URL url = null;
        if (UIHelper.isEclipseMode()) {
            try {
                url = new URL(ChartUIPlugin.getDefault().getBundle().getEntry("/"), sPluginRelativePath);
            }
            catch (MalformedURLException e) {
                logger.log((Exception)e);
            }
        } else {
            url = UIHelper.class.getResource("/" + sPluginRelativePath);
            if (url == null) {
                try {
                    url = new URL("file:///" + new File(sPluginRelativePath).getAbsolutePath());
                }
                catch (MalformedURLException e) {
                    logger.log((Exception)e);
                }
            }
        }
        return url;
    }

    private static Image createImage(String sPluginRelativePath) {
        Image img = null;
        try {
            try {
                URL url = UIHelper.getURL(sPluginRelativePath);
                if (url != null) {
                    img = new Image((Device)Display.getCurrent(), url.openStream());
                }
            }
            catch (MalformedURLException malformedURLException) {
                img = new Image((Device)Display.getCurrent(), (InputStream)new FileInputStream(UIHelper.getURL(sPluginRelativePath).toString()));
            }
        }
        catch (FileNotFoundException e) {
            logger.log((Exception)e);
        }
        catch (IOException e) {
            logger.log((Exception)e);
        }
        if (img == null) {
            img = new Image((Device)Display.getCurrent(), 1, 1);
        }
        return img;
    }

    public static Image getImage(String sPluginRelativePath) {
        String resourcePath;
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(resourcePath = "org.eclipse.birt.chart.ui/" + sPluginRelativePath);
        if (image == null) {
            image = UIHelper.createImage(sPluginRelativePath);
            registry.put(resourcePath, image);
        }
        return image;
    }

    public static boolean isEclipseMode() {
        return org.eclipse.birt.core.ui.utils.UIHelper.isEclipseMode();
    }
}

