/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import com.ibm.icu.util.Calendar;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.util.ChartUtil;

public class ScriptUtil {
    public static void script(StringBuffer str, DataPointHints dph, LegendItemHints lerh, String axisLabel) {
        if (dph != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getBaseValue()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getOrthogonalValue()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(dph.getSeriesValue()));
        } else {
            str.append(",null,null,null");
        }
        if (lerh != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(lerh.getItemValue()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(lerh.getItemText()));
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(lerh.getValueText()));
        } else {
            str.append(",null,null,null");
        }
        if (axisLabel != null) {
            str.append(",");
            str.append(ScriptUtil.addDataValueToScript(axisLabel));
        } else {
            str.append(",null");
        }
    }

    private static String addDataValueToScript(Object oValue) {
        if (oValue instanceof String) {
            return "'" + ScriptUtil.transformToJsConstants((String)oValue) + "'";
        }
        if (oValue instanceof Double) {
            return ((Double)oValue).toString();
        }
        if (oValue instanceof NumberDataElement) {
            return ((NumberDataElement)oValue).toString();
        }
        if (oValue instanceof Calendar) {
            return "'" + ChartUtil.stringValue((Object)oValue) + "'";
        }
        if (oValue instanceof DateTimeDataElement) {
            return "'" + ChartUtil.stringValue((Object)((DateTimeDataElement)oValue).getValueAsCalendar()) + "'";
        }
        if (oValue == null) {
            return "''";
        }
        return "'" + oValue.toString() + "'";
    }

    public static String transformToJsConstants(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    buffer.append("\\\\");
                    break;
                }
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                case '\'': {
                    buffer.append("\\'");
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String transformToHTMLText(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("\r\n", "<br>");
    }
}

