/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.profiler.provider;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.profiler.ProfileEntry;
import org.eclipse.acceleo.profiler.ProfilerFactory;
import org.eclipse.acceleo.profiler.ProfilerPackage;
import org.eclipse.acceleo.profiler.provider.ProfilerEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ProfileEntryItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ProfileEntryItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addDurationPropertyDescriptor(object);
            this.addCountPropertyDescriptor(object);
            this.addPercentagePropertyDescriptor(object);
            this.addCreateTimePropertyDescriptor(object);
            this.addMonitoredPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addDurationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProfileEntry_duration_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProfileEntry_duration_feature", "_UI_ProfileEntry_type"), (EStructuralFeature)ProfilerPackage.Literals.PROFILE_ENTRY__DURATION, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProfileEntry_count_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProfileEntry_count_feature", "_UI_ProfileEntry_type"), (EStructuralFeature)ProfilerPackage.Literals.PROFILE_ENTRY__COUNT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addPercentagePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProfileEntry_percentage_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProfileEntry_percentage_feature", "_UI_ProfileEntry_type"), (EStructuralFeature)ProfilerPackage.Literals.PROFILE_ENTRY__PERCENTAGE, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addCreateTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProfileEntry_createTime_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProfileEntry_createTime_feature", "_UI_ProfileEntry_type"), (EStructuralFeature)ProfilerPackage.Literals.PROFILE_ENTRY__CREATE_TIME, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addMonitoredPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProfileEntry_monitored_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProfileEntry_monitored_feature", "_UI_ProfileEntry_type"), (EStructuralFeature)ProfilerPackage.Literals.PROFILE_ENTRY__MONITORED, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProfilerPackage.Literals.PROFILE_ENTRY__CALLEES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        EObject monitored = ((ProfileEntry)object).getMonitored();
        return ProfilerEditPlugin.LABEL_PROVIDER.getImage((Object)monitored);
    }

    public String getText(Object object) {
        ProfileEntry profileEntry = (ProfileEntry)object;
        EObject monitored = profileEntry.getMonitored();
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setMaximumIntegerDigits(3);
        ((NumberFormat)format).setMaximumFractionDigits(2);
        return String.valueOf(format.format(profileEntry.getPercentage())) + "% / " + profileEntry.getDuration() + "ms / " + profileEntry.getCount() + " times [" + ProfilerEditPlugin.LABEL_PROVIDER.getText((Object)monitored) + "]";
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ProfileEntry.class)) {
            case 0: 
            case 3: 
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ProfilerPackage.Literals.PROFILE_ENTRY__CALLEES, ProfilerFactory.eINSTANCE.createProfileEntry()));
        newChildDescriptors.add(this.createChildParameter(ProfilerPackage.Literals.PROFILE_ENTRY__CALLEES, ProfilerFactory.eINSTANCE.createLoopProfileEntry()));
    }

    public ResourceLocator getResourceLocator() {
        return ProfilerEditPlugin.INSTANCE;
    }
}

