/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene70.IndexedDISI;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.store.GrowableByteArrayDataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.apache.lucene.util.packed.DirectWriter;

final class Lucene70DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene70DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addNumericField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)0);
        this.writeValues(field, new EmptyDocValuesProducer(){

            @Override
            public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
                return DocValues.singleton(valuesProducer.getNumeric(field));
            }
        });
    }

    private long[] writeValues(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        int numBitsPerValue;
        SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
        int numDocsWithValue = 0;
        MinMaxTracker minMax = new MinMaxTracker();
        MinMaxTracker blockMinMax = new MinMaxTracker();
        long gcd = 0L;
        HashSet<Long> uniqueValues = new HashSet<Long>();
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values.nextValue();
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (minMax.numValues != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minMax.min);
                    }
                }
                minMax.update(v);
                blockMinMax.update(v);
                if (blockMinMax.numValues == 16384L) {
                    blockMinMax.nextBlock();
                }
                if (uniqueValues == null || !uniqueValues.add(v) || uniqueValues.size() <= 256) continue;
                uniqueValues = null;
            }
            ++numDocsWithValue;
            doc = values.nextDoc();
        }
        minMax.finish();
        blockMinMax.finish();
        long numValues = minMax.numValues;
        long min = minMax.min;
        long max = minMax.max;
        assert (blockMinMax.spaceInBits <= minMax.spaceInBits);
        if (numDocsWithValue == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
        } else if (numDocsWithValue == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSortedNumeric(field);
            IndexedDISI.writeBitSet(values, this.data);
            this.meta.writeLong(this.data.getFilePointer() - offset);
        }
        this.meta.writeLong(numValues);
        boolean doBlocks = false;
        HashMap<Object, Integer> encode = null;
        if (min >= max) {
            numBitsPerValue = 0;
            this.meta.writeInt(-1);
        } else if (uniqueValues != null && uniqueValues.size() > 1 && DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1) < DirectWriter.unsignedBitsRequired((max - min) / gcd)) {
            numBitsPerValue = DirectWriter.unsignedBitsRequired(uniqueValues.size() - 1);
            Object[] sortedUniqueValues = uniqueValues.toArray(new Long[0]);
            Arrays.sort(sortedUniqueValues);
            this.meta.writeInt(sortedUniqueValues.length);
            for (Object v : sortedUniqueValues) {
                this.meta.writeLong((Long)v);
            }
            encode = new HashMap<Object, Integer>();
            for (int i = 0; i < sortedUniqueValues.length; ++i) {
                encode.put(sortedUniqueValues[i], i);
            }
            min = 0L;
            gcd = 1L;
        } else {
            uniqueValues = null;
            boolean bl = doBlocks = minMax.spaceInBits > 0L && (double)blockMinMax.spaceInBits / (double)minMax.spaceInBits <= 0.9;
            if (doBlocks) {
                numBitsPerValue = 255;
                this.meta.writeInt(-16);
            } else {
                numBitsPerValue = DirectWriter.unsignedBitsRequired((max - min) / gcd);
                if (gcd == 1L && min > 0L && DirectWriter.unsignedBitsRequired(max) == DirectWriter.unsignedBitsRequired(max - min)) {
                    min = 0L;
                }
                this.meta.writeInt(-1);
            }
        }
        this.meta.writeByte((byte)numBitsPerValue);
        this.meta.writeLong(min);
        this.meta.writeLong(gcd);
        long startOffset = this.data.getFilePointer();
        this.meta.writeLong(startOffset);
        if (doBlocks) {
            this.writeValuesMultipleBlocks(valuesProducer.getSortedNumeric(field), gcd);
        } else if (numBitsPerValue != 0) {
            this.writeValuesSingleBlock(valuesProducer.getSortedNumeric(field), numValues, numBitsPerValue, min, gcd, encode);
        }
        this.meta.writeLong(this.data.getFilePointer() - startOffset);
        return new long[]{numDocsWithValue, numValues};
    }

    private void writeValuesSingleBlock(SortedNumericDocValues values, long numValues, int numBitsPerValue, long min, long gcd, Map<Long, Integer> encode) throws IOException {
        DirectWriter writer = DirectWriter.getInstance(this.data, numValues, numBitsPerValue);
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                long v = values.nextValue();
                if (encode == null) {
                    writer.add((v - min) / gcd);
                    continue;
                }
                writer.add(encode.get(v).intValue());
            }
            doc = values.nextDoc();
        }
        writer.finish();
    }

    private void writeValuesMultipleBlocks(SortedNumericDocValues values, long gcd) throws IOException {
        long[] buffer = new long[16384];
        GrowableByteArrayDataOutput encodeBuffer = new GrowableByteArrayDataOutput(16384);
        int upTo = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            int count = values.docValueCount();
            for (int i = 0; i < count; ++i) {
                buffer[upTo++] = values.nextValue();
                if (upTo != 16384) continue;
                this.writeBlock(buffer, 16384, gcd, encodeBuffer);
                upTo = 0;
            }
            doc = values.nextDoc();
        }
        if (upTo > 0) {
            this.writeBlock(buffer, upTo, gcd, encodeBuffer);
        }
    }

    private void writeBlock(long[] values, int length, long gcd, GrowableByteArrayDataOutput buffer) throws IOException {
        assert (length > 0);
        long min = values[0];
        long max = values[0];
        for (int i = 1; i < length; ++i) {
            long v = values[i];
            assert (Math.floorMod(values[i] - min, gcd) == 0L);
            min = Math.min(min, v);
            max = Math.max(max, v);
        }
        if (min == max) {
            this.data.writeByte((byte)0);
            this.data.writeLong(min);
        } else {
            int bitsPerValue = DirectWriter.unsignedBitsRequired(max - min);
            buffer.reset();
            assert (buffer.getPosition() == 0);
            DirectWriter w = DirectWriter.getInstance(buffer, length, bitsPerValue);
            for (int i = 0; i < length; ++i) {
                w.add((values[i] - min) / gcd);
            }
            w.finish();
            this.data.writeByte((byte)bitsPerValue);
            this.data.writeLong(min);
            this.data.writeInt(buffer.getPosition());
            this.data.writeBytes(buffer.getBytes(), buffer.getPosition());
        }
    }

    @Override
    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)1);
        BinaryDocValues values = valuesProducer.getBinary(field);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        int numDocsWithField = 0;
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            BytesRef v = values.binaryValue();
            int length = v.length;
            this.data.writeBytes(v.bytes, v.offset, v.length);
            minLength = Math.min(length, minLength);
            maxLength = Math.max(length, maxLength);
            doc = values.nextDoc();
        }
        assert (numDocsWithField <= this.maxDoc);
        this.meta.writeLong(this.data.getFilePointer() - start);
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getBinary(field);
            IndexedDISI.writeBitSet(values, this.data);
            this.meta.writeLong(this.data.getFilePointer() - offset);
        }
        this.meta.writeInt(numDocsWithField);
        this.meta.writeInt(minLength);
        this.meta.writeInt(maxLength);
        if (maxLength > minLength) {
            start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
            long addr = 0L;
            writer.add(addr);
            values = valuesProducer.getBinary(field);
            int doc2 = values.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(addr += (long)values.binaryValue().length);
                doc2 = values.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)2);
        this.doAddSortedField(field, valuesProducer);
    }

    private void doAddSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        SortedDocValues values = valuesProducer.getSorted(field);
        int numDocsWithField = 0;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            doc = values.nextDoc();
        }
        if (numDocsWithField == 0) {
            this.meta.writeLong(-2L);
            this.meta.writeLong(0L);
        } else if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSorted(field);
            IndexedDISI.writeBitSet(values, this.data);
            this.meta.writeLong(this.data.getFilePointer() - offset);
        }
        this.meta.writeInt(numDocsWithField);
        if (values.getValueCount() <= 1) {
            this.meta.writeByte((byte)0);
            this.meta.writeLong(0L);
            this.meta.writeLong(0L);
        } else {
            int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values.getValueCount() - 1);
            this.meta.writeByte((byte)numberOfBitsPerOrd);
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            DirectWriter writer = DirectWriter.getInstance(this.data, numDocsWithField, numberOfBitsPerOrd);
            values = valuesProducer.getSorted(field);
            int doc2 = values.nextDoc();
            while (doc2 != Integer.MAX_VALUE) {
                writer.add(values.ordValue());
                doc2 = values.nextDoc();
            }
            writer.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
        this.addTermsDict(DocValues.singleton(valuesProducer.getSorted(field)));
    }

    private void addTermsDict(SortedSetDocValues values) throws IOException {
        long size = values.getValueCount();
        this.meta.writeVLong(size);
        this.meta.writeInt(4);
        RAMOutputStream addressBuffer = new RAMOutputStream();
        this.meta.writeInt(16);
        long numBlocks = size + 15L >>> 4;
        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressBuffer, numBlocks, 16);
        BytesRefBuilder previous = new BytesRefBuilder();
        long ord = 0L;
        long start = this.data.getFilePointer();
        int maxLength = 0;
        TermsEnum iterator = values.termsEnum();
        BytesRef term = iterator.next();
        while (term != null) {
            if ((ord & 0xFL) == 0L) {
                writer.add(this.data.getFilePointer() - start);
                this.data.writeVInt(term.length);
                this.data.writeBytes(term.bytes, term.offset, term.length);
            } else {
                int prefixLength = StringHelper.bytesDifference(previous.get(), term);
                int suffixLength = term.length - prefixLength;
                assert (suffixLength > 0);
                this.data.writeByte((byte)(Math.min(prefixLength, 15) | Math.min(15, suffixLength - 1) << 4));
                if (prefixLength >= 15) {
                    this.data.writeVInt(prefixLength - 15);
                }
                if (suffixLength >= 16) {
                    this.data.writeVInt(suffixLength - 16);
                }
                this.data.writeBytes(term.bytes, term.offset + prefixLength, term.length - prefixLength);
            }
            maxLength = Math.max(maxLength, term.length);
            previous.copyBytes(term);
            ++ord;
            term = iterator.next();
        }
        writer.finish();
        this.meta.writeInt(maxLength);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        start = this.data.getFilePointer();
        addressBuffer.writeTo(this.data);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.writeTermsIndex(values);
    }

    private void writeTermsIndex(SortedSetDocValues values) throws IOException {
        long size = values.getValueCount();
        this.meta.writeInt(10);
        long start = this.data.getFilePointer();
        long numBlocks = 1L + (size + 1023L >>> 10);
        RAMOutputStream addressBuffer = new RAMOutputStream();
        DirectMonotonicWriter writer = DirectMonotonicWriter.getInstance(this.meta, addressBuffer, numBlocks, 16);
        TermsEnum iterator = values.termsEnum();
        BytesRefBuilder previous = new BytesRefBuilder();
        long offset = 0L;
        long ord = 0L;
        BytesRef term = iterator.next();
        while (term != null) {
            if ((ord & 0x3FFL) == 0L) {
                writer.add(offset);
                int sortKeyLength = ord == 0L ? 0 : StringHelper.sortKeyLength(previous.get(), term);
                offset += (long)sortKeyLength;
                this.data.writeBytes(term.bytes, term.offset, sortKeyLength);
            } else if ((ord & 0x3FFL) == 1023L) {
                previous.copyBytes(term);
            }
            ++ord;
            term = iterator.next();
        }
        writer.add(offset);
        writer.finish();
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
        start = this.data.getFilePointer();
        addressBuffer.writeTo(this.data);
        this.meta.writeLong(start);
        this.meta.writeLong(this.data.getFilePointer() - start);
    }

    @Override
    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)4);
        long[] stats = this.writeValues(field, valuesProducer);
        int numDocsWithField = Math.toIntExact(stats[0]);
        long numValues = stats[1];
        assert (numValues >= (long)numDocsWithField);
        this.meta.writeInt(numDocsWithField);
        if (numValues > (long)numDocsWithField) {
            long start = this.data.getFilePointer();
            this.meta.writeLong(start);
            this.meta.writeVInt(16);
            DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, (long)numDocsWithField + 1L, 16);
            long addr = 0L;
            addressesWriter.add(addr);
            SortedNumericDocValues values = valuesProducer.getSortedNumeric(field);
            int doc = values.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                addressesWriter.add(addr += (long)values.docValueCount());
                doc = values.nextDoc();
            }
            addressesWriter.finish();
            this.meta.writeLong(this.data.getFilePointer() - start);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field, final DocValuesProducer valuesProducer) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeByte((byte)3);
        SortedSetDocValues values = valuesProducer.getSortedSet(field);
        int numDocsWithField = 0;
        long numOrds = 0L;
        int doc = values.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            ++numDocsWithField;
            long ord = values.nextOrd();
            while (ord != -1L) {
                ++numOrds;
                ord = values.nextOrd();
            }
            doc = values.nextDoc();
        }
        if ((long)numDocsWithField == numOrds) {
            this.meta.writeByte((byte)0);
            this.doAddSortedField(field, new EmptyDocValuesProducer(){

                @Override
                public SortedDocValues getSorted(FieldInfo field) throws IOException {
                    return SortedSetSelector.wrap(valuesProducer.getSortedSet(field), SortedSetSelector.Type.MIN);
                }
            });
            return;
        }
        this.meta.writeByte((byte)1);
        assert (numDocsWithField != 0);
        if (numDocsWithField == this.maxDoc) {
            this.meta.writeLong(-1L);
            this.meta.writeLong(0L);
        } else {
            long offset = this.data.getFilePointer();
            this.meta.writeLong(offset);
            values = valuesProducer.getSortedSet(field);
            IndexedDISI.writeBitSet(values, this.data);
            this.meta.writeLong(this.data.getFilePointer() - offset);
        }
        int numberOfBitsPerOrd = DirectWriter.unsignedBitsRequired(values.getValueCount() - 1L);
        this.meta.writeByte((byte)numberOfBitsPerOrd);
        long start = this.data.getFilePointer();
        this.meta.writeLong(start);
        DirectWriter writer = DirectWriter.getInstance(this.data, numOrds, numberOfBitsPerOrd);
        values = valuesProducer.getSortedSet(field);
        int doc2 = values.nextDoc();
        while (doc2 != Integer.MAX_VALUE) {
            long ord = values.nextOrd();
            while (ord != -1L) {
                writer.add(ord);
                ord = values.nextOrd();
            }
            doc2 = values.nextDoc();
        }
        writer.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.meta.writeInt(numDocsWithField);
        start = this.data.getFilePointer();
        this.meta.writeLong(start);
        this.meta.writeVInt(16);
        DirectMonotonicWriter addressesWriter = DirectMonotonicWriter.getInstance(this.meta, this.data, numDocsWithField + 1, 16);
        long addr = 0L;
        addressesWriter.add(addr);
        values = valuesProducer.getSortedSet(field);
        int doc3 = values.nextDoc();
        while (doc3 != Integer.MAX_VALUE) {
            values.nextOrd();
            ++addr;
            while (values.nextOrd() != -1L) {
                ++addr;
            }
            addressesWriter.add(addr);
            doc3 = values.nextDoc();
        }
        addressesWriter.finish();
        this.meta.writeLong(this.data.getFilePointer() - start);
        this.addTermsDict(values);
    }

    private static class MinMaxTracker {
        long min;
        long max;
        long numValues;
        long spaceInBits;

        MinMaxTracker() {
            this.reset();
            this.spaceInBits = 0L;
        }

        private void reset() {
            this.min = Long.MAX_VALUE;
            this.max = Long.MIN_VALUE;
            this.numValues = 0L;
        }

        void update(long v) {
            this.min = Math.min(this.min, v);
            this.max = Math.max(this.max, v);
            ++this.numValues;
        }

        void finish() {
            if (this.max > this.min) {
                this.spaceInBits += (long)DirectWriter.unsignedBitsRequired(this.max - this.min) * this.numValues;
            }
        }

        void nextBlock() {
            this.finish();
            this.reset();
        }
    }
}

