/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;

public class ImageRef {
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String DEFAULT_REGISTRY_URL = "https://index.docker.io/v1/";
    private final String registryUrl;
    private final String registry;
    private final String image;
    private final String tag;

    public ImageRef(String image) {
        int lastAt = image.lastIndexOf(64);
        int lastColon = image.lastIndexOf(58);
        if (lastAt >= 0) {
            this.image = image;
            this.tag = null;
        } else if (lastColon < 0) {
            this.image = image;
            this.tag = null;
        } else {
            String tag = image.substring(lastColon + 1);
            if (tag.indexOf(47) < 0) {
                this.image = image.substring(0, lastColon);
                this.tag = tag;
            } else {
                this.image = image;
                this.tag = null;
            }
        }
        String[] parts = image.split("/", 2);
        if (parts.length > 1 && ImageRef.isRegistry(parts[0])) {
            this.registry = parts[0];
            this.registryUrl = ImageRef.parseRegistryUrl(parts[0]);
        } else {
            this.registry = DEFAULT_REGISTRY;
            this.registryUrl = DEFAULT_REGISTRY_URL;
        }
    }

    private static boolean isRegistry(String part) {
        return part.contains(".");
    }

    public String getImage() {
        return this.image;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRegistryName() {
        return this.registry;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("registry", (Object)this.registry).add("image", (Object)this.image).add("tag", (Object)this.tag).toString();
    }

    @VisibleForTesting
    static String parseRegistryUrl(String url) {
        if (url.equals(DEFAULT_REGISTRY) || url.equals("index.docker.io")) {
            return DEFAULT_REGISTRY_URL;
        }
        if (url.matches("(^|(\\w+)\\.)gcr\\.io$") || url.equals("gcr.kubernetes.io")) {
            return "https://" + url;
        }
        if (url.equals("quay.io")) {
            return "quay.io";
        }
        if (!url.contains("http://") && !url.contains("https://")) {
            return "https://" + url;
        }
        return url;
    }
}

