/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.MaskType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.NullableObjsType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.ObjsType;
import com.google.javascript.jscomp.newtypes.QualifiedName;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import com.google.javascript.jscomp.newtypes.TypeWithPropertiesStatics;
import com.google.javascript.jscomp.newtypes.UnionType;
import com.google.javascript.jscomp.newtypes.UniqueNameGenerator;
import com.google.javascript.rhino.FunctionTypeI;
import com.google.javascript.rhino.ObjectTypeI;
import com.google.javascript.rhino.TypeI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public abstract class JSType
implements TypeI {
    protected static final int BOTTOM_MASK = 0;
    protected static final int TYPEVAR_MASK = 1;
    protected static final int NON_SCALAR_MASK = 2;
    protected static final int ENUM_MASK = 4;
    protected static final int TRUE_MASK = 8;
    protected static final int FALSE_MASK = 16;
    protected static final int NULL_MASK = 32;
    protected static final int NUMBER_MASK = 64;
    protected static final int STRING_MASK = 128;
    protected static final int UNDEFINED_MASK = 256;
    protected static final int END_MASK = 512;
    protected static final int TRUTHY_MASK = 512;
    protected static final int FALSY_MASK = 1024;
    protected static final int UNKNOWN_MASK = Integer.MAX_VALUE;
    protected static final int TOP_MASK = -1;
    protected static final int BOOLEAN_MASK = 24;
    protected static final int TOP_SCALAR_MASK = 504;
    private static JSTypes commonTypes = null;
    static final Map<String, JSType> MAP_TO_UNKNOWN = new Map<String, JSType>(){

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object k) {
            return true;
        }

        @Override
        public boolean containsValue(Object v) {
            return v == UNKNOWN;
        }

        @Override
        public Set<Map.Entry<String, JSType>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSType get(Object k) {
            return UNKNOWN;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSType put(String k, JSType v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends JSType> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public JSType remove(Object k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<JSType> values() {
            return ImmutableSet.of((Object)UNKNOWN);
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }
    };
    public static boolean mockToString = false;
    public static final JSType BOOLEAN = new MaskType(24);
    public static final JSType BOTTOM = new MaskType(0);
    public static final JSType FALSE_TYPE = new MaskType(16);
    public static final JSType FALSY = new MaskType(1024);
    public static final JSType NULL = new MaskType(32);
    public static final JSType NUMBER = new MaskType(64);
    public static final JSType STRING = new MaskType(128);
    public static final JSType TOP = new MaskType(-1);
    public static final JSType TOP_SCALAR = JSType.makeType(504);
    public static final JSType TRUE_TYPE = new MaskType(8);
    public static final JSType TRUTHY = new MaskType(512);
    public static final JSType UNDEFINED = new MaskType(256);
    public static final JSType UNKNOWN = new MaskType(Integer.MAX_VALUE);
    public static final JSType TOP_OBJECT = JSType.fromObjectType(ObjectType.TOP_OBJECT);
    public static final JSType TOP_STRUCT = JSType.fromObjectType(ObjectType.TOP_STRUCT);
    public static final JSType TOP_DICT = JSType.fromObjectType(ObjectType.TOP_DICT);
    public static final JSType NULL_OR_UNDEF = new MaskType(288);
    public static final JSType NUM_OR_STR = new MaskType(192);
    private static final JSType ALMOST_TOP = JSType.makeType(506, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.TOP_OBJECT), null, (ImmutableSet<EnumType>)ImmutableSet.of());
    private static final Joiner PIPE_JOINER = Joiner.on((String)"|");

    private static JSType makeType(int mask, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
        mask = ((ImmutableSet)Preconditions.checkNotNull(enums)).isEmpty() ? (mask &= 0xFFFFFFFB) : (mask |= 4);
        mask = ((ImmutableSet)Preconditions.checkNotNull(objs)).isEmpty() ? (mask &= 0xFFFFFFFD) : (mask |= 2);
        if (objs.isEmpty() && typeVar == null && enums.isEmpty()) {
            return MaskType.make(mask);
        }
        if (!JSType.isInhabitable(objs)) {
            return BOTTOM;
        }
        if (mask == 2) {
            return new ObjsType(objs);
        }
        if (mask == 34) {
            return new NullableObjsType(objs);
        }
        return new UnionType(mask, objs, typeVar, enums);
    }

    private static JSType makeType(int mask) {
        return JSType.makeType(mask, (ImmutableSet<ObjectType>)ImmutableSet.of(), null, (ImmutableSet<EnumType>)ImmutableSet.of());
    }

    protected abstract int getMask();

    abstract ImmutableSet<ObjectType> getObjs();

    protected abstract String getTypeVar();

    protected abstract ImmutableSet<EnumType> getEnums();

    static JSType fromFunctionType(FunctionType fn, NominalType fnNominal) {
        return JSType.makeType(2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)ObjectType.fromFunction(fn, fnNominal)), null, (ImmutableSet<EnumType>)ImmutableSet.of());
    }

    public static JSType fromObjectType(ObjectType obj) {
        return JSType.makeType(2, (ImmutableSet<ObjectType>)ImmutableSet.of((Object)obj), null, (ImmutableSet<EnumType>)ImmutableSet.of());
    }

    public static JSType fromTypeVar(String typevarName) {
        return JSType.makeType(1, (ImmutableSet<ObjectType>)ImmutableSet.of(), typevarName, (ImmutableSet<EnumType>)ImmutableSet.of());
    }

    static JSType fromEnum(EnumType e) {
        return JSType.makeType(4, (ImmutableSet<ObjectType>)ImmutableSet.of(), null, (ImmutableSet<EnumType>)ImmutableSet.of((Object)e));
    }

    boolean isValidType() {
        if (this.isUnknown() || this.isTop()) {
            return true;
        }
        if ((this.getMask() & 2) != 0 && this.getObjs().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 2) == 0 && !this.getObjs().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 4) != 0 && this.getEnums().isEmpty()) {
            return false;
        }
        if ((this.getMask() & 4) == 0 && !this.getEnums().isEmpty()) {
            return false;
        }
        return (this.getMask() & 1) != 0 == (this.getTypeVar() != null);
    }

    public boolean isTop() {
        return -1 == this.getMask();
    }

    @Override
    public boolean isBottom() {
        return 0 == this.getMask();
    }

    public boolean isUndefined() {
        return 256 == this.getMask();
    }

    public boolean isUnknown() {
        return Integer.MAX_VALUE == this.getMask();
    }

    public boolean isTrueOrTruthy() {
        return 512 == this.getMask() || 8 == this.getMask();
    }

    private boolean hasTruthyMask() {
        return 512 == this.getMask();
    }

    public boolean isFalseOrFalsy() {
        return 1024 == this.getMask() || 16 == this.getMask();
    }

    public boolean isAnyTruthyType() {
        int mask = this.getMask();
        int truthyMask = 522;
        return mask != 0 && (mask | truthyMask) == truthyMask;
    }

    public boolean isAnyFalsyType() {
        int mask = this.getMask();
        int falsyMask = 1328;
        return mask != 0 && (mask | falsyMask) == falsyMask;
    }

    private boolean hasFalsyMask() {
        return 1024 == this.getMask();
    }

    public boolean isBoolean() {
        return (this.getMask() & 0xFFFFFFE7) == 0 && (this.getMask() & 0x18) != 0;
    }

    public boolean isString() {
        return 128 == this.getMask();
    }

    public boolean isNumber() {
        return 64 == this.getMask();
    }

    public boolean isNullOrUndef() {
        int nullUndefMask = 288;
        return this.getMask() != 0 && (this.getMask() | nullUndefMask) == nullUndefMask;
    }

    public boolean isScalar() {
        return this.getMask() == 64 || this.getMask() == 128 || this.getMask() == 32 || this.getMask() == 256 || this.isBoolean();
    }

    private static boolean isInhabitable(Set<ObjectType> objs) {
        for (ObjectType obj : objs) {
            if (obj.isInhabitable()) continue;
            return false;
        }
        return true;
    }

    public static void setCommonTypes(JSTypes commonTypes) {
        JSType.commonTypes = commonTypes;
    }

    boolean hasScalar() {
        return (this.getMask() & 0x1F8) != 0 || EnumType.hasScalar(this.getEnums());
    }

    public boolean hasNonScalar() {
        return !this.getObjs().isEmpty() || EnumType.hasNonScalar(this.getEnums());
    }

    public boolean isNullable() {
        return (this.getMask() & 0x20) != 0;
    }

    public boolean isTypeVariable() {
        return this.getMask() == 1;
    }

    public boolean hasTypeVariable() {
        return (this.getMask() & 1) != 0;
    }

    public boolean isStruct() {
        if (this.isUnknown()) {
            return false;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0, (String)"Expected object type but found %s", (Object[])new Object[]{this});
        for (ObjectType objType : this.getObjs()) {
            if (objType.isStruct()) continue;
            return false;
        }
        return true;
    }

    public boolean mayBeStruct() {
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isStruct()) continue;
            return true;
        }
        return false;
    }

    public boolean isLoose() {
        ImmutableSet<ObjectType> objs = this.getObjs();
        return objs.size() == 1 && ((ObjectType)Iterables.getOnlyElement(objs)).isLoose();
    }

    public boolean isDict() {
        if (this.isUnknown()) {
            return false;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0);
        for (ObjectType objType : this.getObjs()) {
            if (objType.isDict()) continue;
            return false;
        }
        return true;
    }

    public JSType getIndexType() {
        if (this.getMask() != 2) {
            return null;
        }
        JSType result = TOP;
        boolean foundIObject = false;
        for (ObjectType objType : this.getObjs()) {
            JSType tmp = objType.getNominalType().getIndexType();
            if (tmp == null) {
                return null;
            }
            foundIObject = true;
            result = JSType.meet(result, tmp);
        }
        return foundIObject ? result : null;
    }

    public JSType getIndexedType() {
        if ((this.getMask() & 2) == 0) {
            return null;
        }
        JSType result = BOTTOM;
        for (ObjectType objType : this.getObjs()) {
            JSType tmp = objType.getNominalType().getIndexedType();
            if (tmp == null) {
                return null;
            }
            result = JSType.join(result, tmp);
        }
        return result.isBottom() ? null : result;
    }

    public boolean mayBeDict() {
        for (ObjectType objType : this.getObjs()) {
            if (!objType.isDict()) continue;
            return true;
        }
        return false;
    }

    public boolean isEnumElement() {
        return this.getMask() == 4 && this.getEnums().size() == 1;
    }

    public boolean isUnion() {
        if (this.isBottom() || this.isTop() || this.isUnknown() || this.isScalar() || this.isTypeVariable() || this.isEnumElement() || this.hasTruthyMask() || this.hasFalsyMask()) {
            return false;
        }
        return this.getMask() != 2 || this.getObjs().size() != 1;
    }

    public boolean isFunctionWithProperties() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.isFunctionWithProperties();
    }

    public boolean isNamespace() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj != null && obj.isNamespace();
    }

    public JSType getEnumeratedType() {
        return this.isEnumElement() ? ((EnumType)Iterables.getOnlyElement(this.getEnums())).getEnumeratedType() : null;
    }

    public JSType autobox() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        int mask = this.getMask();
        if ((mask & 0xDC) == 0) {
            return this;
        }
        switch (mask) {
            case 64: {
                return commonTypes.getNumberInstance();
            }
            case 8: 
            case 16: 
            case 24: {
                return commonTypes.getBooleanInstance();
            }
            case 128: {
                return commonTypes.getStringInstance();
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.getObjs());
        if ((mask & 0x40) != 0) {
            builder.add((Object)commonTypes.getNumberInstanceObjType());
        }
        if ((mask & 0x80) != 0) {
            builder.add((Object)commonTypes.getStringInstanceObjType());
        }
        if ((mask & 0x18) != 0) {
            builder.add((Object)commonTypes.getBooleanInstanceObjType());
        }
        JSType result = JSType.makeType(mask & 0xFFFFFF27, (ImmutableSet<ObjectType>)builder.build(), this.getTypeVar(), (ImmutableSet<EnumType>)ImmutableSet.of());
        for (EnumType e : this.getEnums()) {
            result = JSType.join(result, e.getEnumeratedType().autobox());
        }
        return result;
    }

    static JSType nullAcceptingJoin(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.join(t1, t2);
    }

    public static JSType join(JSType lhs, JSType rhs) {
        Preconditions.checkNotNull((Object)lhs);
        Preconditions.checkNotNull((Object)rhs);
        if (lhs.isTop() || rhs.isTop()) {
            return TOP;
        }
        if (lhs.isUnknown() || rhs.isUnknown()) {
            return UNKNOWN;
        }
        if (lhs.isBottom()) {
            return rhs;
        }
        if (rhs.isBottom()) {
            return lhs;
        }
        if (lhs.hasTruthyMask() || lhs.hasFalsyMask() || rhs.hasTruthyMask() || rhs.hasFalsyMask()) {
            return UNKNOWN;
        }
        if (lhs.getTypeVar() != null && rhs.getTypeVar() != null && !lhs.getTypeVar().equals(rhs.getTypeVar())) {
            return UNKNOWN;
        }
        int newMask = lhs.getMask() | rhs.getMask();
        ImmutableSet<ObjectType> newObjs = ObjectType.joinSets(lhs.getObjs(), rhs.getObjs());
        String newTypevar = lhs.getTypeVar() != null ? lhs.getTypeVar() : rhs.getTypeVar();
        ImmutableSet<EnumType> newEnums = EnumType.union(lhs.getEnums(), rhs.getEnums());
        if (newEnums.isEmpty()) {
            return JSType.makeType(newMask, newObjs, newTypevar, (ImmutableSet<EnumType>)ImmutableSet.of());
        }
        JSType tmpJoin = JSType.makeType(newMask & 0xFFFFFFFB, newObjs, newTypevar, (ImmutableSet<EnumType>)ImmutableSet.of());
        return JSType.makeType(newMask, newObjs, newTypevar, EnumType.normalizeForJoin(newEnums, tmpJoin));
    }

    public JSType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (this.isTop() || this.isUnknown() || this.getObjs().isEmpty() && this.getTypeVar() == null || concreteTypes.isEmpty()) {
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            builder.add((Object)obj.substituteGenerics(concreteTypes));
        }
        JSType current = JSType.makeType(this.getMask() & 0xFFFFFFFE, (ImmutableSet<ObjectType>)builder.build(), null, this.getEnums());
        if ((this.getMask() & 1) != 0) {
            current = JSType.join(current, concreteTypes.containsKey(this.getTypeVar()) ? concreteTypes.get(this.getTypeVar()) : JSType.fromTypeVar(this.getTypeVar()));
        }
        return current;
    }

    public JSType substituteGenericsWithUnknown() {
        return this.substituteGenerics(MAP_TO_UNKNOWN);
    }

    private static void updateTypemap(Multimap<String, JSType> typeMultimap, String typeParam, JSType type) {
        Preconditions.checkNotNull((Object)type);
        LinkedHashSet<JSType> typesToRemove = new LinkedHashSet<JSType>();
        for (JSType other : typeMultimap.get((Object)typeParam)) {
            if (type.isUnknown()) {
                typesToRemove.add(other);
                continue;
            }
            if (other.isUnknown()) {
                type = null;
                break;
            }
            if (type.isLoose()) {
                type = null;
                break;
            }
            if (other.isLoose()) {
                typesToRemove.add(other);
                continue;
            }
            JSType unified = JSType.unifyUnknowns(type, other);
            if (unified != null) {
                typesToRemove.add(other);
                type = unified;
                continue;
            }
            if (other.isSubtypeOf(type, SubtypeCache.create())) {
                typesToRemove.add(other);
                continue;
            }
            if (!type.isSubtypeOf(other, SubtypeCache.create())) continue;
            type = null;
            break;
        }
        for (JSType typeToRemove : typesToRemove) {
            typeMultimap.remove((Object)typeParam, (Object)typeToRemove);
        }
        if (type != null) {
            typeMultimap.put((Object)typeParam, (Object)type);
        }
    }

    private static int promoteBoolean(int mask) {
        if ((mask & 0x18) != 0) {
            return mask | 8 | 0x10;
        }
        return mask;
    }

    static JSType unifyUnknowns(JSType t1, JSType t2) {
        int t2Mask;
        Preconditions.checkNotNull((Object)t1);
        Preconditions.checkNotNull((Object)t2);
        if (t1.isUnknown() || t1.isLoose()) {
            return t2;
        }
        if (t2.isUnknown() || t2.isLoose()) {
            return t1;
        }
        if (t1.isTop() && t2.isTop()) {
            return TOP;
        }
        if (t1.isTop() || t2.isTop()) {
            return null;
        }
        if (!t1.getEnums().equals(t2.getEnums())) {
            return null;
        }
        ImmutableSet<EnumType> newEnums = t1.getEnums();
        int t1Mask = JSType.promoteBoolean(t1.getMask());
        if (t1Mask != (t2Mask = JSType.promoteBoolean(t2.getMask())) || !Objects.equals(t1.getTypeVar(), t2.getTypeVar())) {
            return null;
        }
        if ((t1Mask & 2) == 0) {
            return t1;
        }
        if (t1.getObjs().size() != t2.getObjs().size()) {
            return null;
        }
        LinkedHashSet<ObjectType> ununified = new LinkedHashSet<ObjectType>((Collection<ObjectType>)t2.getObjs());
        LinkedHashSet<ObjectType> unifiedObjs = new LinkedHashSet<ObjectType>();
        UnmodifiableIterator unmodifiableIterator = t1.getObjs().iterator();
        while (unmodifiableIterator.hasNext()) {
            ObjectType objType1;
            ObjectType unified = objType1 = (ObjectType)unmodifiableIterator.next();
            boolean hasUnified = false;
            for (ObjectType objType2 : t2.getObjs()) {
                ObjectType tmp = ObjectType.unifyUnknowns(unified, objType2);
                if (tmp == null) continue;
                hasUnified = true;
                ununified.remove(objType2);
                unified = tmp;
            }
            if (!hasUnified) {
                return null;
            }
            unifiedObjs.add(unified);
        }
        if (!ununified.isEmpty()) {
            return null;
        }
        return JSType.makeType(t1Mask, (ImmutableSet<ObjectType>)ImmutableSet.copyOf(unifiedObjs), t1.getTypeVar(), newEnums);
    }

    public boolean unifyWith(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        return this.unifyWithSubtype(other, typeParameters, typeMultimap, SubtypeCache.create());
    }

    boolean unifyWithSubtype(JSType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        Preconditions.checkNotNull((Object)other);
        if (this.isUnknown() || this.isTop()) {
            return true;
        }
        if (this.getMask() == 1 && typeParameters.contains(this.getTypeVar())) {
            JSType.updateTypemap(typeMultimap, this.getTypeVar(), other);
            return true;
        }
        if (other.isUnknown()) {
            return true;
        }
        if (other.isTop()) {
            return false;
        }
        Object ununifiedEnums = ImmutableSet.of();
        if (!other.getEnums().isEmpty()) {
            ununifiedEnums = new LinkedHashSet();
            for (Object e : other.getEnums()) {
                if (JSType.fromEnum((EnumType)e).isSubtypeOf(this, SubtypeCache.create())) continue;
                ununifiedEnums.add(e);
            }
        }
        LinkedHashSet<ObjectType> ununifiedObjs = new LinkedHashSet<ObjectType>((Collection<ObjectType>)other.getObjs());
        for (ObjectType targetObj : this.getObjs()) {
            for (ObjectType sourceObj : other.getObjs()) {
                if (!targetObj.unifyWithSubtype(sourceObj, typeParameters, typeMultimap, subSuperMap)) continue;
                ununifiedObjs.remove(sourceObj);
            }
        }
        String thisTypevar = this.getTypeVar();
        String otherTypevar = other.getTypeVar();
        if (thisTypevar == null || !typeParameters.contains(thisTypevar)) {
            return ununifiedObjs.isEmpty() && ununifiedEnums.isEmpty() && (otherTypevar == null || otherTypevar.equals(thisTypevar)) && this.getMask() == (this.getMask() | other.getMask() & 0xFFFFFFFB);
        }
        int thisScalarBits = this.getMask() & 0xFFFFFFFD & 0xFFFFFFFE;
        int templateMask = other.getMask() & ~thisScalarBits;
        if (ununifiedObjs.isEmpty()) {
            templateMask &= 0xFFFFFFFD;
        }
        if (templateMask == 0) {
            return ununifiedObjs.isEmpty() && ununifiedEnums.isEmpty();
        }
        JSType templateType = JSType.makeType(JSType.promoteBoolean(templateMask), (ImmutableSet<ObjectType>)ImmutableSet.copyOf(ununifiedObjs), otherTypevar, (ImmutableSet<EnumType>)ImmutableSet.copyOf((Collection)ununifiedEnums));
        JSType.updateTypemap(typeMultimap, this.getTypeVar(), templateType);
        return true;
    }

    public JSType specialize(JSType other) {
        JSType t = this.specializeHelper(other);
        if (t.isBottom() && (this.isLoose() || other.isLoose()) && !(t = this.autobox().specializeHelper(other.autobox())).isBottom()) {
            return this;
        }
        return t;
    }

    private JSType specializeHelper(JSType other) {
        String newTypevar;
        if (other.isTop() || other.isUnknown() || this == other) {
            return this;
        }
        if (other.hasTruthyMask()) {
            return this.makeTruthy();
        }
        if (this.hasTruthyMask()) {
            return other.makeTruthy();
        }
        if (other.hasFalsyMask()) {
            return this.makeFalsy();
        }
        Preconditions.checkState((!this.hasFalsyMask() ? 1 : 0) != 0);
        if (this.isTop()) {
            return other;
        }
        if (this.isUnknown()) {
            NominalType otherNt = other.getNominalTypeIfSingletonObj();
            return otherNt != null && otherNt.isBuiltinObject() ? other.withLoose() : other;
        }
        int newMask = this.getMask() & other.getMask();
        if (Objects.equals(this.getTypeVar(), other.getTypeVar())) {
            newTypevar = this.getTypeVar();
        } else {
            if (this.getTypeVar() != null && other.getTypeVar() == null) {
                return other;
            }
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(newMask, this.getMask() | other.getMask(), ObjectType.specializeSet(this.getObjs(), other.getObjs()), newTypevar, this.getObjs(), other.getObjs(), this.getEnums(), other.getEnums());
    }

    public static JSType meet(JSType lhs, JSType rhs) {
        JSType t = JSType.meetHelper(lhs, rhs);
        if (t.isBottom() && (lhs.isLoose() || rhs.isLoose()) && !(t = JSType.meetHelper(lhs.autobox(), rhs.autobox())).isBottom()) {
            if (!lhs.isLoose()) {
                return lhs;
            }
            Preconditions.checkState((!rhs.isLoose() ? 1 : 0) != 0, (String)"Two loose types %s and %s that meet to bottom, meet to non-bottom after autoboxing.", (Object[])new Object[]{lhs.toString(), rhs.toString()});
            return rhs;
        }
        return t;
    }

    private static JSType meetHelper(JSType lhs, JSType rhs) {
        String newTypevar;
        if (lhs.isTop()) {
            return rhs;
        }
        if (rhs.isTop()) {
            return lhs;
        }
        if (lhs.isUnknown()) {
            return rhs;
        }
        if (rhs.isUnknown()) {
            return lhs;
        }
        if (lhs.isBottom() || rhs.isBottom()) {
            return BOTTOM;
        }
        int newMask = lhs.getMask() & rhs.getMask();
        if (Objects.equals(lhs.getTypeVar(), rhs.getTypeVar())) {
            newTypevar = lhs.getTypeVar();
        } else {
            newTypevar = null;
            newMask &= 0xFFFFFFFE;
        }
        return JSType.meetEnums(newMask, lhs.getMask() | rhs.getMask(), ObjectType.meetSets(lhs.getObjs(), rhs.getObjs()), newTypevar, lhs.getObjs(), rhs.getObjs(), lhs.getEnums(), rhs.getEnums());
    }

    private static JSType meetEnums(int newMask, int unionMask, ImmutableSet<ObjectType> newObjs, String newTypevar, ImmutableSet<ObjectType> objs1, ImmutableSet<ObjectType> objs2, ImmutableSet<EnumType> enums1, ImmutableSet<EnumType> enums2) {
        if (Objects.equals(enums1, enums2)) {
            return JSType.makeType(newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, enums1);
        }
        ImmutableSet.Builder enumBuilder = ImmutableSet.builder();
        ImmutableSet<EnumType> allEnums = EnumType.union(enums1, enums2);
        for (EnumType e : allEnums) {
            if (enums1 != null && enums1.contains((Object)e) && enums2 != null && enums2.contains((Object)e)) {
                enumBuilder.add((Object)e);
                continue;
            }
            JSType enumeratedType = e.getEnumeratedType();
            if (enumeratedType.isUnknown()) {
                enumBuilder.add((Object)e);
                continue;
            }
            if (enumeratedType.getMask() != 2) {
                if ((enumeratedType.getMask() & unionMask) == 0) continue;
                enumBuilder.add((Object)e);
                newMask &= ~enumeratedType.getMask();
                continue;
            }
            if (objs1.isEmpty() && objs2.isEmpty()) continue;
            LinkedHashSet<ObjectType> objsToRemove = new LinkedHashSet<ObjectType>();
            ObjectType enumObj = (ObjectType)Iterables.getOnlyElement(enumeratedType.getObjs());
            for (ObjectType obj1 : objs1) {
                if (!enumObj.isSubtypeOf(obj1, SubtypeCache.create())) continue;
                enumBuilder.add((Object)e);
                objsToRemove.add(obj1);
            }
            for (ObjectType obj2 : objs2) {
                if (!enumObj.isSubtypeOf(obj2, SubtypeCache.create())) continue;
                enumBuilder.add((Object)e);
                objsToRemove.add(obj2);
            }
            if (objsToRemove.isEmpty()) continue;
            newObjs = Sets.difference((Set)newObjs, objsToRemove).immutableCopy();
        }
        return JSType.makeType(newMask, (ImmutableSet<ObjectType>)newObjs, newTypevar, (ImmutableSet<EnumType>)enumBuilder.build());
    }

    public static boolean haveCommonSubtype(JSType lhs, JSType rhs) {
        return lhs.isBottom() || rhs.isBottom() || !JSType.meet(lhs, rhs).isBottom();
    }

    private JSType makeTruthy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return JSType.makeType(this.getMask() & 0xFFFFFFDF & 0xFFFFFFEF & 0xFFFFFEFF, this.getObjs(), this.getTypeVar(), this.getEnums());
    }

    private JSType makeFalsy() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        return JSType.makeType(this.getMask() & 0xFFFFFFF7 & 0xFFFFFFFD, (ImmutableSet<ObjectType>)ImmutableSet.of(), this.getTypeVar(), this.getEnums());
    }

    public static JSType plus(JSType lhs, JSType rhs) {
        if (!lhs.isUnknown() && !lhs.isBottom() && lhs.isSubtypeOf(STRING) || !rhs.isUnknown() && !rhs.isBottom() && rhs.isSubtypeOf(STRING)) {
            return STRING;
        }
        if (lhs.isUnknown() || lhs.isTop() || rhs.isUnknown() || rhs.isTop()) {
            return UNKNOWN;
        }
        int newtype = (lhs.getMask() | rhs.getMask()) & 0x80;
        if ((lhs.getMask() & 0xFFFFFF7F) != 0 && (rhs.getMask() & 0xFFFFFF7F) != 0) {
            newtype |= 0x40;
        }
        return JSType.makeType(newtype);
    }

    public JSType negate() {
        if (this.isTop() || this.isUnknown()) {
            return this;
        }
        if (this.isTrueOrTruthy()) {
            return FALSY;
        }
        if (this.isFalseOrFalsy()) {
            return TRUTHY;
        }
        return UNKNOWN;
    }

    public JSType toBoolean() {
        if (this.isTrueOrTruthy()) {
            return TRUE_TYPE;
        }
        if (this.isFalseOrFalsy()) {
            return FALSE_TYPE;
        }
        return BOOLEAN;
    }

    public boolean isNonLooseSubtypeOf(JSType other) {
        return this.isSubtypeOfHelper(false, other, SubtypeCache.create());
    }

    @Override
    public boolean isSubtypeOf(TypeI other) {
        return this.isSubtypeOf(other, SubtypeCache.create());
    }

    boolean isSubtypeOf(TypeI other, SubtypeCache subSuperMap) {
        if (this == other) {
            return true;
        }
        JSType type2 = (JSType)other;
        if (this.isLoose() || type2.isLoose()) {
            return this.autobox().isSubtypeOfHelper(true, type2.autobox(), subSuperMap);
        }
        return this.isSubtypeOfHelper(true, type2, subSuperMap);
    }

    private boolean isSubtypeOfHelper(boolean keepLoosenessOfThis, JSType other, SubtypeCache subSuperMap) {
        if (this.isUnknown() || other.isUnknown() || other.isTop()) {
            return true;
        }
        if (this.hasTruthyMask()) {
            return !other.makeTruthy().isBottom();
        }
        if (this.hasFalsyMask()) {
            return !other.makeFalsy().isBottom();
        }
        if (!EnumType.areSubtypes(this, other, subSuperMap)) {
            return false;
        }
        int mask = this.getMask() & 0xFFFFFFFB;
        if ((mask | other.getMask()) != other.getMask()) {
            return false;
        }
        if (this.getTypeVar() != null && !this.getTypeVar().equals(other.getTypeVar())) {
            return false;
        }
        if (this.getObjs().isEmpty()) {
            return true;
        }
        return ObjectType.isUnionSubtype(keepLoosenessOfThis, this.getObjs(), other.getObjs(), subSuperMap);
    }

    public JSType removeType(JSType other) {
        int otherMask = other.getMask();
        Preconditions.checkState((!other.isTop() && !other.isUnknown() && (otherMask & 1) == 0 && (otherMask & 4) == 0 ? 1 : 0) != 0, (String)"Requested invalid type to remove: %s", (Object[])new Object[]{other});
        if (this.isUnknown()) {
            return this;
        }
        if (this.isTop()) {
            return ALMOST_TOP.removeType(other);
        }
        int newMask = this.getMask() & ~otherMask;
        if ((otherMask & 2) == 0) {
            return newMask == this.getMask() ? this : JSType.makeType(newMask, this.getObjs(), this.getTypeVar(), this.getEnums());
        }
        Preconditions.checkState((other.getObjs().size() == 1 ? 1 : 0) != 0, (String)"Invalid type to remove: %s", (Object[])new Object[]{other});
        ObjectType otherObj = (ObjectType)Iterables.getOnlyElement(other.getObjs());
        ImmutableSet.Builder objsBuilder = ImmutableSet.builder();
        for (ObjectType obj : this.getObjs()) {
            if (obj.isSubtypeOf(otherObj, SubtypeCache.create())) continue;
            objsBuilder.add((Object)obj);
        }
        ImmutableSet.Builder enumBuilder = ImmutableSet.builder();
        for (EnumType e : this.getEnums()) {
            if (e.getEnumeratedType().isSubtypeOf(other, SubtypeCache.create())) continue;
            enumBuilder.add((Object)e);
        }
        return JSType.makeType(newMask, (ImmutableSet<ObjectType>)objsBuilder.build(), this.getTypeVar(), (ImmutableSet<EnumType>)enumBuilder.build());
    }

    public JSType withFunction(FunctionType ft, NominalType fnNominal) {
        Preconditions.checkNotNull((Object)ft);
        ObjectType ot = this.getObjTypeIfSingletonObj();
        Preconditions.checkNotNull((Object)ot);
        Preconditions.checkState((this.getMask() == 2 ? 1 : 0) != 0);
        return JSType.fromObjectType(ot.withFunction(ft, fnNominal));
    }

    public boolean isSingletonObj() {
        return this.getMask() == 2 && this.getObjs().size() == 1;
    }

    boolean isSingletonObjWithNull() {
        return this.getMask() == 34 && this.getObjs().size() == 1;
    }

    ObjectType getObjTypeIfSingletonObj() {
        return this.isSingletonObj() ? (ObjectType)Iterables.getOnlyElement(this.getObjs()) : null;
    }

    public FunctionType getFunTypeIfSingletonObj() {
        ObjectType obj = this.getObjTypeIfSingletonObj();
        return obj == null ? null : obj.getFunType();
    }

    public FunctionType getFunType() {
        for (ObjectType obj : this.getObjs()) {
            FunctionType ft = obj.getFunType();
            if (ft == null) continue;
            return ft;
        }
        return null;
    }

    public NominalType getNominalTypeIfSingletonObj() {
        return this.isSingletonObj() ? ((ObjectType)Iterables.getOnlyElement(this.getObjs())).getNominalType() : null;
    }

    public boolean isNonClassyObject() {
        NominalType nt = this.getNominalTypeIfSingletonObj();
        return nt != null && !nt.isClassy();
    }

    public boolean isInterfaceDefinition() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        return ft != null && ft.isInterfaceDefinition();
    }

    public JSType withLoose() {
        if (this.getObjs().isEmpty()) {
            Preconditions.checkState((!this.getEnums().isEmpty() ? 1 : 0) != 0);
            return this;
        }
        return JSType.makeType(this.getMask(), ObjectType.withLooseObjects(this.getObjs()), this.getTypeVar(), this.getEnums());
    }

    public JSType getProp(QualifiedName qname) {
        if (this.isBottom() || this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() || !this.getEnums().isEmpty() ? 1 : 0) != 0, (String)"Can't getProp of type %s", (Object[])new Object[]{this});
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getProp(this.getObjs(), qname), TypeWithPropertiesStatics.getProp(this.getEnums(), qname));
    }

    public JSType getDeclaredProp(QualifiedName qname) {
        if (this.isUnknown()) {
            return UNKNOWN;
        }
        Preconditions.checkState((!this.getObjs().isEmpty() || !this.getEnums().isEmpty() ? 1 : 0) != 0);
        return JSType.nullAcceptingJoin(TypeWithPropertiesStatics.getDeclaredProp(this.getObjs(), qname), TypeWithPropertiesStatics.getDeclaredProp(this.getEnums(), qname));
    }

    public boolean mayHaveProp(QualifiedName qname) {
        return TypeWithPropertiesStatics.mayHaveProp(this.getObjs(), qname) || TypeWithPropertiesStatics.mayHaveProp(this.getEnums(), qname);
    }

    public boolean hasProp(QualifiedName qname) {
        if (!this.getObjs().isEmpty() && !TypeWithPropertiesStatics.hasProp(this.getObjs(), qname)) {
            return false;
        }
        if (!this.getEnums().isEmpty() && !TypeWithPropertiesStatics.hasProp(this.getEnums(), qname)) {
            return false;
        }
        return !this.getEnums().isEmpty() || !this.getObjs().isEmpty();
    }

    public boolean hasConstantProp(QualifiedName pname) {
        Preconditions.checkArgument((boolean)pname.isIdentifier());
        return TypeWithPropertiesStatics.hasConstantProp(this.getObjs(), pname) || TypeWithPropertiesStatics.hasConstantProp(this.getEnums(), pname);
    }

    public JSType withoutProperty(QualifiedName qname) {
        return this.getObjs().isEmpty() ? this : JSType.makeType(this.getMask(), ObjectType.withoutProperty(this.getObjs(), qname), this.getTypeVar(), this.getEnums());
    }

    public JSType withProperty(QualifiedName qname, JSType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        if (this.isUnknown() || this.isBottom() || this.getObjs().isEmpty()) {
            return this;
        }
        return JSType.makeType(this.getMask(), ObjectType.withProperty(this.getObjs(), qname, type), this.getTypeVar(), this.getEnums());
    }

    public JSType withDeclaredProperty(QualifiedName qname, JSType type, boolean isConstant) {
        Preconditions.checkState((!this.getObjs().isEmpty() ? 1 : 0) != 0);
        if (type == null && isConstant) {
            type = UNKNOWN;
        }
        return JSType.makeType(this.getMask(), ObjectType.withDeclaredProperty(this.getObjs(), qname, type, isConstant), this.getTypeVar(), this.getEnums());
    }

    public JSType withPropertyRequired(String pname) {
        return this.isUnknown() || this.getObjs().isEmpty() ? this : JSType.makeType(this.getMask(), ObjectType.withPropertyRequired(this.getObjs(), pname), this.getTypeVar(), this.getEnums());
    }

    public String toString() {
        if (mockToString) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.typeToString(builder);
    }

    private StringBuilder typeToString(StringBuilder builder) {
        switch (this.getMask()) {
            case 0: {
                return builder.append("bottom");
            }
            case -1: {
                return builder.append("*");
            }
            case 0x7FFFFFFF: {
                return builder.append("?");
            }
        }
        int tags = this.getMask();
        boolean firstIteration = true;
        block15: for (int tag = 1; tag != 512; tag <<= 1) {
            if ((tags & tag) == 0) continue;
            if (!firstIteration) {
                builder.append('|');
            }
            firstIteration = false;
            switch (tag) {
                case 8: 
                case 16: {
                    builder.append("boolean");
                    tags &= 0xFFFFFFE7;
                    continue block15;
                }
                case 32: {
                    builder.append("null");
                    tags &= 0xFFFFFFDF;
                    continue block15;
                }
                case 64: {
                    builder.append("number");
                    tags &= 0xFFFFFFBF;
                    continue block15;
                }
                case 128: {
                    builder.append("string");
                    tags &= 0xFFFFFF7F;
                    continue block15;
                }
                case 256: {
                    builder.append("undefined");
                    tags &= 0xFFFFFEFF;
                    continue block15;
                }
                case 1: {
                    builder.append(UniqueNameGenerator.getOriginalName(this.getTypeVar()));
                    tags &= 0xFFFFFFFE;
                    continue block15;
                }
                case 2: {
                    TreeSet<String> strReps;
                    if (this.getObjs().size() == 1) {
                        ((ObjectType)Iterables.getOnlyElement(this.getObjs())).appendTo(builder);
                    } else {
                        strReps = new TreeSet<String>();
                        for (ObjectType obj : this.getObjs()) {
                            strReps.add(obj.toString());
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFD;
                    continue block15;
                }
                case 4: {
                    TreeSet<String> strReps;
                    if (this.getEnums().size() == 1) {
                        builder.append(Iterables.getOnlyElement(this.getEnums()));
                    } else {
                        strReps = new TreeSet();
                        for (EnumType e : this.getEnums()) {
                            strReps.add(e.toString());
                        }
                        PIPE_JOINER.appendTo(builder, strReps);
                    }
                    tags &= 0xFFFFFFFB;
                    continue block15;
                }
            }
        }
        if (tags == 0) {
            return builder;
        }
        if (tags == 512) {
            return builder.append("truthy");
        }
        if (tags == 1024) {
            return builder.append("falsy");
        }
        return builder.append("Unrecognized type: " + tags);
    }

    @Override
    public boolean isConstructor() {
        FunctionType ft = this.getFunTypeIfSingletonObj();
        return ft != null && ft.isUniqueConstructor();
    }

    @Override
    public boolean isEquivalentTo(TypeI type) {
        return this.equals(type);
    }

    @Override
    public boolean isFunctionType() {
        return this.getFunTypeIfSingletonObj() != null;
    }

    @Override
    public boolean isInterface() {
        return this.isInterfaceDefinition();
    }

    @Override
    public boolean isUnknownType() {
        return this.isUnknown();
    }

    @Override
    public TypeI restrictByNotNullOrUndefined() {
        throw new UnsupportedOperationException("restrictByNotNullOrUndefined not implemented yet.");
    }

    @Override
    public FunctionTypeI toMaybeFunctionType() {
        throw new UnsupportedOperationException("toMaybeFunctionType not implemented yet.");
    }

    @Override
    public ObjectTypeI toMaybeObjectType() {
        throw new UnsupportedOperationException("toMaybeObjectType not implemented yet.");
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Preconditions.checkArgument((boolean)(o instanceof JSType));
        JSType t2 = (JSType)o;
        return this.getMask() == t2.getMask() && Objects.equals(this.getObjs(), t2.getObjs()) && Objects.equals(this.getEnums(), t2.getEnums()) && Objects.equals(this.getTypeVar(), t2.getTypeVar());
    }

    public int hashCode() {
        return Objects.hash(this.getMask(), this.getObjs(), this.getEnums(), this.getTypeVar());
    }
}

