/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class SubstituteEs6Syntax
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;

    public SubstituteEs6Syntax(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        this.hotSwapScript(root, null);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isArrowFunction()) break;
                this.maybeSimplifyArrowFunctionBody(n, n.getLastChild());
            }
        }
    }

    private void maybeSimplifyArrowFunctionBody(Node arrowFunction, Node body) {
        Preconditions.checkArgument((boolean)arrowFunction.isArrowFunction());
        if (!body.isBlock() || body.getChildCount() != 1 || !body.getFirstChild().isReturn()) {
            return;
        }
        Node returnValue = body.getFirstChild().removeFirstChild();
        arrowFunction.replaceChild(body, returnValue != null ? returnValue : IR.name("undefined"));
        this.compiler.reportCodeChange();
    }
}

