/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

final class CheckJSDoc
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    public static final DiagnosticType MISPLACED_MSG_ANNOTATION = DiagnosticType.disabled("JSC_MISPLACED_MSG_ANNOTATION", "Misplaced message annotation. @desc, @hidden, and @meaning annotations should onlybe on message nodes.");
    public static final DiagnosticType MISPLACED_ANNOTATION = DiagnosticType.warning("JSC_MISPLACED_ANNOTATION", "Misplaced {0} annotation. {1}");
    public static final DiagnosticType ANNOTATION_DEPRECATED = DiagnosticType.warning("JSC_ANNOTATION_DEPRECATED", "The {0} annotation is deprecated. {1}");
    public static final DiagnosticType DISALLOWED_MEMBER_JSDOC = DiagnosticType.warning("JSC_DISALLOWED_MEMBER_JSDOC", "Class level JSDocs (@interface, @extends, etc.) are not allowed on class members");
    static final DiagnosticType ARROW_FUNCTION_AS_CONSTRUCTOR = DiagnosticType.error("JSC_ARROW_FUNCTION_AS_CONSTRUCTOR", "Arrow functions cannot be used as constructors");
    static final DiagnosticType DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL = DiagnosticType.error("JSC_DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL", "Inline JSDoc on default parameters must be marked as optional");
    private final AbstractCompiler compiler;

    CheckJSDoc(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseEs6(this.compiler, externs, this);
        NodeTraversal.traverseEs6(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverseEs6(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info = n.getJSDocInfo();
        this.validateTypeAnnotations(n, info);
        this.validateFunctionJsDoc(n, info);
        this.validateMsgJsDoc(n, info);
        this.validateDeprecatedJsDoc(n, info);
        this.validateNoCollapse(n, info);
        this.validateClassLevelJsDoc(n, info);
        this.validateArrowFunction(n);
        this.validateDefaultValue(n, info);
        this.validateTempates(n, info);
        this.validateNoSideEffects(n, info);
    }

    private void validateTempates(Node n, JSDocInfo info) {
        if (!(info == null || info.getTemplateTypeNames().isEmpty() || info.isConstructorOrInterface() || this.isClassDecl(n) || info.containsFunctionDeclaration())) {
            if (this.isFunctionDecl(n)) {
                this.reportMisplaced(n, "template", "The template variable is unused. Please remove the @template annotation.");
            } else {
                this.reportMisplaced(n, "template", "@template is only allowed in class, constructor, interface, function or method declarations");
            }
        }
    }

    private boolean isFunctionDecl(Node n) {
        return n.isFunction() || n.isVar() && n.getFirstFirstChild() != null && n.getFirstFirstChild().isFunction() || n.isAssign() && n.getFirstChild().isQualifiedName() && n.getLastChild().isFunction();
    }

    private boolean isClassDecl(Node n) {
        return this.isClass(n) || n.isAssign() && this.isClass(n.getLastChild()) || NodeUtil.isNameDeclaration(n) && this.isNameIntializeWithClass(n.getFirstChild()) || this.isNameIntializeWithClass(n);
    }

    private boolean isNameIntializeWithClass(Node n) {
        return n != null && n.isName() && n.hasChildren() && this.isClass(n.getFirstChild());
    }

    private boolean isClass(Node n) {
        return n.isClass() || n.isCall() && this.compiler.getCodingConvention().isClassFactoryCall(n);
    }

    private void validateClassLevelJsDoc(Node n, JSDocInfo info) {
        if (info != null && n.isMemberFunctionDef() && this.hasClassLevelJsDoc(info)) {
            this.report(n, DISALLOWED_MEMBER_JSDOC, new String[0]);
        }
    }

    private boolean hasClassLevelJsDoc(JSDocInfo info) {
        return info.isConstructorOrInterface() || info.hasBaseType() || info.getImplementedInterfaceCount() != 0 || info.getExtendedInterfacesCount() != 0;
    }

    private void validateDeprecatedJsDoc(Node n, JSDocInfo info) {
        if (info != null && info.isExpose()) {
            this.report(n, ANNOTATION_DEPRECATED, "@expose", "Use @nocollapse or @export instead.");
        }
    }

    private void validateNoCollapse(Node n, JSDocInfo info) {
        if (n.isFromExterns()) {
            if (info != null && info.isNoCollapse()) {
                this.reportMisplaced(n, "nocollapse", "This JSDoc has no effect in externs.");
            }
            return;
        }
        if (!NodeUtil.isPrototypePropertyDeclaration(n.getParent())) {
            return;
        }
        JSDocInfo jsdoc = n.getJSDocInfo();
        if (jsdoc != null && jsdoc.isNoCollapse()) {
            this.reportMisplaced(n, "nocollapse", "This JSDoc has no effect on prototype properties.");
        }
    }

    private void validateFunctionJsDoc(Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.containsFunctionDeclaration() && !info.hasType()) {
            switch (n.getType()) {
                case 105: 
                case 118: 
                case 147: 
                case 148: 
                case 149: 
                case 154: 
                case 160: 
                case 162: 
                case 169: 
                case 175: {
                    return;
                }
                case 33: 
                case 35: {
                    if (!n.getFirstChild().isQualifiedName()) break;
                    return;
                }
                case 86: {
                    return;
                }
            }
            this.reportMisplaced(n, "function", "This JSDoc is not attached to a function node. Are you missing parentheses?");
        }
    }

    private void validateMsgJsDoc(Node n, JSDocInfo info) {
        if (info == null) {
            return;
        }
        if (info.getDescription() != null || info.isHidden() || info.getMeaning() != null) {
            boolean descOkay = false;
            switch (n.getType()) {
                case 86: {
                    Node lhs = n.getFirstChild();
                    if (lhs.isName()) {
                        descOkay = lhs.getString().startsWith("MSG_");
                        break;
                    }
                    if (!lhs.isQualifiedName()) break;
                    descOkay = lhs.getLastChild().getString().startsWith("MSG_");
                    break;
                }
                case 118: 
                case 149: 
                case 162: {
                    descOkay = n.getFirstChild().getString().startsWith("MSG_");
                    break;
                }
                case 154: {
                    descOkay = n.getString().startsWith("MSG_");
                }
            }
            if (!descOkay) {
                this.report(n, MISPLACED_MSG_ANNOTATION, new String[0]);
            }
        }
    }

    private void validateTypeAnnotations(Node n, JSDocInfo info) {
        if (info != null && info.hasType()) {
            boolean valid = false;
            switch (n.getType()) {
                case 105: {
                    valid = NodeUtil.isFunctionDeclaration(n);
                    break;
                }
                case 38: 
                case 156: 
                case 157: 
                case 179: {
                    Node parent = n.getParent();
                    switch (parent.getType()) {
                        case 83: 
                        case 105: 
                        case 118: 
                        case 120: 
                        case 147: 
                        case 148: 
                        case 149: 
                        case 162: {
                            valid = true;
                        }
                    }
                    break;
                }
                case 118: 
                case 147: 
                case 148: 
                case 149: 
                case 154: 
                case 155: 
                case 162: 
                case 169: {
                    valid = true;
                    break;
                }
                case 86: {
                    Node lvalue = n.getFirstChild();
                    valid = n.getParent().isExprResult() && (lvalue.isGetProp() || lvalue.isGetElem() || lvalue.matchesQualifiedName("exports"));
                    break;
                }
                case 33: {
                    valid = n.getParent().isExprResult() && n.isQualifiedName();
                    break;
                }
                case 37: {
                    valid = info.isDefine();
                    break;
                }
            }
            if (!valid) {
                this.reportMisplaced(n, "type", "Type annotations are not allowed here. Are you missing parentheses?");
            }
        }
    }

    private void reportMisplaced(Node n, String annotationName, String note) {
        this.compiler.report(JSError.make(n, MISPLACED_ANNOTATION, annotationName, note));
    }

    private void report(Node n, DiagnosticType type, String ... arguments) {
        this.compiler.report(JSError.make(n, type, arguments));
    }

    private void validateArrowFunction(Node n) {
        JSDocInfo info;
        if (n.isArrowFunction() && (info = NodeUtil.getBestJSDocInfo(n)) != null && info.isConstructorOrInterface()) {
            this.report(n, ARROW_FUNCTION_AS_CONSTRUCTOR, new String[0]);
        }
    }

    private void validateDefaultValue(Node n, JSDocInfo info) {
        if (n.isDefaultValue() && n.getParent().isParamList() && info != null) {
            JSTypeExpression typeExpr = info.getType();
            if (typeExpr == null) {
                return;
            }
            Node typeNode = typeExpr.getRoot();
            if (typeNode.getType() != 307) {
                this.report(typeNode, DEFAULT_PARAM_MUST_BE_MARKED_OPTIONAL, new String[0]);
            }
        }
    }

    private void validateNoSideEffects(Node n, JSDocInfo info) {
        if (info != null && info.isNoSideEffects() && !n.isFromExterns()) {
            this.reportMisplaced(n, "nosideeffects", "@nosideeffects is only supported in externs.");
        }
    }
}

