/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.as2cs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.PrecedenceManager;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.xtext.base.as2cs.AS2CS;
import org.eclipse.ocl.xtext.base.as2cs.AliasAnalysis;
import org.eclipse.ocl.xtext.base.as2cs.BaseDeclarationVisitor;
import org.eclipse.ocl.xtext.base.as2cs.BaseReferenceVisitor;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.AnnotationCS;
import org.eclipse.ocl.xtext.basecs.BaseCSFactory;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ClassCS;
import org.eclipse.ocl.xtext.basecs.ConstraintCS;
import org.eclipse.ocl.xtext.basecs.DetailCS;
import org.eclipse.ocl.xtext.basecs.ElementCS;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.ocl.xtext.basecs.MultiplicityCS;
import org.eclipse.ocl.xtext.basecs.NamedElementCS;
import org.eclipse.ocl.xtext.basecs.PackageCS;
import org.eclipse.ocl.xtext.basecs.PathElementCS;
import org.eclipse.ocl.xtext.basecs.PathElementWithURICS;
import org.eclipse.ocl.xtext.basecs.PathNameCS;
import org.eclipse.ocl.xtext.basecs.RootCS;
import org.eclipse.ocl.xtext.basecs.StructuralFeatureCS;
import org.eclipse.ocl.xtext.basecs.TemplateBindingCS;
import org.eclipse.ocl.xtext.basecs.TemplateSignatureCS;
import org.eclipse.ocl.xtext.basecs.TypedElementCS;
import org.eclipse.ocl.xtext.basecs.TypedRefCS;
import org.eclipse.ocl.xtext.basecs.TypedTypeRefCS;

public class AS2CSConversion
extends AbstractConversion
implements PivotConstantsInternal {
    private static final Logger logger = Logger.getLogger(AS2CSConversion.class);
    protected final @NonNull AS2CS converter;
    protected final @NonNull BaseDeclarationVisitor defaultDeclarationVisitor;
    protected final @NonNull BaseReferenceVisitor defaultExpressionVisitor;
    protected final @NonNull BaseReferenceVisitor defaultReferenceVisitor;
    private Class scope = null;
    private final @NonNull Map<@NonNull EClass, @NonNull BaseDeclarationVisitor> declarationVisitorMap = new HashMap<EClass, BaseDeclarationVisitor>();
    private final @NonNull Map<EClass, BaseReferenceVisitor> expressionVisitorMap = new HashMap<EClass, BaseReferenceVisitor>();
    private final @NonNull Map<@NonNull EClass, @NonNull BaseReferenceVisitor> referenceVisitorMap = new HashMap<EClass, BaseReferenceVisitor>();
    private Map<@NonNull Namespace, @NonNull List<@NonNull String>> importedNamespaces = null;
    private @Nullable BaseCSResource csResource = null;

    public AS2CSConversion(@NonNull AS2CS converter) {
        super(converter.getEnvironmentFactory());
        this.converter = converter;
        this.defaultDeclarationVisitor = converter.createDefaultDeclarationVisitor(this);
        this.defaultExpressionVisitor = converter.createDefaultExpressionVisitor(this);
        this.defaultReferenceVisitor = converter.createDefaultReferenceVisitor(this);
    }

    protected void addBooleanQualifier(@NonNull List<@NonNull String> qualifiers, @NonNull DetailCS csDetail, @NonNull String csString) {
        EList<String> values = csDetail.getValues();
        if (values.size() == 1 && Boolean.valueOf((String)values.get(0)).booleanValue()) {
            qualifiers.add(csString);
        } else {
            qualifiers.add("!" + csString);
        }
    }

    public void createImports(@NonNull RootCS documentCS, @NonNull Map<@NonNull Namespace, @NonNull List<@NonNull String>> importedNamespaces) {
        String alias;
        BaseCSResource csResource = (BaseCSResource)ClassUtil.nonNullState((Object)documentCS.eResource());
        AliasAnalysis.dispose((Resource)csResource);
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.findEnvironmentFactory((Resource)csResource);
        if (environmentFactory == null) {
            throw new IllegalStateException("No EnvironmentFactory");
        }
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        AliasAnalysis aliasAnalysis = null;
        URI csURI = csResource.getURI();
        ArrayList<@NonNull ImportCS> imports = new ArrayList<ImportCS>();
        ArrayList<@NonNull Namespace> sortedImportedNamespaces = new ArrayList<Namespace>(importedNamespaces.keySet());
        Collections.sort(sortedImportedNamespaces, NameUtil.NAMEABLE_COMPARATOR);
        for (Namespace importedNamespace : sortedImportedNamespaces) {
            EPackage ePackage;
            Resource resource;
            List<String> aliases;
            if (importedNamespace instanceof Package) {
                Package pivotPackage = metamodelManager.getCompletePackage((Package)importedNamespace).getPrimaryPackage();
                if (metamodelManager.getLibraries().contains(pivotPackage)) continue;
            }
            if ((aliases = importedNamespaces.get(importedNamespace)) == null || aliases.isEmpty()) {
                if (aliasAnalysis == null) {
                    aliasAnalysis = AliasAnalysis.getAdapter((Resource)csResource, environmentFactory);
                }
                aliases = (alias = aliasAnalysis.getAlias((EObject)importedNamespace, null)) != null ? Collections.singletonList(alias) : Collections.emptyList();
            }
            EObject eObject = importedNamespace.getESObject();
            String importURI = null;
            if (eObject instanceof EPackage && ClassUtil.isRegistered((Resource)(resource = (ePackage = (EPackage)eObject).eResource()))) {
                importURI = ePackage.getNsURI();
            }
            if (importURI == null) {
                URI fullURI = EcoreUtil.getURI((EObject)(eObject != null ? eObject : importedNamespace));
                URI deresolvedURI = fullURI.deresolve(csURI, true, true, false);
                importURI = deresolvedURI.toString();
            }
            for (String alias2 : aliases) {
                ImportCS importCS = BaseCSFactory.eINSTANCE.createImportCS();
                importCS.setName(alias2);
                PathNameCS csPathName = BaseCSFactory.eINSTANCE.createPathNameCS();
                importCS.setOwnedPathName(csPathName);
                EList<PathElementCS> csPath = csPathName.getOwnedPathElements();
                PathElementWithURICS csSimpleRef = BaseCSFactory.eINSTANCE.createPathElementWithURICS();
                csPath.add(csSimpleRef);
                csSimpleRef.setReferredElement((Element)importedNamespace);
                csSimpleRef.setUri(importURI);
                importCS.setPivot((Element)importedNamespace);
                imports.add(importCS);
            }
        }
        if (aliasAnalysis != null) {
            aliasAnalysis.dispose();
        }
        aliasAnalysis = AliasAnalysis.getAdapter((Resource)csResource, metamodelManager.getEnvironmentFactory());
        for (ImportCS csImport : imports) {
            Namespace namespace = csImport.getReferredNamespace();
            alias = csImport.getName();
            if (namespace == null || alias != null) continue;
            alias = aliasAnalysis.getAlias((EObject)namespace, null);
            if (alias == null) {
                String name;
                String hint = null;
                if (namespace instanceof Package) {
                    hint = ((Package)namespace).getNsPrefix();
                }
                if (hint == null && (name = namespace.getName()).length() > 0) {
                    hint = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
                }
                if (hint != null) {
                    alias = aliasAnalysis.getAlias((EObject)namespace, hint);
                }
            }
            if (alias == null) continue;
            csImport.setName(alias);
        }
        Collections.sort(imports, new Comparator<ImportCS>(){

            @Override
            public int compare(@NonNull ImportCS o1, @NonNull ImportCS o2) {
                int d2;
                Namespace ns1 = o1.getReferredNamespace();
                Namespace ns2 = o2.getReferredNamespace();
                int d1 = PivotUtil.getContainmentDepth((EObject)ns1);
                if (d1 != (d2 = PivotUtil.getContainmentDepth((EObject)ns2))) {
                    return d1 - d2;
                }
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        for (ImportCS csImport : imports) {
            String alias3 = csImport.getName();
            if (alias3.length() != 0) continue;
            csImport.setName(null);
        }
        documentCS.getOwnedImports().addAll(imports);
    }

    public @Nullable BaseCSResource getCSResource() {
        return this.csResource;
    }

    public @NonNull AS2CS getConverter() {
        return this.converter;
    }

    public @Nullable BaseDeclarationVisitor getDeclarationVisitor(@NonNull EClass eClass) {
        BaseDeclarationVisitor declarationVisitor = this.declarationVisitorMap.get(eClass);
        if (declarationVisitor == null && !this.declarationVisitorMap.containsKey(eClass)) {
            AS2CS.Factory factory = this.converter.getFactory(eClass);
            declarationVisitor = factory != null ? factory.createDeclarationVisitor(this) : this.defaultDeclarationVisitor;
            this.declarationVisitorMap.put(eClass, declarationVisitor);
        }
        return declarationVisitor;
    }

    public @Nullable BaseReferenceVisitor getExpressionVisitor(@NonNull EClass eClass, @Nullable Namespace scope) {
        if (scope == null) {
            BaseReferenceVisitor expressionVisitor = this.expressionVisitorMap.get(eClass);
            if (expressionVisitor == null && !this.expressionVisitorMap.containsKey(eClass)) {
                AS2CS.Factory factory = this.converter.getFactory(eClass);
                expressionVisitor = factory != null ? factory.createExpressionVisitor(this, null) : this.defaultExpressionVisitor;
                this.expressionVisitorMap.put(eClass, expressionVisitor);
            }
            return expressionVisitor;
        }
        AS2CS.Factory factory = this.converter.getFactory(eClass);
        if (factory != null) {
            return factory.createExpressionVisitor(this, scope);
        }
        return this.defaultExpressionVisitor;
    }

    public @NonNull PrecedenceManager getPrecedenceManager() {
        return this.metamodelManager.getPrecedenceManager();
    }

    public @Nullable BaseReferenceVisitor getReferenceVisitor(@NonNull EClass eClass, @Nullable Namespace scope) {
        if (scope == null) {
            BaseReferenceVisitor referenceVisitor = this.referenceVisitorMap.get(eClass);
            if (referenceVisitor == null && !this.referenceVisitorMap.containsKey(eClass)) {
                AS2CS.Factory factory = this.converter.getFactory(eClass);
                referenceVisitor = factory != null ? factory.createReferenceVisitor(this, null) : this.defaultReferenceVisitor;
                this.referenceVisitorMap.put(eClass, referenceVisitor);
            }
            return referenceVisitor;
        }
        AS2CS.Factory factory = this.converter.getFactory(eClass);
        if (factory != null) {
            return factory.createReferenceVisitor(this, scope);
        }
        return this.defaultReferenceVisitor;
    }

    public Class getScope() {
        return this.scope;
    }

    protected @NonNull List<@NonNull TemplateBindingCS> getTemplateBindings(ElementCS csElement) {
        TypedTypeRefCS csTemplateableElement;
        TemplateBindingCS csTemplateBinding;
        ArrayList<@NonNull TemplateBindingCS> csTemplateBindings = new ArrayList<TemplateBindingCS>();
        if (csElement instanceof TypedTypeRefCS && (csTemplateBinding = (csTemplateableElement = (TypedTypeRefCS)csElement).getOwnedBinding()) != null) {
            csTemplateBindings.add(csTemplateBinding);
        }
        return csTemplateBindings;
    }

    public void importNamespace(@NonNull Namespace importNamespace, @Nullable String alias) {
        Namespace primaryNamespace = (Namespace)this.metamodelManager.getPrimaryElement((EObject)importNamespace);
        List<@NonNull String> aliases = this.importedNamespaces.get(primaryNamespace);
        if (aliases == null) {
            aliases = new ArrayList<String>();
            this.importedNamespaces.put(primaryNamespace, aliases);
        }
        if (alias != null && !aliases.contains(alias)) {
            aliases.add(alias);
        }
    }

    protected <T extends ClassCS> T refreshClassifier(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull Class object) {
        ClassCS csElement = (ClassCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        List<@NonNull ConstraintCS> csInvariants = this.visitDeclarations(ConstraintCS.class, object.getOwnedInvariants(), null);
        for (ConstraintCS csInvariant : csInvariants) {
            csInvariant.setStereotype("invariant");
        }
        this.refreshList((List)csElement.getOwnedConstraints(), csInvariants);
        TemplateSignature ownedTemplateSignature = object.getOwnedSignature();
        if (ownedTemplateSignature != null) {
            csElement.setOwnedSignature(this.visitDeclaration(TemplateSignatureCS.class, (EObject)ownedTemplateSignature));
        }
        if (object.eIsSet((EStructuralFeature)PivotPackage.Literals.CLASS__INSTANCE_CLASS_NAME)) {
            csElement.setInstanceClassName(object.getInstanceClassName());
        } else {
            csElement.eUnset((EStructuralFeature)BaseCSPackage.Literals.CLASS_CS__INSTANCE_CLASS_NAME);
        }
        return (T)csElement;
    }

    public <T extends ModelElementCS> T refreshElement(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull Element object) {
        assert (csClass == csEClass.getInstanceClass());
        EFactory eFactoryInstance = csEClass.getEPackage().getEFactoryInstance();
        ModelElementCS csElement = (ModelElementCS)eFactoryInstance.create(csEClass);
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            throw new ClassCastException();
        }
        csElement.setPivot(object);
        ModelElementCS castElement = csElement;
        return (T)castElement;
    }

    public <T extends NamedElementCS> T refreshNamedElement(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull NamedElement object) {
        return this.refreshNamedElement(csClass, csEClass, object, "\u00abnull\u00bb");
    }

    public <T extends NamedElementCS> T refreshNamedElement(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull NamedElement object, @Nullable String replacementNameForNull) {
        NamedElementCS csElement = (NamedElementCS)this.refreshElement(csClass, csEClass, (Element)object);
        String name = object.getName();
        if (name == null) {
            name = replacementNameForNull;
        }
        csElement.setName(name);
        this.refreshList((List)csElement.getOwnedAnnotations(), this.visitDeclarations(AnnotationCS.class, object.getOwnedAnnotations(), null));
        return (T)csElement;
    }

    public void refreshPathName(@NonNull PathNameCS csPathName, @NonNull Element element, @Nullable Namespace scope) {
        Namespace safeScope = scope;
        Element primaryElement = (Element)this.metamodelManager.getPrimaryElement((EObject)element);
        if (safeScope != null && primaryElement instanceof Type) {
            String name = ((Type)primaryElement).getName();
            Namespace eObject = safeScope;
            while (eObject != null) {
                CompletePackage completePackage;
                Class memberType;
                if (eObject instanceof Namespace) {
                    safeScope = eObject;
                }
                if (eObject instanceof Package && (memberType = (completePackage = this.metamodelManager.getCompletePackage((Package)eObject)).getMemberType(name)) == primaryElement) {
                    if (eObject != scope && eObject != PivotUtil.getContainingPackage((EObject)scope)) {
                        eObject = eObject.eContainer();
                    }
                    if (!(eObject instanceof Namespace)) break;
                    safeScope = eObject;
                    break;
                }
                eObject = eObject.eContainer();
            }
        }
        EList<PathElementCS> csPath = csPathName.getOwnedPathElements();
        csPath.clear();
        PathElementCS csSimpleRef = BaseCSFactory.eINSTANCE.createPathElementCS();
        csPath.add(csSimpleRef);
        csSimpleRef.setReferredElement(primaryElement);
        BaseCSResource csResource2 = this.csResource;
        if (csResource2 == null || csResource2.isPathable((EObject)primaryElement) == null) {
            return;
        }
        EObject eContainer = primaryElement.eContainer();
        while (eContainer instanceof Element) {
            if (eContainer instanceof Model) {
                return;
            }
            Namespace aScope = safeScope;
            while (aScope != null) {
                if (this.metamodelManager.getPrimaryElement((EObject)aScope) == this.metamodelManager.getPrimaryElement(eContainer)) {
                    return;
                }
                aScope = aScope.eContainer();
            }
            csSimpleRef = BaseCSFactory.eINSTANCE.createPathElementCS();
            csPath.add(0, csSimpleRef);
            csSimpleRef.setReferredElement((Element)eContainer);
            eContainer = eContainer.eContainer();
        }
    }

    public void refreshQualifiers(List<String> qualifiers, String string, boolean polarity) {
        for (String qualifier : qualifiers) {
            if (!qualifier.equals(string)) continue;
            if (!polarity) {
                qualifiers.remove(qualifier);
            }
            return;
        }
        if (polarity) {
            qualifiers.add(string);
        }
    }

    public void refreshQualifiers(@NonNull List<@NonNull String> qualifiers, @NonNull String trueString, @NonNull String falseString, @Nullable Boolean polarity) {
        boolean isFalse = false;
        boolean isTrue = false;
        for (String qualifier : qualifiers) {
            if (qualifier.equals(trueString)) {
                if (isTrue || polarity != Boolean.TRUE) {
                    qualifiers.remove(qualifier);
                }
                isTrue = true;
            }
            if (!qualifier.equals(falseString)) continue;
            if (isTrue || polarity != Boolean.FALSE) {
                qualifiers.remove(qualifier);
            }
            isFalse = true;
        }
        if (polarity == Boolean.TRUE) {
            if (!isTrue) {
                qualifiers.add(trueString);
            }
        } else if (polarity == Boolean.FALSE && !isFalse) {
            qualifiers.add(falseString);
        }
    }

    public <T extends StructuralFeatureCS> T refreshStructuralFeature(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull Property object) {
        StructuralFeatureCS csElement = (StructuralFeatureCS)this.refreshTypedElement(csClass, csEClass, (TypedElement)object);
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "derived", object.isIsDerived());
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "readonly", object.isIsReadOnly());
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "static", object.isIsStatic());
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "transient", object.isIsTransient());
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "unsettable", object.isIsUnsettable());
        this.refreshQualifiers((List<String>)csElement.getQualifiers(), "volatile", object.isIsVolatile());
        csElement.setDefault(object.getDefaultValueString());
        return (T)csElement;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public <T extends TypedElementCS> T refreshTypedElement(@NonNull java.lang.Class<T> csClass, EClass csEClass, @NonNull TypedElement object) {
        Object elementType;
        boolean isEMap;
        TypedElementCS csElement = (TypedElementCS)this.refreshNamedElement(csClass, csEClass, (NamedElement)object);
        Type type = object.getType();
        boolean bl = isEMap = type instanceof MapType && ((MapType)type).getEntryClass() != null;
        if (isEMap) {
            elementType = ((MapType)type).getEntryClass();
        } else if (type instanceof CollectionType && ((CollectionType)type).getUnspecializedElement() != this.standardLibrary.getCollectionType()) {
            PivotUtil.debugWellContainedness((Type)type);
            elementType = ((CollectionType)type).getElementType();
        } else {
            elementType = type instanceof VoidType ? null : type;
        }
        if (elementType != null) {
            PivotUtil.debugWellContainedness((Type)elementType);
            TypedRefCS typeRef = this.visitReference(TypedRefCS.class, (EObject)elementType, null);
            csElement.setOwnedType(typeRef);
        } else {
            csElement.setOwnedType(null);
        }
        TypedRefCS csTypeRef = csElement.getOwnedType();
        if (csTypeRef != null) {
            MultiplicityCS csMultiplicity;
            int upper;
            int lower;
            boolean isNullFree;
            if (isEMap) {
                isNullFree = true;
                lower = object.isIsRequired() ? 1 : 0;
                upper = -1;
                @NonNull EList qualifiers = ClassUtil.nullFree(csElement.getQualifiers());
                this.refreshQualifiers((List<String>)qualifiers, "ordered", "!ordered", Boolean.TRUE);
                this.refreshQualifiers((List<String>)qualifiers, "unique", "!unique", Boolean.TRUE);
            } else if (type instanceof CollectionType && ((CollectionType)type).getUnspecializedElement() != this.standardLibrary.getCollectionType()) {
                CollectionType collectionType = (CollectionType)type;
                isNullFree = collectionType.isIsNullFree();
                lower = collectionType.getLower().intValue();
                Number upper2 = collectionType.getUpper();
                upper = upper2 instanceof Unlimited ? -1 : upper2.intValue();
                @NonNull EList qualifiers = ClassUtil.nullFree(csElement.getQualifiers());
                this.refreshQualifiers((List<String>)qualifiers, "ordered", "!ordered", collectionType.isOrdered() ? Boolean.TRUE : null);
                this.refreshQualifiers((List<String>)qualifiers, "unique", "!unique", collectionType.isUnique() ? null : Boolean.FALSE);
            } else {
                isNullFree = false;
                lower = object.isIsRequired() ? 1 : 0;
                upper = 1;
            }
            String stringValue = null;
            if (lower == 0) {
                if (upper == 1) {
                    stringValue = "?";
                } else if (upper == -1) {
                    stringValue = "*";
                }
            } else if (lower == 1 && upper == -1) {
                stringValue = "+";
            }
            if (stringValue != null) {
                csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityStringCS();
                csMultiplicity.setStringBounds(stringValue);
                csMultiplicity.setIsNullFree(isNullFree);
                csTypeRef.setOwnedMultiplicity(csMultiplicity);
            } else {
                csMultiplicity = BaseCSFactory.eINSTANCE.createMultiplicityBoundsCS();
                if (lower != 1) {
                    csMultiplicity.setLowerBound(lower);
                }
                if (upper != lower) {
                    csMultiplicity.setUpperBound(upper);
                }
                csMultiplicity.setIsNullFree(isNullFree);
                csTypeRef.setOwnedMultiplicity(csMultiplicity);
            }
        }
        return (T)csElement;
    }

    public Class setScope(Class object) {
        Class savedScope = this.scope;
        this.scope = object;
        return savedScope;
    }

    public void update(@NonNull BaseCSResource csResource) {
        this.csResource = csResource;
        this.importedNamespaces = new HashMap<Namespace, List<String>>();
        Resource asResource = this.converter.getASResource((Resource)csResource);
        if (asResource != null) {
            List<@NonNull PackageCS> list = this.visitDeclarations((java.lang.Class)PackageCS.class, (Iterable)asResource.getContents(), null);
            this.refreshList((List)csResource.getContents(), list);
            if (this.importedNamespaces != null) {
                this.defaultDeclarationVisitor.postProcess(csResource, this.importedNamespaces);
            }
        }
    }

    public <T extends ElementCS> @Nullable T visitDeclaration(@NonNull java.lang.Class<T> csClass, @Nullable EObject eObject) {
        ElementCS csElement;
        if (eObject == null) {
            return null;
        }
        @NonNull EClass eClass = eObject.eClass();
        BaseDeclarationVisitor declarationVisitor = this.getDeclarationVisitor(eClass);
        if (declarationVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported declaration " + eClass.getName()));
            return null;
        }
        ElementCS castElement = csElement = (ElementCS)((Visitable)eObject).accept((Visitor)declarationVisitor);
        return (T)castElement;
    }

    public <T extends ElementCS, V extends EObject> @Nullable List<@NonNull T> visitDeclarationAsList(@NonNull java.lang.Class<T> csClass, V eObject) {
        if (eObject == null) {
            return null;
        }
        @Nullable T csElement = this.visitDeclaration(csClass, eObject);
        if (csElement == null) {
            return null;
        }
        return Collections.singletonList(csElement);
    }

    public <T extends ElementCS, V extends EObject> @NonNull List<T> visitDeclarations(@NonNull java.lang.Class<T> csClass, Iterable<V> eObjects, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (eObjects != null);
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            T csElement;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (csElement = this.visitDeclaration(csClass, eObject)) == null) continue;
            csElements.add(csElement);
        }
        return csElements;
    }

    public <T extends ElementCS> @Nullable T visitReference(@NonNull java.lang.Class<T> csClass, @NonNull EObject eObject, @Nullable Namespace scope) {
        @NonNull EClass eClass = eObject.eClass();
        BaseReferenceVisitor referenceVisitor = this.getReferenceVisitor(eClass, scope);
        if (referenceVisitor == null || !(eObject instanceof Visitable)) {
            logger.warn((Object)("Unsupported reference " + eObject.eClass().getName()));
            return null;
        }
        if (eObject.eIsProxy()) {
            logger.warn((Object)("Unresolved reference " + ((BasicEObjectImpl)eObject).eProxyURI()));
            return null;
        }
        ElementCS csElement = (ElementCS)((Visitable)eObject).accept((Visitor)referenceVisitor);
        if (csElement == null) {
            return null;
        }
        if (!csClass.isAssignableFrom(csElement.getClass())) {
            logger.error((Object)("CS " + csElement.getClass().getName() + "' element is not a '" + csClass.getName() + "'"));
            return null;
        }
        ElementCS castElement = csElement;
        return (T)castElement;
    }

    public <T extends ElementCS, V extends EObject> @NonNull List<T> visitReferences(@NonNull java.lang.Class<T> csClass, Iterable<? extends V> eObjects, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AbstractConversion.Predicate<V> predicate) {
        assert (eObjects != null);
        ArrayList<T> csElements = new ArrayList<T>();
        for (EObject eObject : eObjects) {
            T csElement;
            if (eObject == null || predicate != null && !predicate.filter(eObject) || (csElement = this.visitReference(csClass, eObject, null)) == null) continue;
            csElements.add(csElement);
        }
        return csElements;
    }
}

